/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint;

import java.util.Vector;
import net.jxta.endpoint.Message;

public class EndpointReceiveQueue {
    public static final int Max_Messages = 100;
    private Vector queue = null;
    private boolean closeFlag = false;
    private int maxNbOfMessages = 100;
    private int nbOfQueuedMessages = 0;

    public EndpointReceiveQueue() {
        this.queue = new Vector(100);
        this.closeFlag = false;
    }

    public EndpointReceiveQueue(int n) {
        this.queue = new Vector(n);
        this.closeFlag = false;
    }

    public synchronized void push(Message message) {
        if (this.closeFlag) {
            return;
        }
        if (this.queue.size() == this.getMaxNbOfMessages()) {
            --this.nbOfQueuedMessages;
            this.queue.removeElementAt(0);
        }
        ++this.nbOfQueuedMessages;
        this.queue.addElement(message);
        this.notifyAll();
    }

    public synchronized Message next() {
        if (this.queue.isEmpty()) {
            return null;
        }
        Message message = (Message)this.queue.firstElement();
        this.queue.removeElementAt(0);
        --this.nbOfQueuedMessages;
        return message;
    }

    public synchronized Message poll(long l) throws InterruptedException {
        if (l < 0L) {
            throw new IllegalArgumentException("timeOut must be >= 0");
        }
        long l2 = System.currentTimeMillis() + l;
        do {
            Message message;
            if (null != (message = this.next())) {
                return message;
            }
            if (this.isClosed()) continue;
            this.wait(l);
            message = this.next();
            if (null != message) {
                return message;
            }
            if (0L != l && (l = l2 - System.currentTimeMillis()) <= 0L) break;
        } while (!this.isClosed());
        return null;
    }

    public Message waitForMessage() throws InterruptedException {
        return this.poll(0L);
    }

    public synchronized boolean isClosed() {
        return this.closeFlag;
    }

    public synchronized void close() {
        this.closeFlag = true;
        this.notifyAll();
    }

    public int getMaxNbOfMessages() {
        int n = this.queue.capacity() < this.maxNbOfMessages ? this.queue.capacity() : this.maxNbOfMessages;
        return n;
    }

    public synchronized void setMaxNbOfMessages(int n) {
        this.maxNbOfMessages = n;
        this.queue.ensureCapacity(n);
    }

    public synchronized int getNbOfQueuedMessages() {
        return this.nbOfQueuedMessages;
    }
}

