/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint;

import java.util.Vector;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointListener;
import net.jxta.endpoint.Message;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public class EndpointDemuxListener
implements EndpointListener,
Runnable {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$endpoint$EndpointDemuxListener == null ? (class$net$jxta$impl$endpoint$EndpointDemuxListener = EndpointDemuxListener.class$("net.jxta.impl.endpoint.EndpointDemuxListener")) : class$net$jxta$impl$endpoint$EndpointDemuxListener).getName());
    public static final int MaxQueueSize = 100;
    private Vector messageQueue = new Vector();
    private boolean keepGoing = true;
    private EndpointListener listener = null;
    private int nbOfQueuedMessages = 0;
    private int nbOfDeQueuedMessages = 0;
    private Thread thread1 = null;
    private Thread thread2 = null;
    private String name = null;
    static /* synthetic */ Class class$net$jxta$impl$endpoint$EndpointDemuxListener;

    private synchronized void enQueue(Message message) {
        if (this.messageQueue.size() > 100) {
            if (LOG.isEnabledFor(Priority.WARN)) {
                LOG.warn((Object)("Dropped one message; destination: " + message.getDestinationAddress().toString()));
            }
            return;
        }
        this.messageQueue.addElement(message);
        ++this.nbOfQueuedMessages;
        this.setThreadName();
        this.notifyAll();
    }

    private synchronized Message deQueue() {
        while (this.messageQueue.size() == 0) {
            if (!this.keepGoing) {
                return null;
            }
            try {
                this.wait();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Object e = this.messageQueue.elementAt(0);
        this.messageQueue.removeElementAt(0);
        ++this.nbOfDeQueuedMessages;
        this.setThreadName();
        return (Message)e;
    }

    public EndpointListener getListener() {
        return this.listener;
    }

    public EndpointDemuxListener(EndpointListener endpointListener) {
        this("Unknown", endpointListener);
    }

    public EndpointDemuxListener(String string, EndpointListener endpointListener) {
        this.listener = endpointListener;
        this.name = string;
        this.thread1 = new Thread((Runnable)this, "EndpointDemuxListener [" + string + "]");
        this.thread2 = new Thread((Runnable)this, "EndpointDemuxListener [" + string + "]");
        this.thread1.start();
        this.thread2.start();
        Thread.yield();
    }

    private void setThreadName() {
        block2: {
            String string = "EndpointDemuxListener [" + this.name + "," + this.messageQueue.size() + "," + this.nbOfQueuedMessages + "," + this.nbOfDeQueuedMessages + "]";
            try {
                this.thread1.setName(string);
                this.thread2.setName(string);
            }
            catch (Exception exception) {
                if (!LOG.isEnabledFor(Priority.ERROR)) break block2;
                LOG.error((Object)"EndpointDemuxListener cannot set thread name ", (Throwable)exception);
            }
        }
    }

    public synchronized void unregistered() {
        this.keepGoing = false;
        this.notifyAll();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            while (true) {
                if (!this.keepGoing) {
                    return;
                }
                Message message = this.deQueue();
                if (!this.keepGoing) {
                    return;
                }
                try {
                    EndpointAddress endpointAddress = message.getSourceAddress();
                    EndpointAddress endpointAddress2 = message.getDestinationAddress();
                    this.listener.processIncomingMessage(message, endpointAddress, endpointAddress2);
                }
                catch (Throwable throwable) {
                    if (!LOG.isEnabledFor(Priority.DEBUG)) continue;
                    LOG.debug((Object)"EndpointDemuxListener caught an exception", throwable);
                }
            }
        }
        catch (Throwable throwable) {
            if (!LOG.isEnabledFor(Priority.FATAL)) return;
            LOG.fatal((Object)("Uncaught Throwable in thread : " + Thread.currentThread().getName()), throwable);
        }
    }

    public void processIncomingMessage(Message message, EndpointAddress endpointAddress, EndpointAddress endpointAddress2) {
        message.setSourceAddress(endpointAddress);
        message.setDestinationAddress(endpointAddress2);
        this.enQueue(message);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

