/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.discovery;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import net.jxta.discovery.DiscoveryService;
import net.jxta.document.TextElement;
import net.jxta.peergroup.PeerGroup;
import net.jxta.protocol.PeerAdvertisement;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public class AdvertisementCompactor
implements Runnable {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$discovery$AdvertisementCompactor == null ? (class$net$jxta$impl$discovery$AdvertisementCompactor = AdvertisementCompactor.class$("net.jxta.impl.discovery.AdvertisementCompactor")) : class$net$jxta$impl$discovery$AdvertisementCompactor).getName());
    private PeerGroup myGroup;
    private int nap = 600000;
    private DiscoveryService discovery = null;
    private Hashtable table;
    private Thread myThread = null;
    private boolean stopping = false;
    static /* synthetic */ Class class$net$jxta$impl$discovery$AdvertisementCompactor;

    public AdvertisementCompactor(PeerGroup peerGroup) {
        this.myGroup = peerGroup;
    }

    public void init() {
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"Start AdvertisementCompactor");
        }
        this.myThread = new Thread((Runnable)new AdvertisementCompactor(this.myGroup), "DiscoveryServiceImpl:AdvertisementCompactor");
        this.myThread.start();
    }

    public void shutdown() {
        this.stopping = true;
        this.myThread.interrupt();
        this.myThread = null;
    }

    public void run() {
        try {
            while (true) {
                if (this.stopping) {
                    if (LOG.isEnabledFor(Priority.DEBUG)) {
                        LOG.debug((Object)"Compactor thread returns.");
                    }
                    return;
                }
                this.discovery = this.myGroup.getDiscoveryService();
                if (this.discovery != null) break;
                this.doze(this.nap);
            }
            while (true) {
                block17: {
                    if (this.stopping) {
                        if (LOG.isEnabledFor(Priority.DEBUG)) {
                            LOG.debug((Object)"Compactor thread returns.");
                        }
                        return;
                    }
                    this.table = new Hashtable(128);
                    try {
                        Enumeration enumeration = this.discovery.getLocalAdvertisements(0, null, null);
                        while (null != enumeration && enumeration.hasMoreElements()) {
                            PeerAdvertisement peerAdvertisement = (PeerAdvertisement)enumeration.nextElement();
                            if (peerAdvertisement.getPeerID().equals(this.myGroup.getPeerID())) continue;
                            TextElement textElement = (TextElement)((Object)peerAdvertisement.getServiceParam(PeerGroup.endpointClassID));
                            Enumeration enumeration2 = textElement != null ? textElement.getChildren("Addr") : new Vector().elements();
                            if (!enumeration2.hasMoreElements()) {
                                this.discovery.flushAdvertisements(peerAdvertisement.getPeerID().toString(), 0);
                                continue;
                            }
                            String string = ((TextElement)enumeration2.nextElement()).getTextValue();
                            if (this.table.get(string) == null) {
                                if (LOG.isEnabledFor(Priority.DEBUG)) {
                                    LOG.debug((Object)("adding :" + string));
                                }
                                this.table.put(string, peerAdvertisement.getPeerID());
                                continue;
                            }
                            if (LOG.isEnabledFor(Priority.DEBUG)) {
                                LOG.debug((Object)("duplicate found :" + string));
                            }
                            this.discovery.flushAdvertisements(peerAdvertisement.getPeerID().toString(), 0);
                            if (!LOG.isEnabledFor(Priority.DEBUG)) continue;
                            LOG.debug((Object)("ejecting :" + peerAdvertisement.getPeerID()));
                        }
                    }
                    catch (IOException iOException) {
                        if (!LOG.isEnabledFor(Priority.DEBUG)) break block17;
                        LOG.debug((Object)iOException);
                    }
                }
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"AdvertisementCompactor Done");
                }
                this.doze(this.nap);
            }
        }
        catch (Throwable throwable) {
            if (LOG.isEnabledFor(Priority.FATAL)) {
                LOG.fatal((Object)("Uncaught Throwable in thread :" + Thread.currentThread().getName()), throwable);
            }
            return;
        }
    }

    private void doze(int n) {
        try {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("AdvertisementCompactor hibernating for:" + n / 1000 / 60 + " min"));
            }
            Thread.sleep(n);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

