/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.config;

import java.util.Enumeration;
import net.jxta.document.Element;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.TextElement;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.impl.config.ConfigUtil;
import net.jxta.impl.endpoint.Address;

public class TcpConfig {
    private static final int DEFAULT_PORT = 6001;
    private static final String MCAST_HOST = "224.0.1.85";
    private static final int MCAST_PORT = 1234;
    private static final int MCAST_DGRAM_SIZE = 8192;
    private static final String DEFAULT_IMPL = "net.jxta.impl.endpoint.tcp.TcpTransport";
    private EndpointAddress mServerAddress;
    private EndpointAddress mMulticastAddress;
    private int mMulticastBufferLen;
    private boolean mUsePublicAddress;
    private EndpointAddress mPublicAddress;
    private EndpointAddress localAddress;
    private String mImplClassname;
    private static final String KEY_SERVER = "Server";
    private static final String KEY_MCAST = "Multicast";
    private static final String KEY_MCAST_BUFF = "MulticastBufferLen";
    private static final String KEY_IMPL = "Impl";

    public void writeToXML(StructuredTextDocument structuredTextDocument) {
        TextElement textElement = structuredTextDocument.createElement("TCP");
        structuredTextDocument.appendChild((Element)textElement);
        ConfigUtil.writeAddress(structuredTextDocument, textElement, this.mServerAddress, KEY_SERVER);
        ConfigUtil.writeAddress(structuredTextDocument, textElement, this.mMulticastAddress, KEY_MCAST);
        TextElement textElement2 = structuredTextDocument.createElement(KEY_MCAST_BUFF, String.valueOf(this.mMulticastBufferLen));
        textElement.appendChild((Element)textElement2);
        ConfigUtil.writeAddress(structuredTextDocument, textElement, this.mPublicAddress, "PublicAddress");
        textElement2 = structuredTextDocument.createElement("UsePublicAddress", String.valueOf(this.mUsePublicAddress));
        textElement.appendChild((Element)textElement2);
        ConfigUtil.writeAddress(structuredTextDocument, textElement, this.localAddress, "LocalAddress");
        textElement2 = structuredTextDocument.createElement(KEY_IMPL, this.mImplClassname);
        textElement.appendChild((Element)textElement2);
    }

    public static TcpConfig createDefaultConfig() {
        TcpConfig tcpConfig = new TcpConfig();
        tcpConfig.setServerAddress(new Address("tcp://localhost:6001"));
        tcpConfig.setMulticastAddress(new Address("tcp://224.0.1.85:1234"));
        tcpConfig.setMulticastBufferLen(8192);
        tcpConfig.setLocalAddress(null);
        tcpConfig.setPublicAddress(null);
        tcpConfig.setUsePublicAddress(false);
        tcpConfig.setImplClassname(DEFAULT_IMPL);
        return tcpConfig;
    }

    public static TcpConfig newFromXML(TextElement textElement) {
        Enumeration enumeration = textElement.getChildren();
        if (enumeration == null) {
            return null;
        }
        TcpConfig tcpConfig = new TcpConfig();
        while (enumeration.hasMoreElements()) {
            TextElement textElement2 = (TextElement)enumeration.nextElement();
            String string = textElement2.getName();
            if (string.equals(KEY_IMPL)) {
                tcpConfig.mImplClassname = textElement2.getTextValue();
            }
            if (string.equals(KEY_MCAST_BUFF)) {
                tcpConfig.mMulticastBufferLen = Integer.valueOf(textElement2.getTextValue());
                continue;
            }
            if (string.equals(KEY_SERVER)) {
                tcpConfig.mServerAddress = new Address(textElement2.getTextValue());
                continue;
            }
            if (string.equals(KEY_MCAST)) {
                tcpConfig.mMulticastAddress = new Address(textElement2.getTextValue());
                continue;
            }
            if (string.equals("PublicAddress")) {
                tcpConfig.mPublicAddress = new Address(textElement2.getTextValue());
                continue;
            }
            if (string.equals("UsePublicAddress")) {
                tcpConfig.mUsePublicAddress = Boolean.valueOf(textElement2.getTextValue());
                continue;
            }
            if (!string.equals("LocalAddress")) continue;
            tcpConfig.localAddress = new Address(textElement2.getTextValue());
        }
        return tcpConfig;
    }

    public EndpointAddress getServerAddress() {
        return this.mServerAddress;
    }

    public void setServerAddress(EndpointAddress endpointAddress) {
        this.mServerAddress = endpointAddress;
    }

    public EndpointAddress getMulticastAddress() {
        return this.mMulticastAddress;
    }

    public void setMulticastAddress(EndpointAddress endpointAddress) {
        this.mMulticastAddress = endpointAddress;
    }

    public int getMulticastBufferLen() {
        return this.mMulticastBufferLen;
    }

    public void setMulticastBufferLen(int n) {
        this.mMulticastBufferLen = n;
    }

    public EndpointAddress getLocalAddress() {
        return this.localAddress;
    }

    public void setLocalAddress(EndpointAddress endpointAddress) {
        this.localAddress = endpointAddress;
    }

    public EndpointAddress getPublicAddress() {
        return this.mPublicAddress;
    }

    public void setPublicAddress(EndpointAddress endpointAddress) {
        this.mPublicAddress = endpointAddress;
    }

    public boolean getUsePublicAddress() {
        return this.mUsePublicAddress;
    }

    public void setUsePublicAddress(boolean bl) {
        this.mUsePublicAddress = bl;
    }

    public String getImplClassname() {
        return this.mImplClassname;
    }

    public void setImplClassname(String string) {
        this.mImplClassname = string;
    }
}

