/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.cm;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import net.jxta.index.IndexService;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

class CmIndexerThread
implements Runnable {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$cm$CmIndexerThread == null ? (class$net$jxta$impl$cm$CmIndexerThread = CmIndexerThread.class$("net.jxta.impl.cm.CmIndexerThread")) : class$net$jxta$impl$cm$CmIndexerThread).getName());
    private File[] dirs;
    private IndexService.Index[] indexes;
    static /* synthetic */ Class class$net$jxta$impl$cm$CmIndexerThread;

    CmIndexerThread(File[] fileArray, IndexService.Index[] indexArray) {
        this.dirs = fileArray;
        this.indexes = indexArray;
    }

    public void run() {
        block14: {
            try {
                int n = 0;
                while (n < this.dirs.length) {
                    if (LOG.isEnabledFor(Priority.INFO)) {
                        LOG.info((Object)("Starting to index " + this.dirs[n]));
                    }
                    String[] stringArray = this.dirs[n].list();
                    int n2 = 0;
                    while (n2 < stringArray.length) {
                        block13: {
                            File file = new File(this.dirs[n], stringArray[n2]);
                            if (LOG.isEnabledFor(Priority.DEBUG)) {
                                LOG.debug((Object)("Indexing " + stringArray[n2] + " in " + this.dirs[n]));
                            }
                            try {
                                this.indexFile(this.indexes[n], file);
                            }
                            catch (IOException iOException) {
                                if (LOG.isEnabledFor(Priority.WARN)) {
                                    LOG.warn((Object)("IOX! NOT Indexing " + stringArray[n2] + " in " + this.dirs[n]));
                                }
                            }
                            catch (IndexService.BadDocumentException badDocumentException) {
                                if (LOG.isEnabledFor(Priority.WARN)) {
                                    LOG.warn((Object)("BADDOC! NOT Indexing " + stringArray[n2] + " in " + this.dirs[n]));
                                }
                            }
                            catch (IndexService.IndexException indexException) {
                                if (!LOG.isEnabledFor(Priority.WARN)) break block13;
                                LOG.warn((Object)("INDX! NOT Indexing " + stringArray[n2] + " in " + this.dirs[n]));
                            }
                        }
                        ++n2;
                    }
                    if (LOG.isEnabledFor(Priority.INFO)) {
                        LOG.info((Object)("Finished indexing " + this.dirs[n]));
                    }
                    ++n;
                }
            }
            catch (Throwable throwable) {
                if (!LOG.isEnabledFor(Priority.FATAL)) break block14;
                LOG.fatal((Object)("Uncaught Throwable in thread :" + Thread.currentThread().getName()), throwable);
            }
        }
    }

    private void indexFile(IndexService.Index index, File file) throws IOException, IndexService.BadDocumentException, IndexService.IndexException {
        FileInputStream fileInputStream = null;
        fileInputStream = new FileInputStream(file);
        if (fileInputStream == null && LOG.isEnabledFor(Priority.ERROR)) {
            LOG.error((Object)"indexing file which could not be opened");
        }
        if (file.getName() == null && LOG.isEnabledFor(Priority.ERROR)) {
            LOG.error((Object)"indexing file with null pathName");
        }
        if (index == null && LOG.isEnabledFor(Priority.ERROR)) {
            LOG.error((Object)"indexing into null index");
        }
        index.add(file.getName(), fileInputStream);
        if (fileInputStream != null) {
            fileInputStream.close();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

