/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.document;

import java.util.Enumeration;
import java.util.Vector;

public class MimeMediaType {
    private String type = null;
    private String subtype = null;
    private Vector parameters = new Vector();
    private static final String CTL = "\u0000\u0001\u0002\u0003\u0004\u0005\u0006\u0007\b\t\n\u000b\f\r\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001f\u007f";
    private static final String space = " ";
    private static final String tspecials = "()<>@,;:\\\"/[]?=";
    private static final String terminator = "\u0000\u0001\u0002\u0003\u0004\u0005\u0006\u0007\b\t\n\u000b\f\r\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001f\u007f ()<>@,;:\\\"/[]?=";

    public MimeMediaType(String string) {
        if (null == string) {
            throw new IllegalArgumentException("input cannot be null");
        }
        String string2 = string.trim().toLowerCase();
        if (0 == string2.length()) {
            throw new IllegalArgumentException("input cannot be null");
        }
        int n = this.findNextSeperator(string2);
        if (-1 == n || 0 == n) {
            throw new IllegalArgumentException("expected seperator or seperator in unexpected location");
        }
        String string3 = string2.substring(0, n);
        int n2 = MimeMediaType.findNextSeperator(string2, n + 1);
        String string4 = null;
        String string5 = null;
        if (-1 == n2) {
            string4 = string2.substring(n + 1);
        } else {
            string4 = string2.substring(n + 1, n2);
            string5 = string2.substring(n2);
        }
        Vector vector = new Vector();
        this.setType(string3);
        this.setSubtype(string4);
        this.setParameters(new String[0]);
    }

    public MimeMediaType(String string, String string2) {
        this(string, string2, (String)null);
    }

    public MimeMediaType(String string, String string2, String string3) {
        Vector vector = new Vector();
        if (null != string3) {
            // empty if block
        }
        this.setType(string);
        this.setSubtype(string2);
        this.setParameters(new String[0]);
    }

    public MimeMediaType(String string, String string2, String[] stringArray) {
        this.setType(string);
        this.setSubtype(string2);
        this.setParameters(stringArray);
    }

    public Object clone() {
        MimeMediaType mimeMediaType = new MimeMediaType(this.toString());
        return mimeMediaType;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MimeMediaType)) {
            return false;
        }
        boolean bl = this.hashCode() == object.hashCode();
        return bl;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        if (!this.isValid()) {
            return null;
        }
        String string = this.type + "/" + this.subtype;
        Enumeration enumeration = this.parameters.elements();
        while (enumeration.hasMoreElements()) {
            string = string + ";" + (String)enumeration.nextElement();
        }
        return string;
    }

    public boolean isValid() {
        boolean bl = null != this.type && null != this.subtype;
        return bl;
    }

    public String getMimeMediaType() {
        if (!this.isValid()) {
            return null;
        }
        String string = this.type + "/" + this.subtype;
        return string;
    }

    public String getType() {
        return this.type;
    }

    public boolean isExperimentalType() {
        if (null == this.type || this.type.length() < 2) {
            return false;
        }
        if (this.type.startsWith("x-") || this.type.startsWith("x.")) {
            return true;
        }
        if (null == this.subtype || this.subtype.length() < 2) {
            return false;
        }
        return this.subtype.startsWith("x-") || this.subtype.startsWith("x.");
    }

    public void setType(String string) {
        if (null == string) {
            throw new IllegalArgumentException("type cannot be null");
        }
        String string2 = string.trim().toLowerCase();
        if (0 == string2.length()) {
            throw new IllegalArgumentException("type cannot be null");
        }
        if (-1 != this.findNextSeperator(string2)) {
            throw new IllegalArgumentException("type cannot contain a seperator");
        }
        this.type = string2;
    }

    public String getSubtype() {
        return this.subtype;
    }

    public boolean isExperimentalSubtype() {
        if (null == this.subtype || this.subtype.length() < 2) {
            return false;
        }
        return 'x' == this.subtype.charAt(0) && '-' == this.subtype.charAt(1);
    }

    public void setSubtype(String string) {
        if (null == string) {
            throw new IllegalArgumentException("subtype cannot be null");
        }
        String string2 = string.trim().toLowerCase();
        if (0 == string2.length()) {
            throw new IllegalArgumentException("subtype cannot be null");
        }
        if (-1 != this.findNextSeperator(string2)) {
            throw new IllegalArgumentException("subtype cannot contain a seperator");
        }
        this.subtype = string2;
    }

    public Enumeration getParameters() {
        return this.parameters.elements();
    }

    public void setParameters(String[] stringArray) {
        this.parameters = new Vector();
        int n = 0;
        while (n < stringArray.length) {
            this.addParameter(stringArray[n]);
            ++n;
        }
    }

    public void addParameter(String string) {
        this.parameters.addElement(string);
    }

    private int findNextSeperator(String string) {
        return MimeMediaType.findNextSeperator(string, 0);
    }

    private static int findNextSeperator(String string, int n) {
        int n2 = -1;
        int n3 = n;
        while (n3 < string.length()) {
            if (-1 != terminator.indexOf(string.charAt(n3))) {
                n2 = n3;
                break;
            }
            ++n3;
        }
        return n2;
    }
}

