/*
 * Decompiled with CFR 0.152.
 */
package jxta.security.impl.random;

import java.util.Random;
import jxta.security.exceptions.CryptoException;
import jxta.security.hash.Hash;
import jxta.security.impl.crypto.JxtaCryptoSuite;

public class JRandom
extends Random {
    private static byte[] seed = new byte[]{-55, 15, -38, -94, 33, 104, -62, 52, -60, -58, 98, -117, -128, -36, 28, -47, 41, 2, 78, 8};
    private static final byte seedLength = 20;
    private Hash sha1 = null;
    private long count = 0L;
    private final int timeLength = 8;
    Runtime rtime = null;
    static final int longSize = 8;
    static final int intSize = 4;

    private void PRandom() throws CryptoException {
        JxtaCryptoSuite jxtaCryptoSuite = new JxtaCryptoSuite(4, null, 0, 0);
        int n = 0;
        if (jxtaCryptoSuite != null) {
            this.sha1 = jxtaCryptoSuite.getJxtaHash((byte)1);
            if (this.sha1 != null) {
                byte by = this.sha1.getDigestLength();
                if (by == 20) {
                    this.rtime = Runtime.getRuntime();
                    this.count = 0L;
                    return;
                }
                n = 2;
            }
        } else {
            n = 4;
        }
        throw new CryptoException((short)n);
    }

    public JRandom() throws CryptoException {
        this.PRandom();
    }

    public JRandom(long l) throws CryptoException {
        int n = 0;
        while (n < 8) {
            JRandom.seed[n] = (byte)(l >>> 8 * (7 - n) & 0xFFL);
            ++n;
        }
        this.PRandom();
    }

    public String whoami() {
        return "Jxta Random";
    }

    private synchronized byte[] getChurn() {
        long l = System.currentTimeMillis() + this.count;
        long l2 = this.rtime.freeMemory();
        l ^= l2 & 0xFFL;
        byte[] byArray = new byte[8];
        int n = 0;
        while (n < 8) {
            byArray[n] = (byte)(l >>> 8 * (7 - n) & 0xFFL);
            ++n;
        }
        ++this.count;
        return byArray;
    }

    public void generateData(byte[] byArray, int n, int n2) {
        byte by;
        byte[] byArray2 = this.getChurn();
        this.sha1.update(seed, 0, 20);
        this.sha1.doFinal(byArray2, 0, 8, seed, 0);
        if (byArray.length > n && n + n2 <= byArray.length) {
            by = 0;
            int n3 = 0;
            while (n3 < n2) {
                byte by2 = by;
                by = (byte)(by + 1);
                byArray[n3 + n] = seed[by2];
                if (by == 20) {
                    by = 0;
                    this.sha1.update(seed, 0, 20);
                    byte by3 = (byte)(seed[0] & 0xF);
                    byArray2[0] = (byte)(byArray2[0] ^ by3);
                    this.sha1.doFinal(byArray2, 0, 8, seed, 0);
                }
                ++n3;
            }
        }
        this.sha1.update(seed, 0, 20);
        by = (byte)(seed[0] ^ 0xF);
        byArray2[0] = (byte)(byArray2[0] ^ by);
        this.sha1.doFinal(byArray2, 0, 8, seed, 0);
    }

    public void setSeed(byte[] byArray, int n, int n2) {
        if (n + n2 <= byArray.length) {
            int n3 = n2 < 20 ? n2 : 20;
            System.arraycopy(byArray, n, seed, 0, n3);
        }
    }

    public synchronized void setSeed(long l) {
        int n = 0;
        while (n < 8) {
            JRandom.seed[n] = (byte)(l >>> 8 * (7 - n) & 0xFFL);
            ++n;
        }
    }

    protected synchronized int next(int n) {
        int n2 = this.nextInt();
        return n2 >>>= 32 - n;
    }

    public void nextBytes(byte[] byArray) {
        this.generateData(byArray, 0, byArray.length);
    }

    public int nextInt() {
        byte[] byArray = new byte[4];
        this.generateData(byArray, 0, 4);
        int n = 0;
        int n2 = 3;
        int n3 = 0;
        while (n3 < 4) {
            n |= (byArray[n3] & 0xFF) << 8 * (n2 - n3);
            ++n3;
        }
        return n & Integer.MAX_VALUE;
    }

    public long nextLong() {
        byte[] byArray = new byte[8];
        this.generateData(byArray, 0, 8);
        long l = 0L;
        long l2 = 7L;
        byArray[0] = (byte)(byArray[0] & 0x7F);
        int n = 0;
        while (n < 8) {
            l |= ((long)byArray[n] & 0xFFL) << (int)(8L * (l2 - (long)n));
            ++n;
        }
        return l;
    }
}

