/*
 * Decompiled with CFR 0.152.
 */
package jxta.security.impl.publickey;

import jxta.security.exceptions.CryptoException;
import jxta.security.publickey.RSAPrivateKey;
import jxta.security.publickey.RSAPublicKey;
import jxta.security.util.Util;

public final class RSAKey
implements RSAPublicKey,
RSAPrivateKey {
    private boolean initDone = false;
    private byte keyType;
    private int size;
    private int modBytes;
    private byte[] publicExponent = null;
    private byte[] privateExponent = null;
    private byte[] modulus = null;
    private byte[] primeP = null;
    private byte[] primeQ = null;
    private byte[] primeExponentP = null;
    private byte[] primeExponentQ = null;
    private byte[] crtCoefficient = null;
    private boolean debug = false;

    public String getAlgorithmName() {
        return "RSA Key";
    }

    public void setDebug() {
        this.debug = true;
    }

    public void clearDebug() {
        this.debug = false;
    }

    public RSAKey(byte by, short s) {
        this.keyType = by;
        this.size = s != 384 || s != 512 ? 512 : (int)s;
        this.modBytes = this.size >>> 3;
    }

    public boolean isInitialized() {
        return this.initDone;
    }

    public void clearKey() {
        this.initDone = false;
        this.size = 0;
    }

    public short getSize() {
        return (short)this.size;
    }

    public int getLength() {
        return this.size + 7 >>> 3;
    }

    public byte getType() {
        return this.keyType;
    }

    public boolean equals(RSAPrivateKey rSAPrivateKey) {
        return this.RSAEquals((RSAKey)rSAPrivateKey, (byte)2);
    }

    public boolean equals(RSAPublicKey rSAPublicKey) {
        return this.RSAEquals((RSAKey)rSAPublicKey, (byte)1);
    }

    public boolean RSAEquals(RSAKey rSAKey, byte by) {
        byte[] byArray = null;
        byte[] byArray2 = null;
        byte[] byArray3 = new byte[this.modulus.length];
        int n = 0;
        int n2 = 0;
        if (by == 2) {
            byArray = new byte[this.privateExponent.length];
            n = this.privateExponent.length;
            byArray2 = this.privateExponent;
            n2 = rSAKey.getPrivateExponent(byArray, 0);
        } else {
            byArray = new byte[this.publicExponent.length];
            n = this.publicExponent.length;
            byArray2 = this.publicExponent;
            n2 = rSAKey.getPublicExponent(byArray, 0);
        }
        if (rSAKey.getModulus(byArray3, 0) != this.modulus.length) {
            return false;
        }
        if (n2 != n) {
            return false;
        }
        int n3 = 0;
        while (n3 < this.modulus.length) {
            if (byArray3[n3] != this.modulus[n3]) {
                return false;
            }
            ++n3;
        }
        int n4 = 0;
        while (n4 < n) {
            if (byArray[n4] != byArray2[n4]) {
                return false;
            }
            ++n4;
        }
        return true;
    }

    public int getPublicExponentLength() {
        return this.publicExponent.length;
    }

    public int getPrivateExponentLength() {
        return this.privateExponent.length;
    }

    public int getModulusLength() {
        return this.modulus.length;
    }

    public int getPrimePLength() {
        return this.primeP.length;
    }

    public int getPrimeQLength() {
        return this.primeQ.length;
    }

    public int getPrimeExponentPLength() {
        return this.primeExponentP.length;
    }

    public int getPrimeExponentQLength() {
        return this.primeExponentQ.length;
    }

    public int getCrtCoefficientLength() {
        return this.crtCoefficient.length;
    }

    public void setPublicExponent(byte[] byArray, int n, int n2) throws CryptoException {
        if ((this.keyType & 3) == 0) {
            throw new CryptoException(4);
        }
        if (n2 + n > byArray.length) {
            throw new CryptoException(2);
        }
        this.publicExponent = new byte[n2];
        System.arraycopy(byArray, n, this.publicExponent, 0, n2);
        if (this.modulus != null) {
            this.initDone = true;
        }
    }

    public void setPrivateExponent(byte[] byArray, int n, int n2) throws CryptoException {
        if ((this.keyType & 3) == 0) {
            throw new CryptoException(4);
        }
        if (n2 + n > byArray.length) {
            throw new CryptoException(2);
        }
        this.privateExponent = new byte[n2];
        System.arraycopy(byArray, n, this.privateExponent, 0, n2);
        if (this.modulus != null) {
            this.initDone = true;
        }
    }

    public void setModulus(byte[] byArray, int n, int n2) throws CryptoException {
        if ((this.keyType & 3) == 0) {
            throw new CryptoException(4);
        }
        if (this.debug) {
            System.out.println("SetModulus, modbytes = " + this.modBytes + " len = " + n2);
        }
        if (n2 + n > byArray.length) {
            throw new CryptoException(2);
        }
        if (this.debug) {
            System.out.println("modulus =\n" + Util.hexEncode(byArray));
        }
        if (this.modBytes < n2) {
            this.modBytes = n2;
        }
        this.modulus = new byte[this.modBytes];
        System.arraycopy(byArray, n, this.modulus, this.modBytes - n2, this.modBytes);
        if (this.publicExponent != null || this.privateExponent != null) {
            this.initDone = true;
        }
    }

    public void setPrimeP(byte[] byArray, int n, int n2) throws CryptoException {
        if (!this.initDone || byArray.length < n + n2) {
            throw new CryptoException(2);
        }
        this.primeP = new byte[n2];
        System.arraycopy(byArray, n, this.primeP, 0, n2);
    }

    public void setPrimeQ(byte[] byArray, int n, int n2) throws CryptoException {
        if (!this.initDone || byArray.length < n + n2) {
            throw new CryptoException(2);
        }
        this.primeQ = new byte[n2];
        System.arraycopy(byArray, n, this.primeQ, 0, n2);
    }

    public void setPrimeExponentP(byte[] byArray, int n, int n2) throws CryptoException {
        if (!this.initDone || byArray.length < n + n2) {
            throw new CryptoException(2);
        }
        this.primeExponentP = new byte[n2];
        System.arraycopy(byArray, n, this.primeExponentP, 0, n2);
    }

    public void setPrimeExponentQ(byte[] byArray, int n, int n2) throws CryptoException {
        if (!this.initDone || byArray.length < n + n2) {
            throw new CryptoException(2);
        }
        this.primeExponentQ = new byte[n2];
        System.arraycopy(byArray, n, this.primeExponentQ, 0, n2);
    }

    public void setCrtCoefficient(byte[] byArray, int n, int n2) throws CryptoException {
        if (!this.initDone || byArray.length < n + n2) {
            throw new CryptoException(2);
        }
        this.crtCoefficient = new byte[n2];
        System.arraycopy(byArray, n, this.crtCoefficient, 0, n2);
    }

    public int getPublicExponent(byte[] byArray, int n) {
        int n2 = this.publicExponent.length;
        if (byArray.length < n + n2) {
            return 0;
        }
        System.arraycopy(this.publicExponent, 0, byArray, n, n2);
        return n2;
    }

    public int getPrivateExponent(byte[] byArray, int n) {
        int n2 = this.privateExponent.length;
        if (byArray.length < n + n2) {
            return 0;
        }
        System.arraycopy(this.privateExponent, 0, byArray, n, n2);
        return n2;
    }

    public int getModulus(byte[] byArray, int n) {
        if (byArray.length < n + this.modBytes) {
            return 0;
        }
        System.arraycopy(this.modulus, 0, byArray, n, this.modBytes);
        return this.modBytes;
    }

    public int getPrimeP(byte[] byArray, int n) {
        if (this.primeP == null || byArray.length < n + this.primeP.length) {
            return 0;
        }
        System.arraycopy(this.primeP, 0, byArray, n, this.primeP.length);
        return this.primeP.length;
    }

    public int getPrimeQ(byte[] byArray, int n) {
        if (this.primeQ == null || byArray.length < n + this.primeQ.length) {
            return 0;
        }
        System.arraycopy(this.primeQ, 0, byArray, n, this.primeQ.length);
        return this.primeQ.length;
    }

    public int getPrimeExponentP(byte[] byArray, int n) {
        if (this.primeExponentP == null || byArray.length < n + this.primeExponentP.length) {
            return 0;
        }
        System.arraycopy(this.primeExponentP, 0, byArray, n, this.primeExponentP.length);
        return this.primeExponentP.length;
    }

    public int getPrimeExponentQ(byte[] byArray, int n) {
        if (this.primeExponentQ == null || byArray.length < n + this.primeExponentQ.length) {
            return 0;
        }
        System.arraycopy(this.primeExponentQ, 0, byArray, n, this.primeExponentQ.length);
        return this.primeExponentQ.length;
    }

    public int getCrtCoefficient(byte[] byArray, int n) {
        if (this.crtCoefficient == null || byArray.length < n + this.crtCoefficient.length) {
            return 0;
        }
        System.arraycopy(this.crtCoefficient, 0, byArray, n, this.crtCoefficient.length);
        return this.crtCoefficient.length;
    }
}

