/*
 * Decompiled with CFR 0.152.
 */
package jxta.security.impl.mac;

import jxta.security.cipher.Cipher;
import jxta.security.cipher.Key;
import jxta.security.exceptions.CryptoException;
import jxta.security.hash.Hash;
import jxta.security.impl.cipher.SecretKey;
import jxta.security.mac.MAC;
import jxta.security.util.Util;

public class MACAlgorithm
implements MAC {
    private static String myname = "MAC";
    private static int macLength = 0;
    private static byte type = 0;
    private static Hash digest = null;
    private static Cipher cipher = null;
    private static SecretKey rKey = null;
    private static byte mode = 0;
    private boolean debug = false;

    public String getAlgorithmName() {
        return myname;
    }

    public MACAlgorithm(Cipher cipher, byte by, Hash hash) throws CryptoException {
        MACAlgorithm.cipher = cipher;
        digest = hash;
        type = by;
        macLength = this.calculateMacLength();
        myname = myname + " " + MACAlgorithm.cipher.getAlgorithmName() + " " + digest.getAlgorithmName();
    }

    private int calculateMacLength() throws CryptoException {
        if (cipher.getAlgorithm() != 4) {
            macLength = 0;
            throw new CryptoException(1);
        }
        macLength = digest.getDigestLength();
        return macLength;
    }

    public byte getAlgorithm() {
        return type;
    }

    public void setDebug() {
        this.debug = true;
    }

    public void clearDebug() {
        this.debug = false;
    }

    public int getLength() {
        return macLength;
    }

    public void init(byte by, Key key, byte[] byArray) throws CryptoException {
        rKey = (SecretKey)key;
        if (by != 1 && by != 2) {
            throw new CryptoException(3);
        }
        mode = by;
        rKey.setKey(byArray, 0);
        byte by2 = mode == 1 ? (byte)1 : 2;
        cipher.init(rKey, by2);
    }

    public void update(byte[] byArray, int n, int n2) throws CryptoException {
        if (byArray.length < n + n2) {
            throw new CryptoException(2);
        }
        digest.update(byArray, n, n2);
    }

    public int encrypt(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws CryptoException {
        if (byArray2.length < macLength + n3) {
            throw new CryptoException(2);
        }
        if (mode != 1) {
            throw new CryptoException(3);
        }
        byte[] byArray3 = new byte[digest.getDigestLength()];
        digest.doFinal(byArray, n, n2, byArray3, 0);
        cipher.doFinal(byArray3, 0, byArray3.length, byArray2, n3);
        return macLength;
    }

    public boolean verify(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) throws CryptoException {
        if (mode != 2) {
            throw new CryptoException(3);
        }
        byte[] byArray3 = new byte[digest.getDigestLength()];
        digest.doFinal(byArray, n, n2, byArray3, 0);
        byte[] byArray4 = new byte[n4];
        cipher.doFinal(byArray2, n3, byArray2.length, byArray4, 0);
        if (this.debug) {
            System.out.println("Digest [" + byArray3.length + "] =\n" + Util.hexEncode(byArray3) + "\nDecrypted MAC [" + byArray4.length + "] =\n" + Util.hexEncode(byArray4));
        }
        if (byArray4.length == byArray3.length) {
            int n5 = 0;
            while (n5 < byArray3.length) {
                if (byArray4[n5] != byArray3[n5]) {
                    return false;
                }
                ++n5;
            }
        } else {
            return false;
        }
        return true;
    }
}

