/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.collections;

import java.util.Enumeration;

public final class SimpleHashtable
implements Enumeration {
    private Entry[] table;
    private Entry current = null;
    private int currentBucket = 0;
    private int count;
    private int threshold;
    private static final float loadFactor = 0.75f;
    private static final int dL = 0;

    public SimpleHashtable() {
        this(11);
    }

    public SimpleHashtable(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
        }
        if (initialCapacity == 0) {
            initialCapacity = 1;
        }
        this.table = new Entry[initialCapacity];
        this.threshold = (int)((float)initialCapacity * 0.75f);
    }

    public void clear() {
        this.count = 0;
        this.currentBucket = 0;
        this.current = null;
        int i = 0;
        while (i < this.table.length) {
            this.table[i] = null;
            ++i;
        }
    }

    private void d(String s) {
        System.err.println("SimpleHashtable: " + s);
    }

    public Object get(String key) {
        Entry[] tab = this.table;
        int hash = key.hashCode();
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index];
        while (e != null) {
            if (e.hash == hash && e.key.equals(key)) {
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    public Object getInterned(String key) {
        Entry[] tab = this.table;
        int hash = key.hashCode();
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index];
        while (e != null) {
            if (e.hash == hash && e.key == key) {
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public boolean hasMoreElements() {
        if (this.current == null) ** GOTO lbl6
        return true;
lbl-1000:
        // 1 sources

        {
            this.current = this.table[this.currentBucket++];
            if (this.current == null) continue;
            return true;
lbl6:
            // 2 sources

            ** while (this.currentBucket < this.table.length)
        }
lbl7:
        // 1 sources

        return false;
    }

    public Enumeration keys() {
        this.currentBucket = 0;
        this.current = null;
        this.hasMoreElements();
        return this;
    }

    public Object nextElement() {
        if (this.current == null) {
            throw new IllegalStateException();
        }
        Object retval = this.current.key;
        this.current = this.current.next;
        this.hasMoreElements();
        return retval;
    }

    public Object put(Object key, Object value) {
        Entry e;
        if (value == null) {
            throw new NullPointerException();
        }
        Entry[] tab = this.table;
        int hash = key.hashCode();
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry e2 = tab[index];
        while (e2 != null) {
            if (e2.hash == hash && e2.key == key) {
                Object old = e2.value;
                e2.value = value;
                return old;
            }
            e2 = e2.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            tab = this.table;
            index = (hash & Integer.MAX_VALUE) % tab.length;
        }
        tab[index] = e = new Entry(hash, key, value, tab[index]);
        ++this.count;
        return null;
    }

    private void rehash() {
        int oldCapacity = this.table.length;
        Entry[] oldMap = this.table;
        int newCapacity = oldCapacity * 2 + 1;
        Entry[] newMap = new Entry[newCapacity];
        this.threshold = (int)((float)newCapacity * 0.75f);
        this.table = newMap;
        int i = oldCapacity;
        while (i-- > 0) {
            Entry old = oldMap[i];
            while (old != null) {
                Entry e = old;
                old = old.next;
                int index = (e.hash & Integer.MAX_VALUE) % newCapacity;
                e.next = newMap[index];
                newMap[index] = e;
            }
        }
    }

    public Object remove(Object key) {
        Entry[] tab = this.table;
        Entry prev = null;
        int hash = key.hashCode();
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index];
        while (e != null) {
            if (e.hash == hash && e.key.equals(key)) {
                if (prev != null) {
                    prev.next = e.next;
                } else {
                    tab[index] = e.next;
                }
                --this.count;
                Object res = e.value;
                e.value = null;
                return res;
            }
            prev = e;
            e = e.next;
        }
        return null;
    }

    public int size() {
        return this.count;
    }

    private static class Entry {
        int hash;
        Object key;
        Object value;
        Entry next;

        protected Entry(int hash, Object key, Object value, Entry next) {
            this.hash = hash;
            this.key = key;
            this.value = value;
            this.next = next;
        }
    }
}

