/*
 * Decompiled with CFR 0.152.
 */
package cryptix.provider.rsa;

import cryptix.util.core.BI;
import cryptix.util.core.Debug;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.security.InvalidParameterException;
import xjava.security.interfaces.CryptixRSAPrivateKey;
import xjava.security.interfaces.RSAFactors;

public abstract class BaseRSAPrivateKey
implements CryptixRSAPrivateKey,
RSAFactors {
    private static final boolean DEBUG = true;
    private static final int debuglevel = Debug.getLevel("RSA", "BaseRSAPrivateKey");
    private static final PrintWriter err = Debug.getOutput();
    private static final BigInteger ZERO = BigInteger.valueOf(0L);
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private BigInteger n;
    private BigInteger d;
    private BigInteger p;
    private BigInteger q;
    private BigInteger u;

    private static void debug(String string) {
        err.println("BaseRSAPrivateKey: " + string);
    }

    public BigInteger getModulus() {
        return this.n;
    }

    public BigInteger getExponent() {
        return this.d;
    }

    public BigInteger getP() {
        return this.p;
    }

    public BigInteger getQ() {
        return this.q;
    }

    public BigInteger getInverseOfQModP() {
        return this.u;
    }

    public String getAlgorithm() {
        return "RSA";
    }

    protected void setRsaParams(BigInteger bigInteger, BigInteger bigInteger2) {
        if (bigInteger == null) {
            throw new NullPointerException("n == null");
        }
        if (bigInteger2 == null) {
            throw new NullPointerException("d == null");
        }
        this.n = bigInteger;
        this.d = bigInteger2;
    }

    protected void setRsaParams(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) {
        if (bigInteger == null) {
            throw new NullPointerException("d == null");
        }
        this.n = bigInteger2.multiply(bigInteger3);
        this.d = bigInteger;
        this.p = bigInteger2;
        this.q = bigInteger3;
        if (bigInteger4 != null && !bigInteger4.multiply(bigInteger3).mod(bigInteger2).equals(ONE)) {
            if (debuglevel >= 1) {
                BaseRSAPrivateKey.debug("uq != 1 (mod p)");
            }
            bigInteger4 = null;
        }
        if (bigInteger4 == null) {
            try {
                bigInteger4 = bigInteger3.modInverse(bigInteger2);
            }
            catch (ArithmeticException arithmeticException) {
                if (debuglevel >= 1) {
                    if (bigInteger2.compareTo(ZERO) <= 0) {
                        BaseRSAPrivateKey.debug("p <= 0");
                    }
                    if (bigInteger2.equals(bigInteger3)) {
                        BaseRSAPrivateKey.debug("p == q");
                    }
                    if (!bigInteger2.isProbablePrime(80)) {
                        BaseRSAPrivateKey.debug("p is composite");
                    }
                    if (!bigInteger3.isProbablePrime(80)) {
                        BaseRSAPrivateKey.debug("q is composite");
                    }
                }
                throw new InvalidParameterException("gcd(q, p) != 1");
            }
        }
        this.u = bigInteger4;
    }

    public String toString() {
        if (debuglevel >= 5) {
            return "<----- RSAPrivateKey:\n" + "         d: " + BI.dumpString(this.d) + "         p: " + BI.dumpString(this.p) + "         q: " + BI.dumpString(this.q) + "q^-1 mod p: " + BI.dumpString(this.u) + "----->\n";
        }
        return "<BaseRSAPrivateKey>";
    }

    public abstract String getFormat();

    public abstract byte[] getEncoded();

    protected BaseRSAPrivateKey() {
    }
}

