/*
 * Decompiled with CFR 0.152.
 */
package COM.claymoresystems.ptls.benchmark;

import COM.claymoresystems.ptls.SSLAlertException;
import COM.claymoresystems.ptls.SSLContext;
import COM.claymoresystems.ptls.SSLSocket;
import COM.claymoresystems.ptls.benchmark.NullOutputStream;
import COM.claymoresystems.ptls.benchmark.SockBench;
import COM.claymoresystems.sslg.SSLPolicyInt;
import COM.claymoresystems.util.Bench;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.Socket;

class ClientBench
extends SockBench {
    private void testConn(Socket socket) throws IOException {
        try {
            byte[] byArray = new byte[4096];
            BufferedInputStream bufferedInputStream = new BufferedInputStream(socket.getInputStream());
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(socket.getOutputStream());
            long l = System.currentTimeMillis();
            Bench.clear();
            int n = 0;
            while (n < this.msgCount) {
                this.writeMessage(bufferedOutputStream);
                if (!this.noNetwork) {
                    this.readMessage(bufferedInputStream);
                }
                ++n;
            }
            long l2 = System.currentTimeMillis();
            long l3 = l2 - l;
            System.out.println("Elapsed: " + l2 + ":" + l + ":" + l3);
            long l4 = this.msgCount * this.msgSize;
            System.out.println("Total " + l4);
            long l5 = l4 / (l2 - l);
            long l6 = l5 * 1000L / 1024L;
            System.out.println("K/S=" + l6);
            if (this.exitForClose) {
                return;
            }
            if (this.verbose) {
                System.out.println("Closing");
            }
            if (!this.noNetwork) {
                socket.close();
            } else {
                if (this.verbose) {
                    System.out.println("Hard close");
                }
                ((SSLSocket)socket).hardClose();
            }
        }
        catch (SSLAlertException sSLAlertException) {
            throw new Error(sSLAlertException.toString());
        }
    }

    public ClientBench(String[] stringArray) throws IOException {
        super("Client", stringArray);
        try {
            if (this.verbose) {
                System.out.println("Creating SSLContext");
            }
            SSLContext sSLContext = new SSLContext();
            if (this.verbose) {
                System.out.println("Created SSLContext");
            }
            sSLContext.loadRootCertificates(this.rootfile);
            sSLContext.loadEAYKeyFile(this.keyfile, this.password);
            sSLContext.seedRNG(null);
            SSLPolicyInt sSLPolicyInt = new SSLPolicyInt();
            sSLPolicyInt.acceptUnverifiableCertificates(true);
            sSLContext.setPolicy(sSLPolicyInt);
            while (this.iterate-- != 0) {
                Socket socket;
                if (this.verbose) {
                    System.out.println("Connecting");
                }
                if (this.useNormalSockets) {
                    socket = new Socket(this.host, this.port);
                } else {
                    socket = new SSLSocket(sSLContext, this.host, this.port);
                    if (this.noNetwork) {
                        ((SSLSocket)socket)._stompOutputStream(new NullOutputStream());
                    }
                }
                if (this.verbose) {
                    System.out.println("Connected");
                }
                this.testConn(socket);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) throws IOException {
        ClientBench clientBench = new ClientBench(stringArray);
        Bench.dump();
    }
}

