/*
 * Decompiled with CFR 0.152.
 */
package COM.claymoresystems.ptls;

import COM.claymoresystems.ptls.SSLConn;
import COM.claymoresystems.ptls.SSLPDU;
import COM.claymoresystems.ptls.SSLopaque;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import xjava.security.interfaces.CryptixRSAPublicKey;

class SSLRSAParams
extends SSLPDU {
    SSLopaque RSA_modulus = new SSLopaque(-65535);
    SSLopaque RSA_exponent = new SSLopaque(-65535);

    public SSLRSAParams() {
    }

    public SSLRSAParams(CryptixRSAPublicKey cryptixRSAPublicKey) {
        this.RSA_modulus.value = this.toBytes(cryptixRSAPublicKey.getModulus());
        this.RSA_exponent.value = this.toBytes(cryptixRSAPublicKey.getExponent());
    }

    public int decode(SSLConn sSLConn, InputStream inputStream) throws Error, IOException {
        int n = 0;
        n = this.RSA_modulus.decode(sSLConn, inputStream);
        return n += this.RSA_exponent.decode(sSLConn, inputStream);
    }

    public int encode(SSLConn sSLConn, OutputStream outputStream) throws Error, IOException {
        int n = 0;
        n = this.RSA_modulus.encode(sSLConn, outputStream);
        return n += this.RSA_exponent.encode(sSLConn, outputStream);
    }

    private byte[] toBytes(BigInteger bigInteger) {
        byte[] byArray = bigInteger.toByteArray();
        if (byArray[0] == 0) {
            byte[] byArray2 = new byte[byArray.length - 1];
            System.arraycopy(byArray, 1, byArray2, 0, byArray.length - 1);
            return byArray2;
        }
        return byArray;
    }
}

