/*
 * Decompiled with CFR 0.152.
 */
package COM.claymoresystems.ptls;

import COM.claymoresystems.ptls.SSLAlertX;
import COM.claymoresystems.ptls.SSLConn;
import COM.claymoresystems.ptls.SSLHandshake;
import COM.claymoresystems.ptls.SSLPDU;
import COM.claymoresystems.ptls.SSLopaque;
import COM.claymoresystems.ptls.SSLv3Finished;
import COM.claymoresystems.ptls.TLSFinished;
import cryptix.util.core.ArrayUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class SSLFinished
extends SSLPDU {
    SSLopaque finished;
    byte[] value;

    public SSLFinished(SSLConn sSLConn, SSLHandshake sSLHandshake, boolean bl) {
        switch (sSLConn.ssl_version) {
            case 768: {
                this.value = SSLv3Finished.computeFinished(sSLHandshake, bl);
                break;
            }
            case 769: {
                this.value = TLSFinished.computeFinished(sSLHandshake, bl);
                break;
            }
            default: {
                throw new Error("Unsupported version");
            }
        }
        this.finished = new SSLopaque(this.value.length);
    }

    public int encode(SSLConn sSLConn, OutputStream outputStream) throws Error, IOException {
        this.finished.value = this.value;
        return this.finished.encode(sSLConn, outputStream);
    }

    public int decode(SSLConn sSLConn, InputStream inputStream) throws IOException {
        int n = this.finished.decode(sSLConn, inputStream);
        if (!ArrayUtil.areEqual((byte[])this.value, (byte[])this.finished.value)) {
            sSLConn.alert(SSLAlertX.TLS_ALERT_BAD_RECORD_MAC);
        }
        return n;
    }
}

