/*
 * Decompiled with CFR 0.152.
 */
package COM.claymoresystems.crypto;

import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import xjava.security.Parameterized;

public class HMACInputStream
extends InputStream {
    private InputStream sub;
    private MessageDigest md;

    protected void _HMACInputStream(String string, byte[] byArray, InputStream inputStream) {
        this.sub = inputStream;
        try {
            this.md = MessageDigest.getInstance("HMAC-" + string);
            ((Parameterized)this.md).setParameter("key", (Object)byArray);
        }
        catch (Exception exception) {
            throw new InternalError(exception.toString());
        }
    }

    public HMACInputStream(String string, byte[] byArray, InputStream inputStream) {
        this._HMACInputStream(string, byArray, inputStream);
    }

    public HMACInputStream(String string, String string2, InputStream inputStream) {
        try {
            this.md = MessageDigest.getInstance(string);
            this._HMACInputStream(string, this.md.digest(string2.getBytes()), inputStream);
        }
        catch (Exception exception) {
            throw new InternalError(exception.toString());
        }
    }

    public int read() throws IOException {
        int n = this.sub.read();
        this.md.update((byte)(0xFF & n));
        return n;
    }

    public int read(byte[] byArray) throws IOException {
        int n = this.sub.read(byArray);
        this.md.update(byArray, 0, n);
        return n;
    }

    public byte[] digest() {
        return this.md.digest();
    }
}

