/*
 * Decompiled with CFR 0.152.
 */
package COM.claymoresystems.cert;

import COM.claymoresystems.cert.CertContext;
import COM.claymoresystems.cert.DERUtils;
import COM.claymoresystems.ptls.SSLDebug;
import cryptix.asn1.encoding.BaseCoder;
import cryptix.asn1.encoding.CoderOperations;
import cryptix.asn1.lang.ASNObject;
import cryptix.asn1.lang.ASNSpecification;
import cryptix.asn1.lang.ParserVisitor;
import cryptix.provider.rsa.BaseRSAPrivateKey;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.interfaces.RSAPrivateCrtKey;
import xjava.security.interfaces.CryptixRSAPrivateKey;
import xjava.security.interfaces.RSAFactors;

public class X509RSAPrivateKey
extends BaseRSAPrivateKey {
    private byte[] encoding;

    X509RSAPrivateKey(CryptixRSAPrivateKey cryptixRSAPrivateKey) throws ClassCastException {
        RSAFactors rSAFactors = (RSAFactors)cryptixRSAPrivateKey;
        this.setRsaParams(cryptixRSAPrivateKey.getExponent(), rSAFactors.getP(), rSAFactors.getQ(), rSAFactors.getInverseOfQModP());
    }

    public X509RSAPrivateKey(RSAPrivateCrtKey rSAPrivateCrtKey) {
        this.setRsaParams(rSAPrivateCrtKey.getPrivateExponent(), rSAPrivateCrtKey.getPrimeP(), rSAPrivateCrtKey.getPrimeQ(), rSAPrivateCrtKey.getCrtCoefficient());
    }

    public X509RSAPrivateKey(String string, byte[] byArray, byte[] byArray2) throws IOException {
        ASNSpecification aSNSpecification = CertContext.getSpec();
        synchronized (aSNSpecification) {
            SSLDebug.debug(8, "RSA Private key encoding", byArray2);
            CoderOperations coderOperations = BaseCoder.getInstance((String)"DER");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2);
            coderOperations.init((InputStream)byteArrayInputStream);
            ASNObject aSNObject = CertContext.getSpec().getComponent("RSAPrivateKey");
            aSNObject.accept((ParserVisitor)coderOperations, null);
            BigInteger bigInteger = (BigInteger)aSNObject.getComponent("RSAPrivateKey.privateExponent").getValue();
            BigInteger bigInteger2 = (BigInteger)aSNObject.getComponent("RSAPrivateKey.prime1").getValue();
            BigInteger bigInteger3 = (BigInteger)aSNObject.getComponent("RSAPrivateKey.prime2").getValue();
            BigInteger bigInteger4 = (BigInteger)aSNObject.getComponent("RSAPrivateKey.coefficient").getValue();
            SSLDebug.debug(8, "RSA Private decoded");
            this.setRsaParams(bigInteger, bigInteger2, bigInteger3, bigInteger4);
        }
    }

    public byte[] getEncoded() {
        SSLDebug.debug(8, "Decoding priate key");
        if (this.encoding != null) {
            return this.encoding;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BigInteger bigInteger = this.getP().subtract(new BigInteger("1"));
        BigInteger bigInteger2 = this.getQ().subtract(new BigInteger("1"));
        BigInteger bigInteger3 = this.getExponent().modInverse(bigInteger.multiply(bigInteger2));
        BigInteger bigInteger4 = this.getExponent().mod(bigInteger);
        BigInteger bigInteger5 = this.getExponent().mod(bigInteger2);
        try {
            DERUtils.encodeInteger(new BigInteger("0"), byteArrayOutputStream);
            DERUtils.encodeInteger(this.getModulus(), byteArrayOutputStream);
            DERUtils.encodeInteger(bigInteger3, byteArrayOutputStream);
            DERUtils.encodeInteger(this.getExponent(), byteArrayOutputStream);
            DERUtils.encodeInteger(this.getP(), byteArrayOutputStream);
            DERUtils.encodeInteger(this.getQ(), byteArrayOutputStream);
            DERUtils.encodeInteger(bigInteger4, byteArrayOutputStream);
            DERUtils.encodeInteger(bigInteger5, byteArrayOutputStream);
            DERUtils.encodeInteger(this.getInverseOfQModP(), byteArrayOutputStream);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.reset();
            DERUtils.encodeSequence(byArray, byteArrayOutputStream);
            this.encoding = byteArrayOutputStream.toByteArray();
            return this.encoding;
        }
        catch (IOException iOException) {
            throw new InternalError(iOException.toString());
        }
    }

    public String getFormat() {
        return "X509";
    }
}

