<?xml version="1.0"?> 

<!--

$Id: add.xsl,v 1.2 2001/09/24 08:52:29 burton Exp $

==== BEGIN LICENSE ==============================================================

Copyright (C) 2000-2003 Kevin A. Burton (burton@openprivacy.org)
Copyright (C) 2000-2003 OpenPrivacy.org

This program is free software; you can redistribute it and/or modify it under
the terms of the LICENSE which you should have obtaind with this package.

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE.

==== END LICENSE ================================================================

Overview:

-->

<xsl:stylesheet xmlns="http://purl.org/rss/1.0/"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" 
                xmlns:dc="http://purl.org/dc/elements/1.1/" 
                xmlns:timestamp="xalan://org.openprivacy.reptile.extensions.TimeStamp"
                extension-element-prefixes="timestamp"
                version="1.0">

    <!-- by default, copy all matching templates -->
    <xsl:include href="resource:/xsl/misc/copy.xsl"/>

    <xsl:output indent="yes" 
                omit-xml-declaration="yes"/>                

    <xsl:param name="reptile_link" select="''"/>

    <xsl:param name="reptile_link_title" select="''"/>

    <xsl:param name="reptile_link_description" select="''"/>

    <xsl:param name="reptile.publish.comments" select="''"/>
    
    <!-- this should be the contentType and location of the channel that you
    need to update -->

    <xsl:template match="/rdf:RDF">

        <rdf:RDF>

            <!-- add the new item... -->

            <item>

                <title><xsl:value-of select="$reptile_link_title"/></title>

                <link><xsl:value-of select="$reptile_link"/></link>

                <description><xsl:value-of select="$reptile_link_description"/></description>

                <comment>

                <xsl:value-of select="$reptile.publish.comments"/>

                </comment>

                <dc:date><timestamp:get/></dc:date>

            </item>

            <xsl:apply-templates/>

        </rdf:RDF>

    </xsl:template>

</xsl:stylesheet>

