<?xml version="1.0"?> 

<!--

$Id: mozilla-help.xsl,v 1.6 2002/02/27 10:33:06 burton Exp $

==== BEGIN LICENSE ==============================================================

Copyright (C) 2000-2003 Kevin A. Burton (burton@openprivacy.org)
Copyright (C) 2000-2003 OpenPrivacy.org

This program is free software; you can redistribute it and/or modify it under
the terms of the LICENSE which you should have obtaind with this package.

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE.

==== END LICENSE ================================================================

Overview:

See http://reptile.openprivacy.org for more information

-->

<xsl:stylesheet xmlns="http://www.w3.org/1999/xhtml" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:help="http://schemas.openprivacy.org/reptile/help"
                extension-element-prefixes=""
                exclude-result-prefixes=""
                version="1.0">

    <xsl:output indent="yes" method="html"/>

    <!-- by default, copy all matching templates -->
    <xsl:include href="resource:/xsl/misc/copy.xsl"/>

    <xsl:template match="help:help">
    
        <html>

            <head>

                <title>Reptile online help</title>

                <!-- add links to the rest of the items -->

                <xsl:for-each select="help:entry">

                    <xsl:sort select="@title"/>

                    <link rel="Bookmark" href="#{@index}" title="{@title}"/>
                    
                </xsl:for-each>

            </head>
            
            <body bgcolor="#C6C6C6">
                
                <h2>Reptile online help - contents</h2>

                <a name="contents"/>

                <hr/>
                
                <xsl:for-each select="./help:section">

                    <xsl:sort select="@name"/>

                    <b><xsl:value-of select="@name"/></b>
                    
                    <blockquote>

                        <xsl:for-each select="./help:entry">

                            <xsl:sort select="@title"/>

                            <li>

                                <a href="#{@index}">
                                    <xsl:value-of select="@title"/>
                                </a>
                                
                            </li>                    

                        </xsl:for-each>                        

                    </blockquote>

                </xsl:for-each>

                <hr/>
                
                <xsl:apply-templates/>
                
            </body>

        </html>

    </xsl:template>

    <xsl:template match="help:section">

        <h3><xsl:value-of select="@name"/>:</h3>

        <xsl:apply-templates/>

    </xsl:template>
    
    <xsl:template match="help:entry">

        <p>

            <a name="{@index}">
                <b><u><xsl:value-of select="@title"/>:</u></b> ( <a href="#contents">Contents</a> )
            </a>

            <br/>

            <xsl:apply-templates/>
            
        </p>

    </xsl:template>

</xsl:stylesheet>
