<?xml version="1.0"?> 

<!--

$Id: mozilla-layout.xsl,v 1.5 2001/12/16 07:36:54 burton Exp $

==== BEGIN LICENSE ==============================================================

Copyright (C) 2000-2003 Kevin A. Burton (burton@openprivacy.org)
Copyright (C) 2000-2003 OpenPrivacy.org

This program is free software; you can redistribute it and/or modify it under
the terms of the LICENSE which you should have obtaind with this package.

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE.

==== END LICENSE ================================================================

Overview:

See http://reptile.openprivacy.org for more information

-->

<xsl:stylesheet xmlns="http://www.w3.org/1999/xhtml" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:layout="http://schemas.openprivacy.org/reptile/layout"
                xmlns:page="http://schemas.openprivacy.org/reptile/mozilla/page"
                xmlns:functions="xalan://org.openprivacy.reptile.extensions.Functions"
                extension-element-prefixes="functions"
                exclude-result-prefixes="layout page"
                version="1.0">

    <!-- by default, copy all matching templates -->
    <xsl:include href="resource:/xsl/misc/copy.xsl"/>

    <xsl:output indent="yes" 
                omit-xml-declaration="yes"/>                

    <!-- declare all parameters and provide default values -->
    <xsl:param name="reptile.home.location" select="''"/>

    <!-- the layer parameter defines what page layer we should use. -->
    <xsl:param name="reptile.layer" select="/layout:layout/layout:layer-index/@default"/>
    
    <xsl:template match="/layout:layout">

        <table width="100%" 
               border="0" 
               cellpadding="3" 
               cellspacing="0" 
               class="reptile-controller-background">

        <tr>

        <td colspan="2">
        
        <xsl:apply-templates select="./layout:layer-index"/>

        </td>

        </tr>

        <tr>

        <td width="50%" valign="top">
        <table width="100%">

            <xsl:apply-templates select="./layout:content/layout:position[@column='left'][@layer=$layer]"/>

        </table>
        </td>

        <td width="50%" valign="top">
        <table width="100%" cellspacing="0">
        
            <xsl:apply-templates select="./layout:content/layout:position[@column='right'][@layer=$layer]"/>

        </table>
        </td>        

        </tr>
        </table>

    </xsl:template>

    <!-- since only the position is matched we have to recreate the whole
    'content' element -->
    <xsl:template match="layout:position">

        <layout:content>

            <xsl:attribute name="location">

                <xsl:value-of select="../@location"/>

            </xsl:attribute>        

            <xsl:attribute name="contentType">

                <xsl:value-of select="../@contentType"/>

            </xsl:attribute>        

            <layout:position>

                <xsl:attribute name="column">

                    <xsl:value-of select="@column"/>

                </xsl:attribute>        

                <xsl:attribute name="layer">

                    <xsl:value-of select="@layer"/>

                </xsl:attribute>        

            </layout:position>

        </layout:content>

    </xsl:template>

    <xsl:template match="layout:layer-index">

        Layers: <xsl:apply-templates select="./layout:layer"/>

    </xsl:template>

    <xsl:template match="layout:layer">

        <a>

            <xsl:attribute name="href">

                <xsl:value-of select="concat( $reptile.home.location, '?reptile.layer=', functions:encode( @name ) )"/>
                
            </xsl:attribute>

            <xsl:value-of select="@name"/>

        </a>

    </xsl:template>

</xsl:stylesheet>

