<?xml version="1.0"?> 

<!--

$Id: ocs.xsl,v 1.2 2001/06/21 09:21:41 burton Exp $

==== BEGIN LICENSE ==============================================================

Copyright (C) 2000-2003 Kevin A. Burton (burton@openprivacy.org)
Copyright (C) 2000-2003 OpenPrivacy.org

This program is free software; you can redistribute it and/or modify it under
the terms of the LICENSE which you should have obtaind with this package.

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE.

==== END LICENSE ================================================================

Overview:

Example:

<channels>
    
    <list>
        <entry>
        
        </entry>

    </list>


    <search-results>

        <result>

        </result>

    </search-results>

</channels>

See http://reptile.openprivacy.org for more information

-->

<xsl:stylesheet xmlns="http://www.w3.org/1999/xhtml" 
                xmlns:dc="http://purl.org/metadata/dublin_core#"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
                xmlns:ocs="http://alchemy.openjava.org/ocs/directory#"
                xmlns:channels="http://schemas.openprivacy.org/content/syndication/channels"
                exclude-result-prefixes=""
                version="1.0">

    <xsl:output indent="yes"
                omit-xml-declaration="yes"/>                

    <xsl:param name="reptile.syndication.channels.param.select-channel" select="''"/> 

    <xsl:template match="/rdf:RDF">

        <channels:channels>

            <channels:list>

                <xsl:apply-templates select="/rdf:RDF/rdf:description/rdf:description"/>

            </channels:list>


        <xsl:if test="$reptile.syndication.channels.param.select-channel != ''">
        
            <channels:search-results>

                <xsl:apply-templates select="./rdf:description/rdf:description[ contains( @about, $reptile.syndication.channels.param.select-channel ) ]/rdf:description"/>

            </channels:search-results>

        </xsl:if>

        </channels:channels>

    </xsl:template>

    <xsl:template match="/rdf:RDF/rdf:description/rdf:description">

        <channels:entry>

        <dc:title><xsl:value-of select="./dc:title"/></dc:title>
        <dc:creator><xsl:value-of select="./dc:creator"/></dc:creator>
        <dc:description><xsl:value-of select="./dc:description"/></dc:description>

        </channels:entry>

    </xsl:template>

    <!-- individual channel matches -->
    <xsl:template match="/rdf:RDF/rdf:description/rdf:description/rdf:description">

        <!-- only return if ocs:format is defined... -->

        <xsl:if test="./ocs:format != ''">

            <channels:result>

            <channels:location><xsl:value-of select="@about"/></channels:location>        

            <ocs:format><xsl:value-of select="./ocs:format"/></ocs:format>
    
            </channels:result>

        </xsl:if>

    </xsl:template>

</xsl:stylesheet>

