/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.RuntimeConfigurable;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TaskContainer;
import org.apache.tools.ant.UnknownElement;

public class Target
implements TaskContainer {
    private String name;
    private String ifCondition = "";
    private String unlessCondition = "";
    private Vector dependencies = new Vector(2);
    private Vector children = new Vector(5);
    private Project project;
    private String description = null;

    public void setProject(Project project) {
        this.project = project;
    }

    public Project getProject() {
        return this.project;
    }

    public void setDepends(String string) {
        if (string.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",", true);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken().trim();
                if (string2.equals("") || string2.equals(",")) {
                    throw new BuildException("Syntax Error: Depend attribute for target \"" + this.getName() + "\" has an empty string for dependency.");
                }
                this.addDependency(string2);
                if (!stringTokenizer.hasMoreTokens()) continue;
                string2 = stringTokenizer.nextToken();
                if (stringTokenizer.hasMoreTokens() && string2.equals(",")) continue;
                throw new BuildException("Syntax Error: Depend attribute for target \"" + this.getName() + "\" ends with a , character");
            }
        }
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void addTask(Task task) {
        this.children.addElement(task);
    }

    public void addDataType(RuntimeConfigurable runtimeConfigurable) {
        this.children.addElement(runtimeConfigurable);
    }

    public Task[] getTasks() {
        Object object;
        Vector vector = new Vector(this.children.size());
        Enumeration enumeration = this.children.elements();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            if (!(object instanceof Task)) continue;
            vector.addElement(object);
        }
        object = new Task[vector.size()];
        vector.copyInto((Object[])object);
        return object;
    }

    public void addDependency(String string) {
        this.dependencies.addElement(string);
    }

    public Enumeration getDependencies() {
        return this.dependencies.elements();
    }

    public void setIf(String string) {
        this.ifCondition = string == null ? "" : string;
    }

    public void setUnless(String string) {
        this.unlessCondition = string == null ? "" : string;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return this.name;
    }

    public void execute() throws BuildException {
        if (this.testIfCondition() && this.testUnlessCondition()) {
            Enumeration enumeration = this.children.elements();
            while (enumeration.hasMoreElements()) {
                Object object;
                Object e = enumeration.nextElement();
                if (e instanceof Task) {
                    object = (Task)e;
                    ((Task)object).perform();
                    continue;
                }
                object = (RuntimeConfigurable)e;
                ((RuntimeConfigurable)object).maybeConfigure(this.project);
            }
        } else if (!this.testIfCondition()) {
            this.project.log(this, "Skipped because property '" + this.ifCondition + "' not set.", 3);
        } else {
            this.project.log(this, "Skipped because property '" + this.unlessCondition + "' set.", 3);
        }
    }

    public final void performTasks() {
        try {
            this.project.fireTargetStarted(this);
            this.execute();
            this.project.fireTargetFinished(this, null);
        }
        catch (RuntimeException runtimeException) {
            this.project.fireTargetFinished(this, runtimeException);
            throw runtimeException;
        }
    }

    void replaceTask(UnknownElement unknownElement, Task task) {
        int n = -1;
        while ((n = this.children.indexOf(unknownElement)) >= 0) {
            this.children.setElementAt(task, n);
        }
    }

    private boolean testIfCondition() {
        if ("".equals(this.ifCondition)) {
            return true;
        }
        String string = ProjectHelper.replaceProperties(this.getProject(), this.ifCondition, this.getProject().getProperties());
        return this.project.getProperty(string) != null;
    }

    private boolean testUnlessCondition() {
        if ("".equals(this.unlessCondition)) {
            return true;
        }
        String string = ProjectHelper.replaceProperties(this.getProject(), this.unlessCondition, this.getProject().getProperties());
        return this.project.getProperty(string) == null;
    }
}

