/*
 * Decompiled with CFR 0.152.
 */
package org.openprivacy.htparser.implementations;

import java.io.IOException;
import java.io.InputStream;
import org.apache.regexp.RE;
import org.openprivacy.htparser.components.HTParser;
import talon.BaseComponent;
import talon.Component;
import talon.TalonException;
import talon.util.InputStreamUtils;
import talon.util.net.URI;

public class HTParserImpl
extends BaseComponent
implements Component,
HTParser {
    private static final String descriptionRegexp = "<meta[ ]+name=\"description\"[ ]+content=\"([^\"]+)";
    private static final String titleRegexp = "<title>([^<>]*)</title>";
    private String description = null;
    private String title = null;
    private URI location = null;
    private String content = "";

    public void init() throws TalonException {
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public URI getLocation() {
        return this.location;
    }

    public void setLocation(URI location) {
        this.location = location;
    }

    public void parse() throws IOException {
        this.getLogger().message("Fetching content stream...");
        this.content = InputStreamUtils.toString((InputStream)this.getLocation().getURL().openStream());
        this.parseDescription();
        this.parseTitle();
    }

    private boolean parseDescription() {
        try {
            RE regexp = new RE(descriptionRegexp);
            regexp.setMatchFlags(5);
            if (regexp.match(this.content)) {
                this.description = regexp.getParen(1);
                return true;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return false;
    }

    private boolean parseTitle() {
        try {
            RE regexp = new RE(titleRegexp);
            regexp.setMatchFlags(5);
            if (regexp.match(this.content)) {
                this.title = regexp.getParen(1);
                return true;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return false;
    }
}

