/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.protocol;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownServiceException;
import java.util.Enumeration;
import java.util.Hashtable;
import net.jxta.document.Advertisement;
import net.jxta.document.Element;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentUtils;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroupID;

public abstract class PeerAdvertisement
extends Advertisement
implements Cloneable {
    private PeerID pid = null;
    private PeerGroupID gid = null;
    private String name = null;
    private String description = null;
    private String debugLevel = null;
    private Hashtable serviceParams = new Hashtable();

    public Object clone() {
        try {
            PeerAdvertisement peerAdvertisement = (PeerAdvertisement)super.clone();
            peerAdvertisement.serviceParams = (Hashtable)this.serviceParams.clone();
            return peerAdvertisement;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public static String getAdvertisementType() {
        return "jxta:PA";
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public PeerID getPeerID() {
        return this.pid == null ? null : (PeerID)this.pid.clone();
    }

    public void setPeerID(PeerID peerID) {
        this.pid = peerID == null ? null : (PeerID)peerID.clone();
    }

    public PeerGroupID getPeerGroupID() {
        return this.gid == null ? null : (PeerGroupID)this.gid.clone();
    }

    public void setPeerGroupID(PeerGroupID peerGroupID) {
        this.gid = peerGroupID == null ? null : (PeerGroupID)peerGroupID.clone();
    }

    public ID getID() {
        String string;
        if (this.gid == null || this.pid == null) {
            return null;
        }
        if (this.gid.equals(PeerGroupID.defaultNetPeerGroupID) || this.gid.equals(PeerGroupID.worldPeerGroupID)) {
            string = this.pid.getUniqueValue().toString();
        } else {
            String string2 = this.gid.getUniqueValue().toString();
            string2 = string2.substring(0, string2.length() - 2);
            string = this.pid.getUniqueValue().toString();
            string = string2 + string.substring(string2.length());
        }
        try {
            return IDFactory.fromURL(new URL("urn", "", "jxta:" + string));
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (UnknownServiceException unknownServiceException) {
            // empty catch block
        }
        return null;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getDebugLevel() {
        return this.debugLevel;
    }

    public void setDebugLevel(String string) {
        this.debugLevel = string;
    }

    public void setServiceParams(Hashtable hashtable) {
        if (hashtable == null) {
            this.serviceParams = new Hashtable();
            return;
        }
        Hashtable<Object, StructuredDocument> hashtable2 = new Hashtable<Object, StructuredDocument>();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            ID iD = (ID)enumeration.nextElement();
            Element element = (Element)hashtable.get(iD);
            StructuredDocument structuredDocument = StructuredDocumentUtils.copyAsDocument(element);
            hashtable2.put(iD.clone(), structuredDocument);
        }
        this.serviceParams = hashtable2;
    }

    public Hashtable getServiceParams() {
        Hashtable<Object, StructuredDocument> hashtable = new Hashtable<Object, StructuredDocument>();
        Enumeration enumeration = this.serviceParams.keys();
        while (enumeration.hasMoreElements()) {
            ID iD = (ID)enumeration.nextElement();
            Element element = (Element)this.serviceParams.get(iD);
            StructuredDocument structuredDocument = StructuredDocumentUtils.copyAsDocument(element);
            hashtable.put(iD.clone(), structuredDocument);
        }
        return hashtable;
    }

    public void putServiceParam(ID iD, Element element) {
        if (element == null) {
            this.serviceParams.remove(iD);
            return;
        }
        StructuredDocument structuredDocument = StructuredDocumentUtils.copyAsDocument(element);
        this.serviceParams.put(iD.clone(), structuredDocument);
    }

    public StructuredDocument getServiceParam(ID iD) {
        Element element = (Element)this.serviceParams.get(iD);
        if (element == null) {
            return null;
        }
        StructuredDocument structuredDocument = StructuredDocumentUtils.copyAsDocument(element);
        return structuredDocument;
    }

    public StructuredDocument removeServiceParam(ID iD) {
        Element element = (Element)this.serviceParams.remove(iD);
        if (element == null) {
            return null;
        }
        StructuredDocument structuredDocument = StructuredDocumentUtils.copyAsDocument(element);
        return structuredDocument;
    }
}

