/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.util;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Random;
import net.jxta.endpoint.Message;
import net.jxta.impl.util.BidirectionalPipeService;
import net.jxta.impl.util.IncomingMessageQueue;
import net.jxta.impl.util.OutgoingMessageQueue;
import net.jxta.impl.util.SchedulerService;
import net.jxta.impl.util.Timer;
import net.jxta.pipe.InputPipe;
import net.jxta.pipe.OutputPipe;
import net.jxta.protocol.PipeAdvertisement;

public class ReliablePipeService {
    BidirectionalPipeService bidirPipeService;
    SchedulerService schedulerService;
    static final String RELIABLE_HEADER = "RELIABLE_HEADER";
    static final int SYN = 1;
    static final int SYN_ACK = 2;
    static final int MSG = 3;
    static final int ACK = 4;
    static final int FIN1 = 5;
    static final int FIN2 = 6;
    static final int ESTABLISHING = 1;
    static final int CONNECTED = 2;
    static final int TIMED_OUT = 3;
    static final int CLOSE_WAIT = 4;
    static final int CLOSED = 5;
    static final int MAX_RETRANSMITS = 5;
    static final int MSG_TIMEOUT = 30000;
    static final int RETRANSMIT_TIMEOUT = 1000;
    static final int WINDOW_FLUSH_TIMEOUT = 500;

    public ReliablePipeService(BidirectionalPipeService bidirectionalPipeService) {
        this.bidirPipeService = bidirectionalPipeService;
        this.schedulerService = new SchedulerService();
        new Thread(this.schedulerService).start();
    }

    public Pipe connect(PipeAdvertisement pipeAdvertisement, int n) throws IOException {
        long l = System.currentTimeMillis();
        BidirectionalPipeService.Pipe pipe = this.bidirPipeService.connect(pipeAdvertisement, n);
        if ((n = (int)((long)n - (System.currentTimeMillis() - (long)n))) > 0) {
            return new Pipe(pipe, n);
        }
        throw new IOException("Connect timed out.");
    }

    public AcceptPipe bind(String string) throws IOException {
        return new AcceptPipe(this.bidirPipeService.bind(string));
    }

    public class Pipe
    implements InputPipe,
    OutputPipe {
        IncomingMessageQueue incomingQueue;
        IncomingMessageQueue incomingQueue2;
        OutgoingMessageQueue outgoingQueue;
        HashMap pendingRetransmits;
        long outgoingSeq;
        long highestInSeq;
        long lastAckedSeq;
        InputPipe inputPipe;
        OutputPipe outputPipe;
        Receiver receiver;
        Sender sender;
        int outgoingWindow;
        int state;
        boolean running;

        Pipe(BidirectionalPipeService.Pipe pipe, long l) throws IOException {
            this.inputPipe = pipe.getInputPipe();
            this.outputPipe = pipe.getOutputPipe();
            this.incomingQueue = new IncomingMessageQueue(512);
            this.incomingQueue2 = new IncomingMessageQueue(512);
            this.outgoingQueue = new OutgoingMessageQueue(512);
            this.pendingRetransmits = new HashMap();
            this.state = 1;
            this.establish(l);
            this.receiver = new Receiver();
            new Thread(this.receiver).start();
        }

        public InputPipe getInputPipe() {
            return this;
        }

        public OutputPipe getOutputPipe() {
            return this;
        }

        void establish(long l) throws IOException {
            this.sendMsg(1, 0L, 0);
            try {
                while (this.state == 1) {
                    this.wait(l);
                }
            }
            catch (InterruptedException interruptedException) {
                throw new IOException("Interrupted while establishing connection.");
            }
            if (this.state != 2) {
                throw new IOException("Connect timed out.");
            }
            this.sender = new Sender();
            new Thread(this.sender).start();
        }

        public void close() {
            if (this.state != 4) {
                this.state = 4;
                try {
                    this.sendMsg(5, -1L, 0);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        public synchronized void send(Message message) throws IOException {
            switch (this.state) {
                case 1: {
                    throw new Error("Should never be here.  Theis state is only while the contructor is running.");
                }
                case 2: {
                    try {
                        this.outgoingQueue.enqueue(message);
                        break;
                    }
                    catch (InterruptedException interruptedException) {
                        throw new IOException("Thread was interrupted while in send(): " + interruptedException.getMessage());
                    }
                }
                case 3: {
                    throw new IOException("The peer at the other end has dropped the connection.");
                }
                case 4: {
                    throw new IOException("Shutdown in progress.");
                }
                case 5: {
                    throw new IOException("Connection has closed.");
                }
            }
        }

        public synchronized Message waitForMessage() throws InterruptedException {
            return this.poll(-1);
        }

        public synchronized Message poll(int n) throws InterruptedException {
            return this.incomingQueue.pop(n);
        }

        synchronized void process(Message message) throws IOException {
            DataInputStream dataInputStream = new DataInputStream(message.getElement(ReliablePipeService.RELIABLE_HEADER).getStream());
            long l = dataInputStream.readLong();
            int n = dataInputStream.readInt();
            int n2 = dataInputStream.readInt();
            if (n != 1 && n != 2 && n != 4) {
                this.incomingQueue2.put(message, l);
                this.highestInSeq = this.incomingQueue2.popUntilBreakInSequence(this.highestInSeq);
                this.sendMsg(4, this.highestInSeq, this.incomingQueue.getFreeSlots());
            }
            switch (this.state) {
                case 1: {
                    switch (n) {
                        case 1: {
                            this.outgoingSeq = new Random().nextLong();
                            this.sendMsg(2, this.outgoingSeq, 0);
                            break;
                        }
                        case 2: {
                            this.lastAckedSeq = this.highestInSeq = l;
                            this.state = 2;
                            this.notifyAll();
                        }
                    }
                    break;
                }
                case 2: {
                    switch (n) {
                        case 3: {
                            this.incomingQueue.put(message, l);
                            break;
                        }
                        case 4: {
                            Object v = this.pendingRetransmits.get(new Long(l));
                            if (v == null) break;
                            ReliablePipeService.this.schedulerService.cancelAction(v);
                            this.pendingRetransmits.remove(new Long(l));
                            this.outgoingQueue.slide(l - this.lastAckedSeq);
                            this.lastAckedSeq = l;
                            this.outgoingWindow = n2;
                            break;
                        }
                        case 5: {
                            this.state = 4;
                        }
                    }
                }
                case 4: {
                    switch (n) {
                        case 6: {
                            this.state = 5;
                        }
                    }
                }
            }
        }

        void sendMsg(int n, long l, int n2) throws IOException {
            Message message = ReliablePipeService.this.bidirPipeService.pipeService.createMessage();
            this.setHeader(message, n, l, n2);
            this.outputPipe.send(message);
            if (n != 4) {
                Object object = ReliablePipeService.this.schedulerService.scheduleAction(new RetransmitAction(message), 1000L);
                this.pendingRetransmits.put(message, object);
            }
        }

        void sendMsg(Message message, long l) throws IOException {
            this.setHeader(message, 3, l, 0);
            this.outputPipe.send(message);
            Object object = ReliablePipeService.this.schedulerService.scheduleAction(new RetransmitAction(message), 1000L);
            this.pendingRetransmits.put(message, object);
        }

        void setHeader(Message message, int n, long l, int n2) throws IOException {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(12);
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeLong(l);
            dataOutputStream.writeInt(n);
            dataOutputStream.writeInt(n2);
            message.newMessageElement(ReliablePipeService.RELIABLE_HEADER, null, byteArrayOutputStream.toByteArray());
        }

        class RetransmitAction
        implements SchedulerService.Action {
            Message msg;
            int retransmits;

            RetransmitAction(Message message) {
                this.msg = message;
            }

            public void perform(SchedulerService schedulerService) {
                try {
                    Pipe.this.outputPipe.send(this.msg);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (this.retransmits < 5) {
                    Object object = schedulerService.scheduleAction(this, 1000L);
                    Pipe.this.pendingRetransmits.put(this.msg, object);
                } else {
                    Pipe.this.state = 3;
                    this.notifyAll();
                }
            }
        }

        class Sender
        implements Runnable {
            Sender() {
            }

            public void run() {
                Timer timer = new Timer();
                block6: while (Pipe.this.state != 4 || !Pipe.this.outgoingQueue.isEmpty()) {
                    timer.start();
                    int n = 0;
                    while (n < Pipe.this.outgoingWindow) {
                        try {
                            Message message = Pipe.this.outgoingQueue.get(n, 500L - timer.elapsed());
                            if (message == null) continue block6;
                            try {
                                Pipe.this.sendMsg(message, Pipe.this.outgoingSeq++);
                            }
                            catch (IOException iOException) {}
                        }
                        catch (InterruptedException interruptedException) {
                            continue block6;
                        }
                        ++n;
                    }
                }
                if (Pipe.this.state == 4) {
                    try {
                        Pipe.this.sendMsg(6, Pipe.this.outgoingSeq++, 0);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }

        class Receiver
        implements Runnable {
            Receiver() {
            }

            public void run() {
                while (Pipe.this.state != 5) {
                    try {
                        Message message = Pipe.this.inputPipe.poll(30000);
                        if (!Pipe.this.running) break;
                        if (message == null) continue;
                        Pipe.this.process(message);
                    }
                    catch (InterruptedException interruptedException) {
                        break;
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
        }
    }

    public class AcceptPipe {
        BidirectionalPipeService.AcceptPipe acceptPipe;

        AcceptPipe(BidirectionalPipeService.AcceptPipe acceptPipe) {
            this.acceptPipe = acceptPipe;
        }

        public PipeAdvertisement getAdvertisement() {
            return this.acceptPipe.getAdvertisement();
        }

        public Pipe accept(int n) throws IOException, InterruptedException {
            long l = System.currentTimeMillis();
            BidirectionalPipeService.Pipe pipe = this.acceptPipe.accept(n);
            if ((n = (int)((long)n - (System.currentTimeMillis() - (long)n))) > 0) {
                return new Pipe(pipe, n);
            }
            throw new IOException("Connect timed out.");
        }
    }
}

