/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.util;

import net.jxta.endpoint.Message;

class OutgoingMessageQueue {
    Message[] arr;
    int head;
    int tail;
    int total;

    OutgoingMessageQueue(int n) {
        this.arr = new Message[n];
    }

    synchronized void enqueue(Message message) throws InterruptedException {
        while (this.isFull()) {
            this.wait();
        }
        this.arr[this.tail] = message;
        this.tail = (this.tail + 1) % this.arr.length;
        ++this.total;
        this.notifyAll();
    }

    synchronized void slide(long l) {
        int n = 0;
        while ((long)n < l) {
            this.arr[this.head] = null;
            this.head = (this.head + 1) % this.arr.length;
            ++n;
        }
    }

    synchronized Message get(int n, long l) throws InterruptedException {
        while (this.total < n) {
            long l2 = System.currentTimeMillis();
            this.wait(l);
            if (System.currentTimeMillis() - l2 < l) continue;
            return null;
        }
        return this.arr[(this.head + n) % this.arr.length];
    }

    synchronized Message dequeue(Message message, long l) throws InterruptedException {
        while (this.isEmpty()) {
            long l2 = System.currentTimeMillis();
            this.wait(l);
            if (System.currentTimeMillis() - l2 < l) continue;
            return null;
        }
        Message message2 = this.arr[this.head];
        this.arr[this.head] = null;
        this.head = (this.head + 1) % this.arr.length;
        --this.total;
        return message2;
    }

    boolean isEmpty() {
        return this.total == 0;
    }

    boolean isFull() {
        return this.total == this.arr.length;
    }

    int getMessageCount() {
        return this.total;
    }

    int getFreeSlots() {
        return this.arr.length - this.total;
    }
}

