/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.util;

import java.util.Enumeration;
import java.util.Hashtable;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointFilterListener;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.endpoint.MessageElementEnumeration;

public class EndpointServiceStatsFilter
implements EndpointFilterListener {
    long lastMessageTime;
    Hashtable channelTrafficTable = new Hashtable();
    Hashtable sourceCountTable = new Hashtable();
    Hashtable destCountTable = new Hashtable();

    public Message processIncomingMessage(Message message, EndpointAddress endpointAddress, EndpointAddress endpointAddress2) {
        MessageElementEnumeration messageElementEnumeration = message.getElements();
        while (messageElementEnumeration.hasMoreMessageElements()) {
            String string;
            MessageElement messageElement = messageElementEnumeration.nextMessageElement();
            String string2 = messageElement.getName();
            int n = string2.indexOf(58);
            if (n == -1) {
                string = "";
            } else {
                string = string2.substring(0, n);
                string2 = string2.substring(n + 1);
            }
            this.incrementCount(this.channelTrafficTable, endpointAddress.getProtocolName() + "://" + endpointAddress.getProtocolAddress() + "/" + string, messageElement.getLength());
            this.incrementCount(this.channelTrafficTable, endpointAddress.getProtocolName() + "://" + endpointAddress.getProtocolAddress() + "/" + messageElement.getName(), messageElement.getLength());
        }
        if (endpointAddress != null) {
            this.incrementCount(this.sourceCountTable, endpointAddress, 1);
        }
        if (endpointAddress2 != null) {
            this.incrementCount(this.destCountTable, endpointAddress2, 1);
        }
        this.lastMessageTime = System.currentTimeMillis();
        return message;
    }

    public long getLastMessageTime() {
        return this.lastMessageTime;
    }

    public long getTrafficOnChannel(String string) {
        return this.getCount(this.channelTrafficTable, string);
    }

    public Enumeration getChannelNames() {
        return this.channelTrafficTable.keys();
    }

    public long getMessageCountFrom(EndpointAddress endpointAddress) {
        return this.getCount(this.sourceCountTable, endpointAddress);
    }

    public long getMessageCountTo(EndpointAddress endpointAddress) {
        return this.getCount(this.destCountTable, endpointAddress);
    }

    private long getCount(Hashtable hashtable, Object object) {
        Counter counter = (Counter)hashtable.get(object);
        return counter == null ? -1L : counter.value;
    }

    private void incrementCount(Hashtable hashtable, Object object, int n) {
        Counter counter = (Counter)hashtable.get(object);
        if (counter == null) {
            counter = new Counter();
            hashtable.put(object, counter);
        }
        counter.value += (long)n;
    }

    private static final class Counter {
        long value;

        private Counter() {
        }
    }
}

