/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.util;

import java.io.IOException;
import java.io.InputStream;
import net.jxta.discovery.DiscoveryService;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Document;
import net.jxta.document.MimeMediaType;
import net.jxta.endpoint.Message;
import net.jxta.id.IDFactory;
import net.jxta.peergroup.PeerGroup;
import net.jxta.pipe.InputPipe;
import net.jxta.pipe.OutputPipe;
import net.jxta.pipe.PipeMsgEvent;
import net.jxta.pipe.PipeMsgListener;
import net.jxta.pipe.PipeService;
import net.jxta.protocol.PipeAdvertisement;

public class BidirectionalPipeService {
    PeerGroup peerGroup;
    DiscoveryService discoveryService;
    PipeService pipeService;

    public BidirectionalPipeService(PeerGroup peerGroup) {
        this.peerGroup = peerGroup;
        this.pipeService = peerGroup.getPipeService();
        this.discoveryService = peerGroup.getDiscoveryService();
    }

    public AcceptPipe bind(String string) throws IOException {
        PipeAdvertisement pipeAdvertisement = (PipeAdvertisement)AdvertisementFactory.newAdvertisement("jxta:PipeAdvertisement");
        pipeAdvertisement.setPipeID(IDFactory.newPipeID(this.peerGroup.getPeerGroupID()));
        pipeAdvertisement.setName(string + ".end1");
        InputPipe inputPipe = this.pipeService.createInputPipe(pipeAdvertisement);
        this.discoveryService.publish(pipeAdvertisement, 2);
        this.discoveryService.remotePublish(pipeAdvertisement, 2);
        System.out.println("Published bidir pipe " + pipeAdvertisement.getPipeID());
        return new AcceptPipe(pipeAdvertisement, inputPipe);
    }

    public Pipe connect(PipeAdvertisement pipeAdvertisement, int n) throws IOException {
        InputStream inputStream;
        Document document;
        OutputPipe outputPipe = this.pipeService.createOutputPipe(pipeAdvertisement, n / 2);
        PipeAdvertisement pipeAdvertisement2 = (PipeAdvertisement)AdvertisementFactory.newAdvertisement("jxta:PipeAdvertisement");
        pipeAdvertisement2.setPipeID(IDFactory.newPipeID(this.peerGroup.getPeerGroupID()));
        pipeAdvertisement2.setName(pipeAdvertisement.getName() + ".in");
        InputPipe inputPipe = this.pipeService.createInputPipe(pipeAdvertisement2);
        Message message = this.pipeService.createMessage();
        try {
            document = pipeAdvertisement2.getDocument(new MimeMediaType("text/xml"));
        }
        catch (Exception exception) {
            throw new IOException("Unable to create input pipe advertisement document.");
        }
        message.addElement(message.newMessageElement("InputPipeAdv", null, document.getStream()));
        outputPipe.send(message);
        try {
            message = inputPipe.poll(n / 2);
            if (message == null || (inputStream = message.getElement("InputPipeAdvAck").getStream()) == null) {
                throw new IOException("Expecting bi-directional pipe confirmation.");
            }
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("Did not receive expected bi-directional confirmation.");
        }
        PipeAdvertisement pipeAdvertisement3 = (PipeAdvertisement)AdvertisementFactory.newAdvertisement(new MimeMediaType("text", "xml"), inputStream);
        OutputPipe outputPipe2 = this.pipeService.createOutputPipe(pipeAdvertisement3, n / 2);
        return new Pipe(inputPipe, outputPipe2);
    }

    class PipeMsgListenerImpl
    implements PipeMsgListener {
        MessageListener msgListener;
        OutputPipe outputPipe;

        PipeMsgListenerImpl(MessageListener messageListener, OutputPipe outputPipe) {
            this.msgListener = messageListener;
            this.outputPipe = outputPipe;
        }

        public void pipeMsgEvent(PipeMsgEvent pipeMsgEvent) {
            this.msgListener.messageReceived(pipeMsgEvent.getMessage(), this.outputPipe);
        }
    }

    public static interface MessageListener {
        public void messageReceived(Message var1, OutputPipe var2);
    }

    public class Pipe {
        InputPipe inputPipe;
        OutputPipe outputPipe;
        MessageListener msgListener;

        Pipe(InputPipe inputPipe, OutputPipe outputPipe) {
            this.inputPipe = inputPipe;
            this.outputPipe = outputPipe;
        }

        public InputPipe getInputPipe() {
            return this.inputPipe;
        }

        public OutputPipe getOutputPipe() {
            return this.outputPipe;
        }
    }

    public class AcceptPipe {
        PipeAdvertisement acceptInputPipeAdv;
        InputPipe acceptInputPipe;
        boolean done;

        AcceptPipe(PipeAdvertisement pipeAdvertisement, InputPipe inputPipe) {
            this.acceptInputPipeAdv = pipeAdvertisement;
            this.acceptInputPipe = inputPipe;
            this.done = false;
        }

        public PipeAdvertisement getAdvertisement() {
            return this.acceptInputPipeAdv;
        }

        public Pipe accept(int n) throws IOException, InterruptedException {
            return this.accept(n, null);
        }

        public Pipe accept(int n, MessageListener messageListener) throws IOException, InterruptedException {
            Message message = this.acceptInputPipe.poll(n / 2);
            if (message == null) {
                throw new InterruptedException("Timed out in accept.");
            }
            if (this.done && message.hasElement("Close")) {
                throw new InterruptedException();
            }
            if (!this.done) {
                Document document;
                InputStream inputStream = message.getElement("InputPipeAdv").getStream();
                PipeAdvertisement pipeAdvertisement = (PipeAdvertisement)AdvertisementFactory.newAdvertisement(new MimeMediaType("text", "xml"), inputStream);
                OutputPipe outputPipe = BidirectionalPipeService.this.pipeService.createOutputPipe(pipeAdvertisement, n / 2);
                PipeAdvertisement pipeAdvertisement2 = (PipeAdvertisement)AdvertisementFactory.newAdvertisement("jxta:PipeAdvertisement");
                pipeAdvertisement2.setPipeID(IDFactory.newPipeID(BidirectionalPipeService.this.peerGroup.getPeerGroupID()));
                pipeAdvertisement2.setName(pipeAdvertisement.getName() + ".out");
                InputPipe inputPipe = messageListener == null ? BidirectionalPipeService.this.pipeService.createInputPipe(pipeAdvertisement2) : BidirectionalPipeService.this.pipeService.createInputPipe(pipeAdvertisement2, new PipeMsgListenerImpl(messageListener, outputPipe));
                try {
                    document = pipeAdvertisement2.getDocument(new MimeMediaType("text/xml"));
                }
                catch (Exception exception) {
                    throw new IOException("Unable to create input pipe advertisement document.");
                }
                message = BidirectionalPipeService.this.pipeService.createMessage();
                message.addElement(message.newMessageElement("InputPipeAdvAck", null, document.getStream()));
                System.out.println("Sending bidir pipe ack.");
                outputPipe.send(message);
                return new Pipe(inputPipe, outputPipe);
            }
            throw new IOException("Pipe closed.");
        }

        public synchronized void close() {
            this.done = true;
            this.acceptInputPipe.close();
        }
    }
}

