/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.protocol;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.Enumeration;
import net.jxta.document.Document;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.TextElement;
import net.jxta.protocol.ResolverResponseMsg;

public class ResolverResponse
extends ResolverResponseMsg {
    private static final String handlernameTag = "HandlerName";
    private static final String credentialTag = "Credential";
    private static final String queryIdTag = "QueryID";
    private static final String responseTag = "Response";

    public ResolverResponse(InputStream inputStream) throws IOException {
        StructuredTextDocument structuredTextDocument = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(new MimeMediaType("text", "xml"), inputStream);
        this.readIt(structuredTextDocument);
    }

    public ResolverResponse(TextElement textElement) {
        if (!ResolverResponseMsg.getAdvertisementType().equals(textElement.getName())) {
            throw new IllegalArgumentException("Could not construct : " + this.getClass().getName() + "from doc containing a " + textElement.getName());
        }
        this.readIt(textElement);
    }

    public void readIt(TextElement textElement) {
        Enumeration enumeration = textElement.getChildren();
        while (enumeration.hasMoreElements()) {
            TextElement textElement2 = (TextElement)enumeration.nextElement();
            if (textElement2.getName().equals(handlernameTag)) {
                this.setHandlerName(textElement2.getTextValue());
                continue;
            }
            if (textElement2.getName().equals(credentialTag)) {
                this.setCredential(textElement2.getTextValue());
                continue;
            }
            if (textElement2.getName().equals(queryIdTag)) {
                ResolverResponseMsg.queryid = Integer.parseInt(textElement2.getTextValue());
                continue;
            }
            if (!textElement2.getName().equals(responseTag)) continue;
            this.setResponse(textElement2.getTextValue());
        }
    }

    public ResolverResponse(String string, String string2, int n, String string3) {
        this.setHandlerName(string);
        this.setCredential(string2);
        ResolverResponseMsg.queryid = n;
        this.setResponse(string3);
    }

    public Document getDocument(MimeMediaType mimeMediaType) throws Exception {
        StructuredTextDocument structuredTextDocument = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(mimeMediaType, ResolverResponseMsg.getAdvertisementType());
        TextElement textElement = structuredTextDocument.createElement(handlernameTag, this.getHandlerName());
        structuredTextDocument.appendChild((Element)textElement);
        textElement = structuredTextDocument.createElement(credentialTag, this.getCredential());
        structuredTextDocument.appendChild((Element)textElement);
        textElement = structuredTextDocument.createElement(queryIdTag, Integer.toString(ResolverResponseMsg.queryid));
        structuredTextDocument.appendChild((Element)textElement);
        textElement = structuredTextDocument.createElement(responseTag, this.getResponse());
        structuredTextDocument.appendChild((Element)textElement);
        return structuredTextDocument;
    }

    public String toString() {
        try {
            StringWriter stringWriter = new StringWriter();
            StructuredTextDocument structuredTextDocument = (StructuredTextDocument)this.getDocument(new MimeMediaType("text/xml"));
            structuredTextDocument.sendToWriter(stringWriter);
            return stringWriter.toString();
        }
        catch (Exception exception) {
            return "";
        }
    }
}

