/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.protocol;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownServiceException;
import java.util.Enumeration;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Document;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredDocumentUtils;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.TextElement;
import net.jxta.id.IDFactory;
import net.jxta.platform.ModuleSpecID;
import net.jxta.protocol.ModuleImplAdvertisement;

public class ModuleImplAdv
extends ModuleImplAdvertisement {
    private static final String msidTag = "MSID";
    private static final String compTag = "Comp";
    private static final String codeTag = "Code";
    private static final String uriTag = "PURI";
    private static final String provTag = "Prov";
    private static final String descTag = "Desc";
    private static final String paramTag = "Parm";
    static /* synthetic */ Class class$net$jxta$document$TextElement;

    public ModuleImplAdv() {
    }

    public ModuleImplAdv(Element element) {
        this.initialize(element);
    }

    void initialize(Element element) {
        if (!(class$net$jxta$document$TextElement == null ? (class$net$jxta$document$TextElement = ModuleImplAdv.class$("net.jxta.document.TextElement")) : class$net$jxta$document$TextElement).isInstance(element)) {
            throw new IllegalArgumentException(this.getClass().getName() + " only supports TextElement");
        }
        TextElement textElement = (TextElement)element;
        if (!textElement.getName().equals(ModuleImplAdvertisement.getAdvertisementType())) {
            throw new IllegalArgumentException("Could not construct : " + this.getClass().getName() + "from doc containing a " + textElement.getName());
        }
        this.setModuleSpecID(null);
        this.setCompat(null);
        this.setCode(null);
        this.setUri(null);
        this.setProvider(null);
        this.setDescription(null);
        this.setParam(null);
        Enumeration enumeration = textElement.getChildren();
        while (enumeration.hasMoreElements()) {
            TextElement textElement2 = (TextElement)enumeration.nextElement();
            String string = textElement2.getName();
            if (string.equals(msidTag)) {
                try {
                    URL uRL = new URL(textElement2.getTextValue());
                    this.setModuleSpecID((ModuleSpecID)IDFactory.fromURL(uRL));
                    continue;
                }
                catch (MalformedURLException malformedURLException) {
                    throw new IllegalArgumentException("Bad pipe ID in advertisement");
                }
                catch (UnknownServiceException unknownServiceException) {
                    throw new IllegalArgumentException("Unusable ID in advertisement");
                }
            }
            if (string.equals(compTag)) {
                this.setCompat(textElement2);
                continue;
            }
            if (string.equals(codeTag)) {
                this.setCode(textElement2.getTextValue());
                continue;
            }
            if (string.equals(uriTag)) {
                this.setUri(textElement2.getTextValue());
                continue;
            }
            if (string.equals(provTag)) {
                this.setProvider(textElement2.getTextValue());
                continue;
            }
            if (string.equals(descTag)) {
                this.setDescription(textElement2.getTextValue());
                continue;
            }
            if (!string.equals(paramTag)) continue;
            this.setParam(textElement2);
        }
    }

    public Document getDocument(MimeMediaType mimeMediaType) {
        StructuredTextDocument structuredTextDocument = null;
        try {
            structuredTextDocument = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(mimeMediaType, ModuleImplAdvertisement.getAdvertisementType());
        }
        catch (Throwable throwable) {
            return null;
        }
        TextElement textElement = structuredTextDocument.createElement(msidTag, this.getModuleSpecID().toString());
        structuredTextDocument.appendChild((Element)textElement);
        if (this.getCompat() != null) {
            StructuredDocumentUtils.copyElements(structuredTextDocument, structuredTextDocument, this.getCompat());
        }
        if (this.getCode() != null) {
            textElement = structuredTextDocument.createElement(codeTag, this.getCode());
            structuredTextDocument.appendChild((Element)textElement);
        }
        if (this.getUri() != null) {
            textElement = structuredTextDocument.createElement(uriTag, this.getUri());
            structuredTextDocument.appendChild((Element)textElement);
        }
        if (this.getProvider() != null) {
            textElement = structuredTextDocument.createElement(provTag, this.getProvider());
            structuredTextDocument.appendChild((Element)textElement);
        }
        if (this.getDescription() != null) {
            textElement = structuredTextDocument.createElement(descTag, this.getDescription());
            structuredTextDocument.appendChild((Element)textElement);
        }
        if (this.getParam() != null) {
            StructuredDocumentUtils.copyElements(structuredTextDocument, structuredTextDocument, this.getParam());
        }
        return structuredTextDocument;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class Instantiator
    implements AdvertisementFactory.Instantiator {
        public String getAdvertisementType() {
            return ModuleImplAdvertisement.getAdvertisementType();
        }

        public Advertisement newInstance() {
            return new ModuleImplAdv();
        }

        public Advertisement newInstance(Element element) {
            return new ModuleImplAdv(element);
        }
    }
}

