/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.peergroup;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.CardLayout;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredDocumentUtils;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.TextElement;
import net.jxta.exception.JxtaError;
import net.jxta.impl.endpoint.tls.TlsConfig;
import net.jxta.impl.peergroup.BorderPanelGBL;
import net.jxta.impl.peergroup.PagesPanel;
import net.jxta.impl.peergroup.PanelGBL;
import net.jxta.impl.protocol.HTTPAdv;
import net.jxta.impl.protocol.TCPAdv;
import net.jxta.peergroup.PeerGroup;
import net.jxta.protocol.PeerAdvertisement;
import net.jxta.protocol.TransportAdvertisement;

public class ConfigDialog
extends Frame
implements ItemListener,
MouseListener {
    Frame mainFrame = this;
    PeerAdvertisement configAdv;
    HTTPAdv httpAdv;
    TCPAdv tcpAdv;
    GridBagConstraints stdConstr;
    GridBagConstraints centerConstr;
    GridBagConstraints centerLastConstr;
    GridBagConstraints fillConstr;
    GridBagConstraints leftLineConstr;
    GridBagConstraints midLineConstr;
    GridBagConstraints midLineEastConstr;
    GridBagConstraints rightLineConstr;
    GridBagConstraints leftPanelConstr;
    GridBagConstraints rightPanelConstr;
    Label helpLabel;
    IdPanel idPanel;
    HttpPanel httpPanel;
    TcpPanel tcpPanel;
    RdvPanel rdvPanel;
    RouterPanel routerPanel;
    DebugPanel debugPanel;
    SecPanel secPanel;
    Button ok;
    Button cancel;
    PagesPanel pages = new PagesPanel();
    boolean done = false;
    boolean canceled = false;

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.helpLabel.setForeground(Color.black);
        this.helpLabel.setText("See \"http://shell.jxta.org/index.html\" for config help");
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        boolean bl = this.tcpPanel.getState() && this.httpPanel.getState();
        this.routerPanel.remote.setEnabled(this.httpPanel.getState());
        this.rdvPanel.http.setEnabled(this.httpPanel.getState());
        this.rdvPanel.tcp.setEnabled(this.tcpPanel.getState());
        this.routerPanel.publicAddr.setEnabled(bl);
        if (this.httpPanel.getState()) {
            this.idPanel.proxyPanel.setEnabled(this.routerPanel.remote.getState());
        }
    }

    public ConfigDialog(PeerAdvertisement peerAdvertisement) {
        super("JXTA Configurator");
        Object object;
        Object object2;
        int n;
        Enumeration enumeration;
        Object object3;
        this.stdConstr = new GridBagConstraints();
        this.stdConstr.gridwidth = 0;
        this.stdConstr.gridheight = 1;
        this.stdConstr.gridx = 0;
        this.stdConstr.gridy = -1;
        this.stdConstr.fill = 0;
        this.stdConstr.weightx = 1.0;
        this.stdConstr.anchor = 18;
        this.stdConstr.insets = new Insets(0, 0, 0, 0);
        this.fillConstr = (GridBagConstraints)this.stdConstr.clone();
        this.fillConstr.fill = 2;
        this.centerConstr = (GridBagConstraints)this.stdConstr.clone();
        this.centerConstr.anchor = 11;
        this.centerLastConstr = (GridBagConstraints)this.centerConstr.clone();
        this.centerLastConstr.weighty = 1.0;
        this.midLineConstr = new GridBagConstraints();
        this.midLineConstr.gridwidth = 1;
        this.midLineConstr.gridheight = 1;
        this.midLineConstr.fill = 0;
        this.midLineConstr.anchor = 13;
        this.midLineConstr.weightx = 0.0;
        this.midLineEastConstr = (GridBagConstraints)this.midLineConstr.clone();
        this.midLineEastConstr.anchor = 13;
        this.midLineEastConstr.weightx = 1.0;
        this.rightLineConstr = (GridBagConstraints)this.midLineConstr.clone();
        this.rightLineConstr.gridwidth = 0;
        this.rightLineConstr.weightx = 1.0;
        this.rightLineConstr.anchor = 17;
        this.leftLineConstr = (GridBagConstraints)this.midLineConstr.clone();
        this.leftLineConstr.gridx = 0;
        this.leftLineConstr.weightx = 0.0;
        this.leftLineConstr.anchor = 17;
        this.leftLineConstr.insets = new Insets(0, 20, 0, 20);
        GridBagConstraints gridBagConstraints = (GridBagConstraints)this.fillConstr.clone();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.leftPanelConstr = (GridBagConstraints)this.fillConstr.clone();
        this.leftPanelConstr.gridwidth = 1;
        this.rightPanelConstr = (GridBagConstraints)this.fillConstr.clone();
        this.rightPanelConstr.gridwidth = 0;
        this.rightPanelConstr.gridx = -1;
        this.configAdv = peerAdvertisement;
        String string = this.configAdv.getDebugLevel();
        boolean bl = false;
        Vector<String> vector = new Vector<String>();
        try {
            TextElement textElement = (TextElement)((Object)this.configAdv.getServiceParam(PeerGroup.rendezvousClassID));
            if (textElement != null) {
                Enumeration enumeration2 = textElement.getChildren("Addr");
                while (enumeration2.hasMoreElements()) {
                    vector.addElement(((TextElement)enumeration2.nextElement()).getTextValue());
                }
                object3 = textElement.getChildren("Rdv");
                bl = object3.hasMoreElements() && "true".equals(((TextElement)object3.nextElement()).getTextValue());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        boolean bl2 = true;
        boolean bl3 = true;
        try {
            object3 = this.configAdv.getServiceParam(PeerGroup.httpProtoClassID);
            if (object3.getChildren("isOff").hasMoreElements()) {
                bl3 = false;
            }
            if ((enumeration = object3.getChildren(TransportAdvertisement.getAdvertisementType())).hasMoreElements()) {
                object3 = (Element)enumeration.nextElement();
            } else {
                enumeration = object3.getChildren(HTTPAdv.getAdvertisementType());
                if (enumeration.hasMoreElements()) {
                    object3 = (Element)enumeration.nextElement();
                }
            }
            this.httpAdv = (HTTPAdv)AdvertisementFactory.newAdvertisement((TextElement)object3);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException("Broken PeerAdvertisement. Cannot proceed.");
        }
        try {
            object3 = this.configAdv.getServiceParam(PeerGroup.tcpProtoClassID);
            if (object3.getChildren("isOff").hasMoreElements()) {
                bl2 = false;
            }
            if ((enumeration = object3.getChildren(TransportAdvertisement.getAdvertisementType())).hasMoreElements()) {
                object3 = (Element)enumeration.nextElement();
            } else {
                enumeration = object3.getChildren(TCPAdv.getAdvertisementType());
                if (enumeration.hasMoreElements()) {
                    object3 = (Element)enumeration.nextElement();
                }
            }
            this.tcpAdv = (TCPAdv)AdvertisementFactory.newAdvertisement((TextElement)object3);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException("Broken PeerAdvertisement. Cannot proceed.");
        }
        boolean bl4 = this.httpAdv.getServerEnabled();
        boolean bl5 = this.httpAdv.getProxyEnabled();
        boolean bl6 = this.httpAdv.getRouterEnabled();
        String string2 = this.httpAdv.getServer();
        String string3 = this.httpAdv.getProxy();
        Vector vector2 = this.httpAdv.getRouters();
        String string4 = this.httpAdv.getInterfaceAddress();
        String string5 = this.httpAdv.getConfigMode();
        String string6 = this.tcpAdv.getServer();
        String string7 = this.tcpAdv.getInterfaceAddress();
        String string8 = this.tcpAdv.getConfigMode();
        boolean bl7 = true;
        boolean bl8 = true;
        if (string5 != null && string5.equals("manual")) {
            bl7 = false;
        }
        if (string8 != null && string8.equals("manual")) {
            bl8 = false;
        }
        String string9 = "8080";
        String string10 = "9700";
        String string11 = this.httpAdv.getPort();
        String string12 = "9701";
        String string13 = this.tcpAdv.getPort();
        if (string3 != null) {
            n = string3.indexOf(":");
            string9 = string3.substring(n + 1);
            string3 = string3.substring(0, n);
        }
        if (string2 != null && (n = string2.indexOf(":")) != -1) {
            string10 = string2.substring(n + 1);
            string2 = string2.substring(0, n);
        } else {
            string2 = "";
            string10 = "9700";
        }
        if (string6 != null && (n = string6.indexOf(":")) != -1) {
            string12 = string6.substring(n + 1);
            string6 = string6.substring(0, n);
        } else {
            string6 = "";
            string12 = "9701";
        }
        if (string13 == null || string13.equals("")) {
            string13 = "9701";
        }
        if (string11 == null || string11.equals("")) {
            string11 = "9700";
        }
        String string14 = this.configAdv.getName();
        this.helpLabel = new Label("See \"http://shell.jxta.org/index.html\" for config help", 1);
        this.helpLabel.setBackground(new Color(220, 220, 220));
        this.helpLabel.setForeground(Color.black);
        this.idPanel = new IdPanel(string14, string3, string9, bl5);
        this.debugPanel = new DebugPanel(string);
        this.tcpPanel = new TcpPanel(this, string7, string13, string6, string12, bl2, bl8);
        this.httpPanel = new HttpPanel(this, string4, string11, bl3, bl7);
        this.routerPanel = new RouterPanel(this, "HTTP Relay Settings", string2, string10, bl4, bl6);
        this.secPanel = TlsConfig.willConfigureTls() ? new SecPanel(true) : new SecPanel(false);
        if (vector2 != null) {
            object2 = vector2.elements();
            while (object2.hasMoreElements()) {
                this.routerPanel.remote.addItem((String)object2.nextElement());
            }
        }
        this.rdvPanel = new RdvPanel("Rendezvous Settings", bl);
        if (vector != null) {
            object2 = vector.elements();
            while (object2.hasMoreElements()) {
                object = (String)object2.nextElement();
                if (((String)object).startsWith("tcp://")) {
                    this.rdvPanel.tcp.addItem(((String)object).substring(6));
                    continue;
                }
                if (!((String)object).startsWith("http://")) continue;
                this.rdvPanel.http.addItem(((String)object).substring(7));
            }
        }
        this.ok = new Button("  OK  ");
        this.cancel = new Button("Cancel");
        this.routerPanel.remote.setEnabled(this.httpPanel.getState());
        this.routerPanel.publicAddr.setEnabled(this.tcpPanel.getState() && this.httpPanel.getState());
        this.rdvPanel.http.setEnabled(this.httpPanel.getState());
        this.rdvPanel.tcp.setEnabled(this.tcpPanel.getState());
        object2 = new Panel();
        ((Container)object2).add(this.ok);
        ((Container)object2).add(this.cancel);
        object = this.pages.addPage("basic", "Basic settings");
        PanelGBL panelGBL = this.pages.addPage("advanced", "Experienced Users Only");
        PanelGBL panelGBL2 = this.pages.addPage("Rendezvous/Relays", "Experienced Users Only");
        PanelGBL panelGBL3 = this.pages.addPage("Security", "Security Settings");
        panelGBL.add((Component)this.debugPanel, gridBagConstraints);
        panelGBL.add((Component)this.tcpPanel, gridBagConstraints);
        panelGBL.add((Component)this.httpPanel, gridBagConstraints);
        panelGBL2.add((Component)this.rdvPanel, gridBagConstraints);
        panelGBL2.add((Component)this.routerPanel, gridBagConstraints);
        Button button = new Button("Download relay and rendezvous lists");
        panelGBL2.add((Component)button, gridBagConstraints);
        GridBagConstraints gridBagConstraints2 = (GridBagConstraints)this.centerConstr.clone();
        gridBagConstraints2.weighty = 1.0;
        ((Container)object).add((Component)this.idPanel, gridBagConstraints2);
        panelGBL3.add((Component)this.secPanel, gridBagConstraints2);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        this.add((Component)this.helpLabel, this.fillConstr);
        this.add((Component)this.pages, gridBagConstraints);
        this.add((Component)object2, this.centerLastConstr);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AutoLoader autoLoader = new AutoLoader(ConfigDialog.this.mainFrame, ConfigDialog.this.rdvPanel.tcp, ConfigDialog.this.rdvPanel.http, ConfigDialog.this.routerPanel.remote, "", "http://rdv.jxtahosts.net/cgi-bin/httpRdvsProd.cgi", "http://rdv.jxtahosts.net/cgi-bin/routersProd.cgi", false);
            }
        });
        this.ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConfigDialog.this.saveValues();
            }
        });
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConfigDialog.this.beCanceled();
            }
        });
        this.helpLabel.addMouseListener(this);
        this.pack();
        this.show();
    }

    public synchronized boolean untilDone() {
        try {
            while (!this.done) {
                this.wait();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.canceled) {
            throw new JxtaError("Canceled during configuration");
        }
        return this.done;
    }

    private synchronized void beDone() {
        this.done = true;
        this.notify();
        this.dispose();
    }

    private synchronized void beCanceled() {
        this.canceled = true;
        this.done = true;
        this.notify();
        this.dispose();
    }

    private boolean verifyPort(String string, String string2) {
        int n;
        try {
            n = Integer.parseInt(string2);
        }
        catch (Exception exception) {
            this.helpLabel.setForeground(Color.red.darker());
            this.helpLabel.setText(string + " port number must be an integer: " + string2);
            return false;
        }
        if (n > 65535 || n < 0) {
            this.helpLabel.setForeground(Color.red.darker());
            this.helpLabel.setText(string + " port number must be an integer between 0 and " + "65535 found " + n);
            return false;
        }
        return true;
    }

    private boolean loadBootStrapping(String string, HostListPanel hostListPanel) {
        if (string.equals("")) {
            return true;
        }
        this.helpLabel.setForeground(Color.black);
        this.helpLabel.setText("Trying " + string + "...");
        InputStream inputStream = null;
        try {
            String string2;
            inputStream = new URL(string).openStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            int n = 0;
            while ((string2 = bufferedReader.readLine()) != null) {
                if (!hostListPanel.addItem(string2)) continue;
                ++n;
            }
            if (n == 0) {
                this.helpLabel.setForeground(Color.red.darker());
                this.helpLabel.setText(string + ": not a valid list.");
                return false;
            }
        }
        catch (MalformedURLException malformedURLException) {
            this.helpLabel.setForeground(Color.red.darker());
            this.helpLabel.setText(string + ": malformed URL.");
            return false;
        }
        catch (IOException iOException) {
            this.helpLabel.setForeground(Color.red.darker());
            this.helpLabel.setText(string + ": not accessible. " + (this.idPanel.proxyPanel.getState() ? "" : "You might need a proxy."));
            return false;
        }
        try {
            inputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.helpLabel.setForeground(Color.black);
        this.helpLabel.setText("Done loading Boostrapping info");
        return true;
    }

    private boolean verifyInput() {
        int n;
        String[] stringArray;
        String[] stringArray2;
        if (this.idPanel.getName().equals("")) {
            this.helpLabel.setForeground(Color.red.darker());
            this.helpLabel.setText("A peer name is required.");
            return false;
        }
        if (!this.secPanel.getAlreadyInitialized()) {
            stringArray2 = this.secPanel.getPrincipal();
            stringArray = this.secPanel.getPasswd();
            String string = this.secPanel.getVerifyPasswd();
            if (stringArray2.length() == 0) {
                this.helpLabel.setForeground(Color.red.darker());
                this.helpLabel.setText("Please configure your secure username via the Security panel");
                this.secPanel.clearPrincipal();
                this.pages.showPage("Security");
                return false;
            }
            if (stringArray.length() < 8) {
                this.helpLabel.setForeground(Color.red.darker());
                this.helpLabel.setText("Password requires at least 8 letters");
                this.secPanel.clearPasswds();
                this.pages.showPage("Security");
                return false;
            }
            if (stringArray.compareTo(string) != 0) {
                this.helpLabel.setForeground(Color.red.darker());
                this.helpLabel.setText("Password does not match Verify Password");
                this.secPanel.clearPasswds();
                this.pages.showPage("Security");
                return false;
            }
        }
        if (!this.httpPanel.getState() && !this.tcpPanel.getState()) {
            this.helpLabel.setForeground(Color.red.darker());
            this.helpLabel.setText("At least one of TCP or HTTP must be enabled.");
            return false;
        }
        if (!(this.verifyPort("HTTP proxy", this.idPanel.proxyPanel.getPort()) && this.verifyPort("public router", this.routerPanel.publicAddr.getPort()) && this.verifyPort("TCP public", this.tcpPanel.getPublicPort()) && this.verifyPort("TCP local", this.tcpPanel.getLocalPort()) && this.verifyPort("HTTP local", this.httpPanel.getLocalPort()))) {
            return false;
        }
        if (!this.httpPanel.getState() || !this.routerPanel.remote.getState()) {
            return true;
        }
        stringArray2 = this.routerPanel.remote.getItems();
        stringArray = this.rdvPanel.http.getItems();
        int n2 = stringArray.length;
        while (n2-- > 0) {
            n = stringArray2.length;
            while (n-- > 0) {
                String string;
                String string2 = stringArray[n2].substring(0, stringArray[n2].indexOf(":"));
                if (!string2.equals(string = stringArray2[n].substring(0, stringArray2[n].indexOf(":")))) continue;
                return true;
            }
        }
        try {
            if (this.idPanel.proxyPanel.getState()) {
                System.setProperty("http.proxyHost", this.idPanel.proxyPanel.getHost());
                System.setProperty("http.proxyPort", this.idPanel.proxyPanel.getPort());
            }
        }
        catch (Exception exception) {
            this.helpLabel.setForeground(Color.red.darker());
            this.helpLabel.setText("Cannot turn-on proxying w/ JDK 1.1. you must edit your system properties.");
            return false;
        }
        if (!this.loadBootStrapping("http://rdv.jxtahosts.net/cgi-bin/httpRdvsProd.cgi", this.rdvPanel.http)) {
            return false;
        }
        if (!this.loadBootStrapping("http://rdv.jxtahosts.net/cgi-bin/routersProd.cgi", this.routerPanel.remote)) {
            return false;
        }
        if (!this.loadBootStrapping("", this.rdvPanel.tcp)) {
            return false;
        }
        stringArray2 = this.routerPanel.remote.getItems();
        stringArray = this.rdvPanel.http.getItems();
        n2 = stringArray.length;
        while (n2-- > 0) {
            n = stringArray2.length;
            while (n-- > 0) {
                if (!stringArray[n2].equals(stringArray2[n])) continue;
                return true;
            }
        }
        return false;
    }

    private void saveValues() {
        Object object;
        if (!this.verifyInput()) {
            return;
        }
        try {
            TextElement textElement;
            this.httpAdv.setInterfaceAddress(this.httpPanel.getInterfaceAddress());
            this.httpAdv.setPort(this.httpPanel.getLocalPort());
            this.httpAdv.setConfigMode(this.httpPanel.getConfigMode());
            if (this.idPanel.proxyPanel.getHost().equals("")) {
                this.httpAdv.setProxy(null);
            } else {
                this.httpAdv.setProxyEnabled(this.idPanel.proxyPanel.getState());
                this.httpAdv.setProxy(this.idPanel.proxyPanel.getHost() + ":" + this.idPanel.proxyPanel.getPort());
            }
            object = this.routerPanel.remote.getItems();
            if (((String[])object).length == 0) {
                this.httpAdv.setRouters(null);
            } else {
                Vector<String> vector = new Vector<String>();
                int n = ((String[])object).length;
                while (n-- > 0) {
                    vector.addElement(object[n]);
                }
                this.httpAdv.setRouters(vector);
            }
            this.httpAdv.setRouterEnabled(this.routerPanel.remote.getState());
            this.tcpAdv.setPort(this.tcpPanel.getLocalPort());
            this.tcpAdv.setInterfaceAddress(this.tcpPanel.getInterfaceAddress());
            if (this.tcpPanel.getPublicAddress().equals("")) {
                this.tcpAdv.setServer(null);
            } else {
                this.tcpAdv.setServer(this.tcpPanel.getPublicAddress() + ":" + this.tcpPanel.getPublicPort());
            }
            this.tcpAdv.setConfigMode(this.tcpPanel.getConfigMode());
            if (this.routerPanel.publicAddr.getHost().equals("")) {
                this.httpAdv.setServer(null);
            } else {
                this.httpAdv.setServerEnabled(this.httpPanel.getState() && this.tcpPanel.getState() && this.routerPanel.publicAddr.getState());
                this.httpAdv.setServer(this.routerPanel.publicAddr.getHost() + ":" + this.routerPanel.publicAddr.getPort());
            }
            this.configAdv.setName(this.idPanel.getName());
            if (!this.secPanel.getAlreadyInitialized()) {
                System.setProperty("net.jxta.tls.password", this.secPanel.getPasswd());
                System.setProperty("net.jxta.tls.principal", this.secPanel.getPrincipal());
            }
            StructuredTextDocument structuredTextDocument = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(new MimeMediaType("text", "xml"), "Parm");
            if (this.httpPanel.getState()) {
                String[] stringArray = this.rdvPanel.http.getItems();
                int n = stringArray.length;
                while (n-- > 0) {
                    textElement = structuredTextDocument.createElement("Addr", "http://" + stringArray[n]);
                    structuredTextDocument.appendChild((Element)textElement);
                }
            }
            String[] stringArray = this.rdvPanel.tcp.getItems();
            int n = stringArray.length;
            while (n-- > 0) {
                textElement = structuredTextDocument.createElement("Addr", "tcp://" + stringArray[n]);
                structuredTextDocument.appendChild((Element)textElement);
            }
            if (!this.httpPanel.getState()) {
                stringArray = this.rdvPanel.http.getItems();
                n = stringArray.length;
                while (n-- > 0) {
                    textElement = structuredTextDocument.createElement("Addr", "http://" + stringArray[n]);
                    structuredTextDocument.appendChild((Element)textElement);
                }
            }
            if (this.rdvPanel.isRdv.getState()) {
                textElement = structuredTextDocument.createElement("Rdv", "true");
                structuredTextDocument.appendChild((Element)textElement);
            }
            this.configAdv.putServiceParam(PeerGroup.rendezvousClassID, structuredTextDocument);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        try {
            object = (StructuredDocument)this.httpAdv.getDocument(new MimeMediaType("text", "xml"));
            this.configAdv.putServiceParam(PeerGroup.httpProtoClassID, this.wrapParm((StructuredDocument)object, this.httpPanel.getState()));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            object = (StructuredDocument)this.tcpAdv.getDocument(new MimeMediaType("text", "xml"));
            this.configAdv.putServiceParam(PeerGroup.tcpProtoClassID, this.wrapParm((StructuredDocument)object, this.tcpPanel.getState()));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.configAdv.setDebugLevel(this.debugPanel.getDebugLevel());
        this.beDone();
    }

    private StructuredDocument wrapParm(StructuredDocument structuredDocument, boolean bl) {
        try {
            StructuredTextDocument structuredTextDocument = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(new MimeMediaType("text", "xml"), "Parm");
            StructuredDocumentUtils.copyElements(structuredTextDocument, structuredTextDocument, structuredDocument);
            if (!bl) {
                structuredTextDocument.appendChild(structuredTextDocument.createElement("isOff"));
            }
            return structuredTextDocument;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    class RouterPanel
    extends BorderPanelGBL
    implements ItemListener {
        public HostPortPanel publicAddr;
        public HostListPanel remote;
        private ItemListener listener;

        public void itemStateChanged(ItemEvent itemEvent) {
            if (ConfigDialog.this.routerPanel.publicAddr.getState() && ConfigDialog.this.routerPanel.remote.getState()) {
                if (itemEvent.getSource() == ConfigDialog.this.routerPanel.remote.useMe) {
                    ConfigDialog.this.routerPanel.publicAddr.setState(false);
                } else {
                    ConfigDialog.this.routerPanel.remote.setState(false);
                }
            }
            this.listener.itemStateChanged(itemEvent);
        }

        public RouterPanel(ItemListener itemListener, String string, String string2, String string3, boolean bl, boolean bl2) {
            super(string);
            this.listener = itemListener;
            this.publicAddr = new HostPortPanel(this, "Act as a relay (Both TCP and HTTP must be enabled.)", "Public address (static NAT address)", string2, string3, bl);
            this.remote = new HostListPanel(this, "Use a relay (Required if behind firewall/NAT)", "Available relays", bl2);
            this.add((Component)this.publicAddr, ConfigDialog.this.stdConstr);
            this.add((Component)this.remote, ConfigDialog.this.stdConstr);
        }
    }

    class RdvPanel
    extends BorderPanelGBL {
        public Checkbox isRdv;
        public HostListPanel http;
        public HostListPanel tcp;

        RdvPanel(String string, boolean bl) {
            super(string);
            this.isRdv = new Checkbox("Act as a Rendezvous", null, bl);
            this.http = new HostListPanel("Available HTTP rendez-vous");
            this.tcp = new HostListPanel("Available TCP rendez-vous");
            this.add((Component)this.isRdv, ConfigDialog.this.stdConstr);
            this.add((Component)this.tcp, ConfigDialog.this.leftPanelConstr);
            this.add((Component)this.http, ConfigDialog.this.rightPanelConstr);
        }
    }

    class DebugPanel
    extends PanelGBL {
        private Choice debugLevel = new Choice();

        public String getDebugLevel() {
            return this.debugLevel.getSelectedItem();
        }

        public DebugPanel(String string) {
            this.debugLevel.addItem("error");
            this.debugLevel.addItem("warn");
            this.debugLevel.addItem("info");
            this.debugLevel.addItem("debug");
            this.debugLevel.addItem("user default");
            this.debugLevel.select(string);
            this.add((Component)new Label("Trace Level"), ConfigDialog.this.leftLineConstr);
            this.add((Component)this.debugLevel, ConfigDialog.this.rightLineConstr);
        }
    }

    class SecPanel
    extends PanelGBL
    implements ItemListener {
        private TextField principal;
        private TextField passwd;
        private TextField vpasswd;
        private Label principalLabel = new Label("Secure Username");
        private Label secLabel = new Label("Password");
        private Label vsecLabel = new Label("Verify Password");
        private Label init1 = new Label("Security parameters already initialized");
        private Label init2 = new Label("No further input is required");
        private Label please1 = new Label("Please note your secure username and password");
        private Label please2 = new Label("They will be required for all future access");
        private boolean passwordEntered = false;
        private boolean securityInitialized = false;

        public String getPrincipal() {
            return this.principal.getText();
        }

        public String getPasswd() {
            return this.passwd.getText();
        }

        public String getVerifyPasswd() {
            return this.vpasswd.getText();
        }

        public boolean getAlreadyInitialized() {
            return this.securityInitialized;
        }

        public void setState(boolean bl) {
            this.principalLabel.setEnabled(bl);
            this.passwd.setEnabled(bl);
            this.vpasswd.setEnabled(bl);
            this.secLabel.setEnabled(bl);
            this.vsecLabel.setEnabled(bl);
        }

        public void itemStateChanged(ItemEvent itemEvent) {
        }

        public SecPanel(boolean bl) {
            boolean bl2 = this.securityInitialized = !bl;
            if (bl) {
                this.principal = new TextField("", 20);
                this.passwd = new TextField("", 20);
                this.vpasswd = new TextField("", 20);
                this.passwd.setEchoChar('*');
                this.vpasswd.setEchoChar('*');
                this.add((Component)this.principalLabel, ConfigDialog.this.leftPanelConstr);
                this.add((Component)this.principal, ConfigDialog.this.rightPanelConstr);
                this.add((Component)this.secLabel, ConfigDialog.this.leftPanelConstr);
                this.add((Component)this.passwd, ConfigDialog.this.rightPanelConstr);
                this.add((Component)this.vsecLabel, ConfigDialog.this.leftPanelConstr);
                this.add((Component)this.vpasswd, ConfigDialog.this.rightPanelConstr);
                this.add((Component)this.please1, ConfigDialog.this.leftPanelConstr);
                this.add((Component)this.please2, ConfigDialog.this.leftPanelConstr);
                this.setState(true);
            } else {
                this.add((Component)this.init1, ConfigDialog.this.leftPanelConstr);
                this.add((Component)this.init2, ConfigDialog.this.leftPanelConstr);
            }
        }

        public void clearPasswds() {
            this.passwd.setText("");
            this.vpasswd.setText("");
        }

        public void clearPrincipal() {
            this.principal.setText("");
        }
    }

    class IdPanel
    extends PanelGBL
    implements ItemListener {
        private TextField peerName;
        public HostPortPanel proxyPanel;

        public String getName() {
            return this.peerName.getText();
        }

        public void setState(boolean bl) {
            ConfigDialog.this.httpPanel.useMe.setState(bl);
            this.proxyPanel.setEnabled(bl);
        }

        public boolean getState() {
            return ConfigDialog.this.httpPanel.useMe.getState();
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getSource() == ConfigDialog.this.httpPanel.useMe) {
                this.setState(ConfigDialog.this.httpPanel.useMe.getState());
                ConfigDialog.this.httpPanel.listener.itemStateChanged(itemEvent);
                return;
            }
        }

        public IdPanel(String string, String string2, String string3, boolean bl) {
            this.peerName = new TextField(string, 20);
            this.add((Component)new Label("Peer Name"), ConfigDialog.this.leftLineConstr);
            this.add((Component)this.peerName, ConfigDialog.this.midLineConstr);
            this.add((Component)new Label("(Mandatory)"), ConfigDialog.this.rightLineConstr);
            this.add((Component)new Label(""), ConfigDialog.this.leftLineConstr);
            this.proxyPanel = new HostPortPanel(this, "Use a proxy server if behind firewall)", "Proxy address", string2, string3, bl);
            this.add((Component)this.proxyPanel, ConfigDialog.this.fillConstr);
        }
    }

    class TcpPanel
    extends BorderPanelGBL
    implements ItemListener {
        public Checkbox useMe;
        private IfAddrPanel ifAddr;
        private TextField localPort;
        private HostPortPanel publicAddr;
        public ItemListener listener;

        public String getLocalPort() {
            return this.localPort.getText();
        }

        public String getPublicPort() {
            return this.publicAddr.getPort();
        }

        public void setState(boolean bl) {
            this.useMe.setState(bl);
            this.localPort.setEnabled(bl);
            this.ifAddr.setEnabled(bl);
            this.publicAddr.setEnabled(bl);
        }

        public boolean getState() {
            return this.useMe.getState();
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getSource() == this.useMe) {
                this.setState(this.useMe.getState());
                this.listener.itemStateChanged(itemEvent);
            }
        }

        public String getInterfaceAddress() {
            return this.ifAddr.getAddress();
        }

        public String getPublicAddress() {
            return this.publicAddr.getHost();
        }

        public String getConfigMode() {
            return this.ifAddr.getMode();
        }

        public TcpPanel(ItemListener itemListener, String string, String string2, String string3, String string4, boolean bl, boolean bl2) {
            super("TCP settings", "Enable if direct LAN connection.");
            this.listener = itemListener;
            this.ifAddr = new IfAddrPanel(string, bl2);
            this.useMe = new Checkbox("Enabled", null, bl);
            this.localPort = new TextField(string2, 8);
            this.publicAddr = new HostPortPanel(this, null, "(Optional) Public NAT address", string3, string4, true);
            this.add((Component)this.useMe, ConfigDialog.this.stdConstr);
            this.add((Component)this.ifAddr, ConfigDialog.this.midLineEastConstr);
            this.add((Component)this.localPort, ConfigDialog.this.midLineConstr);
            this.add((Component)this.publicAddr, ConfigDialog.this.stdConstr);
            this.setState(bl);
            this.useMe.addItemListener(this);
        }
    }

    class HttpPanel
    extends BorderPanelGBL
    implements ItemListener {
        public Checkbox useMe;
        private IfAddrPanel ifAddr;
        private TextField localPort;
        ItemListener listener;

        public String getLocalPort() {
            return this.localPort.getText();
        }

        public void setState(boolean bl) {
            this.useMe.setState(bl);
            this.ifAddr.setEnabled(bl);
        }

        public boolean getState() {
            return this.useMe.getState();
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getSource() == this.useMe) {
                this.setState(this.useMe.getState());
                this.listener.itemStateChanged(itemEvent);
                return;
            }
        }

        public String getInterfaceAddress() {
            return this.ifAddr.getAddress();
        }

        public String getConfigMode() {
            return this.ifAddr.getMode();
        }

        public HttpPanel(ItemListener itemListener, String string, String string2, boolean bl, boolean bl2) {
            super("HTTP settings", "Must enable if behind a firewall/NAT");
            this.listener = itemListener;
            this.useMe = new Checkbox("Enabled", null, bl);
            this.ifAddr = new IfAddrPanel(string, bl2);
            this.localPort = new TextField(string2, 8);
            this.add((Component)this.useMe, ConfigDialog.this.stdConstr);
            this.add((Component)this.ifAddr, ConfigDialog.this.midLineEastConstr);
            this.add((Component)this.localPort, ConfigDialog.this.midLineConstr);
            this.setState(bl);
            this.useMe.addItemListener(this);
        }
    }

    class IfAddrPanel
    extends Panel
    implements ItemListener {
        private Choice ips = new Choice();
        private Checkbox manual;
        private Checkbox alwaysManual;
        private TextField interfaceAddr;
        private Panel addrPanel;
        private CardLayout addrLayout;

        private void setManual(boolean bl) {
            if (bl) {
                this.addrLayout.show(this.addrPanel, "man");
            } else {
                this.addrLayout.show(this.addrPanel, "auto");
            }
            this.validate();
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getSource() == this.manual) {
                this.setManual(this.manual.getState());
            }
        }

        public String getAddress() {
            if (this.manual.getState()) {
                return this.interfaceAddr.getText();
            }
            return this.ips.getSelectedItem();
        }

        public String getMode() {
            if (this.manual.getState()) {
                if (this.alwaysManual.getState()) {
                    return "alwaysManual";
                }
                return "manual";
            }
            return "auto";
        }

        public IfAddrPanel(String string, boolean bl) {
            Object object;
            Object object2;
            this.interfaceAddr = new TextField(string, 20);
            boolean bl2 = false;
            try {
                object2 = InetAddress.getLocalHost().getHostAddress();
                object = InetAddress.getAllByName((String)object2);
                int n = ((InetAddress[])object).length;
                while (n-- > 0) {
                    this.ips.addItem(object[n].getHostAddress());
                }
                if (((InetAddress[])object).length == 0 || string != null && !string.equals("")) {
                    bl2 = true;
                    n = ((InetAddress[])object).length;
                    while (n-- > 0) {
                        if (!string.equals(object[n].getHostAddress())) continue;
                        bl2 = false;
                        this.ips.select(string);
                    }
                }
            }
            catch (Exception exception) {
                bl2 = true;
            }
            this.manual = new Checkbox("Manual ", null, bl2);
            object2 = new Panel(new FlowLayout(2));
            ((Container)object2).add(this.ips);
            this.alwaysManual = new Checkbox("Always manual", null, bl);
            object = new PanelGBL();
            ((Container)object).add((Component)this.alwaysManual, ConfigDialog.this.leftLineConstr);
            ((Container)object).add((Component)this.interfaceAddr, ConfigDialog.this.midLineEastConstr);
            this.addrLayout = new CardLayout();
            this.addrPanel = new Panel(this.addrLayout);
            this.addrPanel.add((Component)object, "man");
            this.addrPanel.add((Component)object2, "auto");
            this.add(this.manual);
            this.add(this.addrPanel);
            this.setManual(bl2);
            this.manual.addItemListener(this);
        }
    }

    class HostListPanel
    extends PanelGBL
    implements ActionListener,
    ItemListener {
        public Checkbox useMe;
        private TextField host;
        private TextField port;
        private Button insert;
        private Button remove;
        private List list;
        private Label listLabel;
        private ItemListener listener;

        public void setState(boolean bl) {
            if (this.useMe != null) {
                this.useMe.setState(bl);
            }
            this.list.setEnabled(bl);
            this.host.setEnabled(bl);
            this.port.setEnabled(bl);
            this.insert.setEnabled(bl);
            this.remove.setEnabled(bl);
            this.listLabel.setEnabled(bl);
        }

        public boolean getState() {
            return this.useMe.getState();
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getSource() == this.useMe) {
                if (this.useMe != null) {
                    this.setState(this.useMe.getState());
                }
                this.listener.itemStateChanged(itemEvent);
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this.insert) {
                if (this.addItem(this.host.getText() + ":" + this.port.getText())) {
                    this.host.setText("");
                    this.port.setText("");
                }
                return;
            }
            if (actionEvent.getSource() == this.remove) {
                int[] nArray = this.list.getSelectedIndexes();
                int n = nArray.length;
                while (n-- > 0) {
                    this.list.remove(nArray[n]);
                }
                return;
            }
        }

        public HostListPanel(String string) {
            this(null, null, string, true);
        }

        public HostListPanel(ItemListener itemListener, String string, String string2, boolean bl) {
            this.listener = itemListener;
            this.host = new TextField("", 16);
            this.port = new TextField("", 4);
            this.insert = new Button(" + ");
            this.remove = new Button(" - ");
            this.list = new List(3, true);
            this.listLabel = new Label(string2);
            PanelGBL panelGBL = new PanelGBL();
            PanelGBL panelGBL2 = new PanelGBL();
            GridBagConstraints gridBagConstraints = (GridBagConstraints)ConfigDialog.this.leftLineConstr.clone();
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            panelGBL.add((Component)this.host, gridBagConstraints);
            panelGBL.add((Component)this.port, ConfigDialog.this.rightLineConstr);
            panelGBL.add((Component)this.list, ConfigDialog.this.fillConstr);
            panelGBL2.add((Component)this.insert, ConfigDialog.this.fillConstr);
            panelGBL2.add((Component)this.remove, ConfigDialog.this.fillConstr);
            GridBagConstraints gridBagConstraints2 = (GridBagConstraints)ConfigDialog.this.rightLineConstr.clone();
            gridBagConstraints2.anchor = 18;
            gridBagConstraints2.insets = new Insets(4, 2, 2, 8);
            if (this.listener != null && string != null) {
                this.useMe = new Checkbox(string, null, bl);
                this.add((Component)this.useMe, ConfigDialog.this.stdConstr);
                this.useMe.addItemListener(this);
            }
            this.add((Component)this.listLabel, ConfigDialog.this.stdConstr);
            this.add((Component)panelGBL, gridBagConstraints);
            this.add((Component)panelGBL2, gridBagConstraints2);
            this.setState(bl);
            this.insert.addActionListener(this);
            this.remove.addActionListener(this);
        }

        public boolean addItem(String string) {
            int n = string.indexOf(58);
            if (n == -1) {
                return false;
            }
            try {
                String string2 = string.substring(0, n);
                String string3 = string.substring(n + 1);
                int n2 = Integer.parseInt(string3);
                if (n2 < 0 || n2 > 65535) {
                    return false;
                }
                this.list.add(string2.trim() + ":" + n2);
            }
            catch (Exception exception) {
                return false;
            }
            return true;
        }

        public String[] getItems() {
            return this.list.getItems();
        }
    }

    class AutoLoader
    extends Dialog
    implements ActionListener,
    MouseListener {
        HostListPanel list1;
        HostListPanel list2;
        HostListPanel list3;
        Button load;
        Button quit;
        TextField urlField1;
        TextField urlField2;
        TextField urlField3;
        Label helpLabel;
        boolean once;
        String helpText = "Edit the urls below and click \"Load\". Blank those you do not want to load. Repeat if needed.";

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            this.helpLabel.setForeground(Color.black);
            this.helpLabel.setText(this.helpText);
        }

        private boolean loadList(TextField textField, HostListPanel hostListPanel) {
            String string = textField.getText();
            if (string.equals("")) {
                return true;
            }
            this.helpLabel.setForeground(Color.black);
            this.helpLabel.setText("Trying " + string + "...");
            InputStream inputStream = null;
            try {
                String string2;
                inputStream = new URL(string).openStream();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                int n = 0;
                while ((string2 = bufferedReader.readLine()) != null) {
                    if (!hostListPanel.addItem(string2)) continue;
                    ++n;
                }
                if (n == 0) {
                    this.helpLabel.setForeground(Color.red.darker());
                    this.helpLabel.setText(string + ": not a valid list.");
                    return false;
                }
            }
            catch (MalformedURLException malformedURLException) {
                this.helpLabel.setForeground(Color.red.darker());
                this.helpLabel.setText(string + ": malformed URL.");
                return false;
            }
            catch (IOException iOException) {
                this.helpLabel.setForeground(Color.red.darker());
                this.helpLabel.setText(string + ": not accessible. " + (ConfigDialog.this.idPanel.proxyPanel.getState() ? "" : "You might need a proxy."));
                return false;
            }
            try {
                inputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.helpLabel.setForeground(Color.black);
            this.helpLabel.setText(this.helpText);
            return true;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this.quit) {
                this.dispose();
                return;
            }
            try {
                if (ConfigDialog.this.idPanel.proxyPanel.getState()) {
                    System.setProperty("http.proxyHost", ConfigDialog.this.idPanel.proxyPanel.getHost());
                    System.setProperty("http.proxyPort", ConfigDialog.this.idPanel.proxyPanel.getPort());
                }
            }
            catch (Exception exception) {
                this.helpLabel.setForeground(Color.red.darker());
                this.helpLabel.setText("Cannot turn-on proxying w/ JDK 1.1. you must edit your system properties.");
            }
            if (this.loadList(this.urlField1, this.list1) && this.loadList(this.urlField2, this.list2) && this.loadList(this.urlField3, this.list3) && this.once) {
                this.dispose();
            }
        }

        public AutoLoader(Frame frame, HostListPanel hostListPanel, HostListPanel hostListPanel2, HostListPanel hostListPanel3, String string, String string2, String string3, boolean bl) {
            super(frame, "Load list from URL", true);
            this.once = bl;
            if (bl) {
                this.helpText = "Edit the urls below and click \"Done\". Blank those you do not want to load.";
            }
            this.setLayout(new BorderLayout());
            Panel panel = new Panel(this, new GridLayout(0, 1, 0, 0)){
                private final /* synthetic */ AutoLoader this$1;
                {
                    this.this$1 = autoLoader;
                }

                public Insets getInsets() {
                    return new Insets(0, 5, 0, 5);
                }
            };
            this.list1 = hostListPanel;
            this.list2 = hostListPanel2;
            this.list3 = hostListPanel3;
            this.urlField1 = new TextField(string, 50);
            this.urlField2 = new TextField(string2, 50);
            this.urlField3 = new TextField(string3, 50);
            this.helpLabel = new Label(this.helpText, 1);
            this.helpLabel.setBackground(new Color(220, 220, 220));
            this.helpLabel.setForeground(Color.black);
            this.load = new Button(bl ? " Done " : " Load ");
            this.quit = new Button(bl ? " Cancel " : " Dismiss ");
            Panel panel2 = new Panel();
            panel2.add(this.load);
            panel2.add(this.quit);
            Panel panel3 = new Panel(new FlowLayout(2));
            Panel panel4 = new Panel(new FlowLayout(2));
            Panel panel5 = new Panel(new FlowLayout(2));
            panel3.add(new Label("Tcp rendez-vous list:"));
            panel4.add(new Label("Http rendez-vous list:"));
            panel5.add(new Label("HTTP relays list:"));
            panel3.add(this.urlField1);
            panel4.add(this.urlField2);
            panel5.add(this.urlField3);
            this.add((Component)this.helpLabel, "North");
            panel.add(new Label("See also: http://platform.jxta.org/java/rendezvous.html"));
            panel.add(panel3);
            panel.add(panel4);
            panel.add(panel5);
            this.add((Component)panel, "Center");
            this.add((Component)panel2, "South");
            this.helpLabel.addMouseListener(this);
            this.load.addActionListener(this);
            this.quit.addActionListener(this);
            this.pack();
            this.show();
        }
    }

    class HostPortPanel
    extends PanelGBL
    implements ItemListener {
        public Checkbox useMe;
        private TextField host;
        private TextField port;
        Label addressLabel;
        ItemListener listener;

        public String getHost() {
            return this.host.getText();
        }

        public String getPort() {
            return this.port.getText();
        }

        public void setState(boolean bl) {
            this.useMe.setState(bl);
            this.host.setEnabled(bl);
            this.port.setEnabled(bl);
            this.addressLabel.setEnabled(bl);
        }

        public boolean getState() {
            return this.useMe.getState();
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            this.setState(this.useMe.getState());
            this.listener.itemStateChanged(itemEvent);
        }

        public void setEnabled(boolean bl) {
            super.setEnabled(bl);
        }

        HostPortPanel(ItemListener itemListener, String string, String string2, String string3, String string4, boolean bl) {
            if (string == null) {
                string = "";
            }
            this.listener = itemListener;
            this.useMe = new Checkbox(string, null, bl);
            this.host = new TextField(string3, 20);
            this.port = new TextField(string4, 8);
            this.addressLabel = new Label(string2);
            if (!string.equals("")) {
                this.add((Component)this.useMe, ConfigDialog.this.stdConstr);
            }
            this.add((Component)this.addressLabel, ConfigDialog.this.leftLineConstr);
            this.add((Component)this.host, ConfigDialog.this.midLineConstr);
            this.add((Component)this.port, ConfigDialog.this.rightLineConstr);
            this.setState(bl);
            this.useMe.addItemListener(this);
        }
    }
}

