/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.peergroup;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.Insets;
import net.jxta.impl.peergroup.PanelGBL;

class BorderPanelGBL
extends PanelGBL {
    public static final int NONE = 0;
    public static final int RAISED = 1;
    public static final int LOWERED = 2;
    public static final int GROOVE = 3;
    public static final int BUMP = 4;
    int style = 3;
    String title;
    int ascent = 0;
    int descent = 0;
    int leading = 0;
    int titleWidth = 0;
    GridBagLayout lay = new GridBagLayout();

    public BorderPanelGBL(String string) {
        this.title = string;
    }

    public BorderPanelGBL(String string, String string2) {
        super(string2);
        this.title = string;
    }

    public BorderPanelGBL(String string, String string2, int n) {
        super(string2);
        this.title = string;
        if (n < 0 && n > 4) {
            return;
        }
        if (n == 1 || n == 2) {
            this.title = null;
        }
        this.style = n;
    }

    private void checkMetrics() {
        Font font = this.getFont();
        if (this.title == null || font == null) {
            this.ascent = 2;
        } else {
            FontMetrics fontMetrics = this.getFontMetrics(font);
            this.ascent = fontMetrics.getAscent();
            this.descent = fontMetrics.getDescent();
            this.leading = fontMetrics.getLeading();
            this.titleWidth = fontMetrics.stringWidth(this.title);
        }
        this.insets = new Insets(this.descent + this.ascent + this.leading + 2, 7, 7, 7);
    }

    public Insets getInsets() {
        this.checkMetrics();
        return this.insets;
    }

    private void paintLowered(Graphics graphics) {
        this.checkMetrics();
        if (this.ascent == 0) {
            return;
        }
        Dimension dimension = this.getSize();
        graphics.setColor(Color.black);
        graphics.drawRect(1, this.ascent - 2, dimension.width - 4, dimension.height - this.ascent);
        graphics.setColor(Color.white);
        graphics.drawRect(2, this.ascent - 1, dimension.width - 4, dimension.height - this.ascent);
        graphics.setColor(this.getBackground());
        graphics.drawRect(2, this.ascent - 1, dimension.width - 5, dimension.height - this.ascent - 1);
    }

    private void paintRaised(Graphics graphics) {
        this.checkMetrics();
        if (this.ascent == 0) {
            return;
        }
        Dimension dimension = this.getSize();
        graphics.setColor(Color.white);
        graphics.drawRect(1, this.ascent - 2, dimension.width - 4, dimension.height - this.ascent);
        graphics.setColor(Color.black);
        graphics.drawRect(2, this.ascent - 1, dimension.width - 4, dimension.height - this.ascent);
        graphics.setColor(this.getBackground());
        graphics.drawRect(2, this.ascent - 1, dimension.width - 5, dimension.height - this.ascent - 1);
    }

    private void paintGroove(Graphics graphics) {
        this.checkMetrics();
        if (this.ascent == 0) {
            return;
        }
        Dimension dimension = this.getSize();
        graphics.setColor(Color.black);
        graphics.drawRect(1, this.ascent - 2, dimension.width - 4, dimension.height - this.ascent);
        graphics.setColor(Color.white);
        graphics.drawRect(2, this.ascent - 1, dimension.width - 4, dimension.height - this.ascent);
        graphics.setColor(Color.black);
        graphics.clearRect(10, 0, this.titleWidth + 6, this.descent + this.ascent + this.leading + 1);
        graphics.drawString(this.title, 12, this.ascent + 1);
        graphics.setColor(Color.white);
        graphics.drawString(this.title, 13, this.ascent + 2);
        graphics.clearRect(0, 0, dimension.width, 1);
    }

    private void paintBump(Graphics graphics) {
        this.checkMetrics();
        if (this.ascent == 0) {
            return;
        }
        Dimension dimension = this.getSize();
        graphics.setColor(Color.white);
        graphics.drawRect(1, this.ascent - 2, dimension.width - 4, dimension.height - this.ascent);
        graphics.setColor(Color.black);
        graphics.drawRect(2, this.ascent - 1, dimension.width - 4, dimension.height - this.ascent);
        graphics.setColor(Color.white);
        graphics.clearRect(10, 0, this.titleWidth + 6, this.descent + this.ascent + this.leading + 1);
        graphics.drawString(this.title, 12, this.ascent + 1);
        graphics.setColor(Color.black);
        graphics.drawString(this.title, 13, this.ascent + 2);
        graphics.clearRect(0, 0, dimension.width, 1);
    }

    public void paint(Graphics graphics) {
        switch (this.style) {
            case 3: {
                this.paintGroove(graphics);
                break;
            }
            case 4: {
                this.paintBump(graphics);
                break;
            }
            case 1: {
                this.paintRaised(graphics);
                break;
            }
            case 2: {
                this.paintLowered(graphics);
            }
        }
        super.paint(graphics);
    }
}

