/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.index.xpath;

import java.util.Enumeration;
import java.util.Vector;

public class Expression {
    static final int LEFT_PAREN = 40;
    static final int RIGHT_PAREN = 41;
    static final int AT = 41;
    static final int EQUALS = 41;
    static final int QUOTED = 34;
    static final int IDENTIFIER = 128;
    static final int BINARY_OPERATOR = 129;
    static final int EOF = -1;
    static final int EXPRESSION = 64;
    static final int BINARY_EXPRESSION = 65;
    static final boolean DEBUG = false;
    int i = 0;
    char[] chars;
    String tokenValue;
    Node stackTop;
    int parens;
    LogicalExpression cnf;

    Expression(String string) {
        this.chars = string.toCharArray();
        Node node = this.parse();
        if (node instanceof BinaryExpression) {
            Clause clause = ((BinaryExpression)node).toClause();
            this.cnf = Expression.toCNF(clause);
        } else {
            this.cnf = new Literal(node.val);
        }
    }

    public static void main(String[] stringArray) {
        Expression expression = new Expression(stringArray[0]);
    }

    static Clause toCNF(Clause clause) {
        while (clause.getLayerCount() > 2 || clause.getLayerCount() == 2 && !clause.oper.equals("and")) {
            Expression.debug("Starting:" + clause);
            clause = clause.distribute("and");
            Expression.debug("Canonical: " + clause);
        }
        if (clause.getLayerCount() == 1) {
            if (clause.oper.equals("and")) {
                Enumeration enumeration = clause.getSubexpressions();
                clause = new Clause("and");
                while (enumeration.hasMoreElements()) {
                    clause.addSubexpression(new Clause("or").addLiteral((Literal)enumeration.nextElement()));
                }
            } else if (clause.oper.equals("or")) {
                clause = new Clause("and").addSubexpression(clause);
            }
        }
        return clause;
    }

    static void debug(String string) {
    }

    LogicalExpression getRootClause() {
        return this.cnf;
    }

    boolean isIdentifierPart(char c) {
        return " \t\r\n()".indexOf(c) == -1;
    }

    boolean isQuoteEscape(char c) {
        return c == '\\';
    }

    boolean isQuote(char c) {
        return c == '\'' || c == '\"';
    }

    void push(Node node) {
        if (this.stackTop == null) {
            this.stackTop = node;
        } else {
            node.next = this.stackTop;
            this.stackTop = node;
        }
    }

    Node pop() {
        Node node = this.stackTop;
        this.stackTop = this.stackTop.next;
        node.next = null;
        return node;
    }

    boolean canReduceParenthesizedExpression() {
        boolean bl;
        boolean bl2 = bl = this.stackTop != null && this.stackTop.next != null && this.stackTop.type == 64 && this.stackTop.next.type == 40;
        if (!bl) {
            Expression.debug("Cannot reduce by parenthesized expr: " + this.stackTop.type + " " + this.stackTop.next.type + ", " + 64 + " " + 40);
        }
        return bl;
    }

    boolean canReduceBinaryExpression() {
        return this.stackTop != null && this.stackTop.next != null && this.stackTop.next.next != null && this.stackTop.type == 64 && this.stackTop.next.type == 129 && this.stackTop.next.next.type == 64;
    }

    Node reduceParenthesizedExpression() {
        Node node = this.pop();
        Node node2 = this.pop();
        return node;
    }

    BinaryExpression reduceBinaryExpression(boolean bl) {
        Node node = this.pop();
        Node node2 = this.pop();
        Node node3 = this.pop();
        if (bl) {
            this.pop();
        }
        return new BinaryExpression(node3, node2, node);
    }

    void printStack() {
        Expression.debug("Stack:");
        Node node = this.stackTop;
        while (node != null) {
            Expression.debug(node.toString());
            node = node.next;
        }
    }

    Node parse() {
        int n;
        int n2 = 0;
        while ((n = this.lex()) != -1) {
            Expression.debug("Token " + n + " value = " + this.tokenValue);
            switch (n) {
                case 40: {
                    this.push(new Node(40, "("));
                    break;
                }
                case 41: {
                    if (this.canReduceBinaryExpression()) {
                        this.push(this.reduceBinaryExpression(true));
                        break;
                    }
                    if (this.canReduceParenthesizedExpression()) {
                        this.push(this.reduceParenthesizedExpression());
                        break;
                    }
                    throw new IllegalStateException("Misplaced )");
                }
                case 129: {
                    if (this.stackTop.type != 64) {
                        throw new IllegalStateException("Expression expected before " + this.tokenValue);
                    }
                    if (this.canReduceBinaryExpression()) {
                        Expression.debug("Reduction 2");
                        this.push(this.reduceBinaryExpression(false));
                    }
                    this.push(new Node(129, this.tokenValue));
                    n2 = 65;
                    break;
                }
                case 128: {
                    this.push(new Node(64, this.tokenValue));
                    if (n2 == 65) break;
                    n2 = 64;
                }
            }
            this.printStack();
        }
        if (this.canReduceBinaryExpression()) {
            Expression.debug("Reduced!");
            this.push(this.reduceBinaryExpression(false));
        } else {
            Expression.debug("Didn't reduce!");
        }
        this.printStack();
        if (this.stackTop != null && this.stackTop.next != null) {
            throw new IllegalStateException("Invalid expression.");
        }
        return this.stackTop;
    }

    int lex() {
        while (this.i < this.chars.length) {
            this.tokenValue = "" + this.chars[this.i];
            switch (this.chars[this.i]) {
                case '(': {
                    ++this.parens;
                    ++this.i;
                    return 40;
                }
                case ')': {
                    if (--this.parens < 0) {
                        throw new IllegalStateException("Unexpected )");
                    }
                    ++this.i;
                    return 41;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    break;
                }
                default: {
                    int n;
                    this.i = n = this.i;
                    while (this.i < this.chars.length && this.isIdentifierPart(this.chars[this.i])) {
                        ++this.i;
                    }
                    this.tokenValue = new String(this.chars, n, this.i - n);
                    if (this.tokenValue.equalsIgnoreCase("and") || this.tokenValue.equalsIgnoreCase("or")) {
                        return 129;
                    }
                    return 128;
                }
            }
            ++this.i;
        }
        if (this.parens > 0) {
            throw new IllegalStateException("Some parens aren't closed.");
        }
        return -1;
    }

    public static interface LogicalExpression {
        public Clause distribute(LogicalExpression var1, String var2);

        public int getLayerCount();

        public String toString(String var1);
    }

    class BinaryExpression
    extends Node {
        Node expr1;
        Node oper;
        Node expr2;

        BinaryExpression(Node node, Node node2, Node node3) {
            super(64, null);
            this.expr1 = node;
            this.oper = node2;
            this.expr2 = node3;
        }

        public String toString() {
            return "(" + this.expr1.toString() + " " + this.oper.toString() + " " + this.expr2.toString() + ")";
        }

        Clause toClause() {
            Clause clause = new Clause(this.oper.val);
            if (this.expr1 instanceof BinaryExpression) {
                clause.addSubexpression(((BinaryExpression)this.expr1).toClause());
            } else if (this.expr1 instanceof Node) {
                clause.addLiteral(new Literal(this.expr1.val));
            }
            if (this.expr2 instanceof BinaryExpression) {
                clause.addSubexpression(((BinaryExpression)this.expr2).toClause());
            } else if (this.expr1 instanceof Node) {
                clause.addLiteral(new Literal(this.expr2.val));
            }
            return clause;
        }
    }

    class Node {
        int type;
        String val;
        Node next;

        Node(int n, String string) {
            this.type = n;
            this.val = string;
        }

        public String toString() {
            return this.val + ":" + this.type;
        }
    }

    public static class Clause
    implements LogicalExpression {
        String oper;
        Vector exprs;
        boolean allLiterals;

        public Clause(String string) {
            this.oper = string;
            this.exprs = new Vector();
            this.allLiterals = true;
        }

        public int getLayerCount() {
            int n = 0;
            Enumeration enumeration = this.getSubexpressions();
            while (enumeration.hasMoreElements()) {
                LogicalExpression logicalExpression = (LogicalExpression)enumeration.nextElement();
                n = Math.max(n, logicalExpression.getLayerCount());
            }
            return n + 1;
        }

        public Enumeration getSubexpressions() {
            return this.exprs.elements();
        }

        public Clause addSubexpression(LogicalExpression logicalExpression) {
            if (logicalExpression instanceof Literal) {
                return this.addLiteral((Literal)logicalExpression);
            }
            return this.addSubexpression((Clause)logicalExpression);
        }

        public Clause distribute(LogicalExpression logicalExpression, String string) {
            Expression.debug("Distributing " + logicalExpression + " under " + string + " into " + this);
            if (this.oper.equals(string)) {
                if (logicalExpression instanceof Literal) {
                    this.addLiteral((Literal)logicalExpression);
                } else if (logicalExpression instanceof Clause) {
                    this.addSubexpression((Clause)logicalExpression);
                }
                return this;
            }
            Clause clause = new Clause(this.oper);
            Enumeration enumeration = this.getSubexpressions();
            while (enumeration.hasMoreElements()) {
                LogicalExpression logicalExpression2 = (LogicalExpression)enumeration.nextElement();
                clause.addSubexpression(logicalExpression2.distribute(logicalExpression, string));
            }
            Expression.debug("Distributing returning " + clause);
            return clause;
        }

        public String toString() {
            return this.toString("");
        }

        public String toString(String string) {
            StringBuffer stringBuffer = new StringBuffer(string + "(" + this.oper + "\n");
            Enumeration enumeration = this.getSubexpressions();
            while (enumeration.hasMoreElements()) {
                stringBuffer.append(((LogicalExpression)enumeration.nextElement()).toString(string + "    "));
                if (!enumeration.hasMoreElements()) continue;
                stringBuffer.append("\n");
            }
            stringBuffer.append(")");
            return stringBuffer.toString();
        }

        Clause addLiteral(Literal literal) {
            this.exprs.addElement(literal);
            return this;
        }

        Clause addSubexpression(Clause clause) {
            if (this.oper.equals(clause.oper)) {
                Enumeration enumeration = clause.getSubexpressions();
                while (enumeration.hasMoreElements()) {
                    Object e = enumeration.nextElement();
                    if (e instanceof Literal) {
                        this.addLiteral((Literal)e);
                        continue;
                    }
                    if (!(e instanceof Clause)) continue;
                    this.addSubexpression((Clause)e);
                }
            } else {
                this.allLiterals = false;
                this.exprs.addElement(clause);
            }
            return this;
        }

        Clause distribute(String string) {
            Object object;
            Expression.debug("Distributing " + this + " under " + string);
            if (this.allLiterals) {
                Expression.debug("" + this + " is all literals.");
                return this;
            }
            Clause clause = new Clause(this.oper);
            Expression.debug("Still here for for " + this);
            Enumeration enumeration = this.getSubexpressions();
            while (enumeration.hasMoreElements()) {
                object = enumeration.nextElement();
                if (object instanceof Clause) {
                    clause.addSubexpression(((Clause)object).distribute(string));
                    continue;
                }
                clause.addLiteral((Literal)object);
            }
            Expression.debug("After unrolling: " + clause);
            if (!this.oper.equals(string)) {
                enumeration = clause.getSubexpressions();
                object = (LogicalExpression)enumeration.nextElement();
                LogicalExpression logicalExpression = null;
                clause = new Clause(this.oper);
                if (object instanceof Literal) {
                    while (enumeration.hasMoreElements()) {
                        logicalExpression = (LogicalExpression)enumeration.nextElement();
                        if (!(logicalExpression instanceof Literal)) break;
                        clause.addLiteral((Literal)logicalExpression);
                    }
                    if (logicalExpression instanceof Literal) {
                        logicalExpression = null;
                    }
                } else {
                    logicalExpression = (LogicalExpression)enumeration.nextElement();
                }
                Expression.debug("s1 = " + object + ", s2 = " + logicalExpression);
                clause.addSubexpression(object.distribute(logicalExpression, this.oper));
                while (enumeration.hasMoreElements()) {
                    Object e = enumeration.nextElement();
                    if (e instanceof Literal) {
                        clause.addLiteral((Literal)e);
                        continue;
                    }
                    clause.addSubexpression((Clause)e);
                }
                if (clause.exprs.size() == 1) {
                    return (Clause)clause.exprs.elementAt(0);
                }
                clause = clause.distribute(string);
            }
            Expression.debug("Distributed " + this + " into " + clause);
            return clause;
        }
    }

    public static class Literal
    implements LogicalExpression {
        Object name;

        public Literal(Object object) {
            this.name = object;
        }

        public Object getName() {
            return this.name;
        }

        public int getLayerCount() {
            return 0;
        }

        public Clause distribute(LogicalExpression logicalExpression, String string) {
            Expression.debug("Distribute " + logicalExpression + " into " + this + " under " + string);
            if (logicalExpression instanceof Literal) {
                Clause clause = new Clause(string);
                clause.addLiteral(this);
                clause.addLiteral((Literal)logicalExpression);
                return clause;
            }
            return logicalExpression.distribute(this, string);
        }

        public String toString() {
            return this.toString("");
        }

        public String toString(String string) {
            return string + this.name.toString();
        }
    }
}

