/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.index.xpath;

import java.io.IOException;
import java.util.StringTokenizer;
import java.util.TreeSet;
import net.jxta.impl.xml.XmlParser;

public class DocumentParserCallback
implements XmlParser.ParserCallback {
    private static boolean debug = false;
    private TagStack tagStack = new TagStack();
    private StringBuffer path = new StringBuffer();
    private TreeSet paths = new TreeSet();
    private boolean expectEndTag = false;

    public static void main(String[] stringArray) throws IOException, XmlParser.Exception {
        byte[] byArray = new byte[32768];
        DocumentParserCallback documentParserCallback = new DocumentParserCallback();
        XmlParser.parse(System.in, byArray, documentParserCallback);
    }

    public TreeSet getPaths() {
        return this.paths;
    }

    public void startTag(byte[] byArray, int n, int n2) throws XmlParser.Exception {
        if (byArray[n] != 63 && byArray[n] != 33) {
            Tag tag = new Tag(new String(byArray, n, n2).toUpperCase());
            this.tagStack.push(tag);
            this.path.append('/');
            this.path.append(tag.name);
            this.addPaths(this.path.length());
        }
    }

    public void endTag(byte[] byArray, int n, int n2) throws XmlParser.Exception {
        Tag tag = this.tagStack.top();
        if (tag == null) {
            throw new XmlParser.Exception("Unexpected close tag " + new String(byArray, n, n2));
        }
        byte[] byArray2 = tag.name.toUpperCase().getBytes();
        if (XmlParser.startsWith(byArray2, byArray, n + 1, n2 - 1) || XmlParser.startsWith(byArray2, byArray, n, n2)) {
            this.path.setLength(this.path.length() - (tag.name.length() + 1));
            this.tagStack.pop();
            if (tag.charBuffer != null) {
                this.addText(tag);
            }
        } else {
            throw new XmlParser.Exception("Unexpected end tag " + new String(byArray, n, n2) + ".  Expecting " + tag.name);
        }
    }

    public void attribute(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) throws XmlParser.Exception {
        String string = new String(byArray, n, n2).toUpperCase();
        String string2 = new String(byArray2, n3, n4).toUpperCase();
        int n5 = this.path.length();
        this.path.append('[');
        this.path.append('@');
        this.path.append(string);
        this.path.append('=');
        this.path.append('\'');
        this.path.append(string2);
        this.path.append('\'');
        this.path.append(']');
        this.addPaths(n5);
        this.path.setLength(n5);
    }

    public void chars(byte[] byArray, int n, int n2) {
        Tag tag = this.tagStack.top();
        if (tag != null) {
            if (tag.charBuffer == null) {
                tag.charBuffer = new StringBuffer();
            }
            char[] cArray = new char[n2];
            int n3 = 0;
            while (n3 < n2) {
                cArray[n3] = (char)byArray[n + n3];
                ++n3;
            }
            tag.charBuffer.append(cArray);
        }
    }

    void addPath(String string) {
        this.paths.add(string);
    }

    StringTokenizer tokenize(String string) {
        return new StringTokenizer(string, " \t\r\n,.:;");
    }

    private void addText(Tag tag) {
        String string = tag.charBuffer.toString().trim().toUpperCase();
        if (string.length() > 0) {
            StringTokenizer stringTokenizer = this.tokenize(string);
            while (stringTokenizer.hasMoreElements()) {
                int n = this.path.length();
                this.path.append('[');
                this.path.append(tag.name);
                this.path.append('=');
                this.path.append('\'');
                this.path.append((String)stringTokenizer.nextElement());
                this.path.append('\'');
                this.path.append(']');
                this.addPaths(n);
                this.addPath("//" + this.path.substring(n));
                this.path.setLength(n);
            }
        }
    }

    private void addPaths(int n) {
        int n2 = this.path.length();
        int n3 = n - 1;
        Tag tag = this.tagStack.top;
        while (tag != null) {
            n3 -= tag.name.length();
            if (tag.next == null) {
                this.addPath(this.path.substring(n3, n2));
            } else {
                this.addPath("/" + this.path.substring(n3, n2));
            }
            if (tag != this.tagStack.top && tag != this.tagStack.top.next) {
                this.addPath((tag.next == null ? "/" : "//") + tag.name + "//" + this.tagStack.top.name + (n == n2 ? "" : this.path.substring(n, n2)));
            }
            --n3;
            tag = tag.next;
        }
    }

    class TagStack {
        Tag top;

        TagStack() {
        }

        void push(Tag tag) {
            if (this.top == null) {
                this.top = tag;
            } else {
                tag.next = this.top;
                this.top = tag;
            }
        }

        Tag pop() {
            Tag tag = this.top;
            if (this.top != null) {
                this.top = this.top.next;
            }
            return tag;
        }

        Tag top() {
            return this.top;
        }
    }

    class Tag {
        String name;
        StringBuffer charBuffer;
        Tag next;

        Tag(String string) {
            this.name = string.intern();
            this.charBuffer = null;
            this.next = null;
        }
    }
}

