/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.index;

import java.util.BitSet;
import net.jxta.impl.index.BloomFilter;
import net.jxta.impl.index.SummaryUpdate;
import net.jxta.impl.index.xpath.Expression;

public class RemoteSummary {
    BitSet summary;
    BloomFilter bf;
    String id;

    public RemoteSummary(SummaryUpdate summaryUpdate) {
        this.bf = new BloomFilter(summaryUpdate.getProperties());
        this.id = summaryUpdate.getId();
        this.summary = new BitSet();
        this.update(summaryUpdate);
    }

    public boolean query(Expression.Literal[] literalArray) {
        if (literalArray == null) {
            return false;
        }
        int n = 0;
        while (n < literalArray.length) {
            int[] nArray = this.bf.getBitPositions(literalArray[n].getName().toString());
            int n2 = 0;
            while (n2 < nArray.length) {
                if (!this.summary.get(nArray[n2])) {
                    return false;
                }
                ++n2;
            }
            ++n;
        }
        return true;
    }

    public void update(SummaryUpdate summaryUpdate) {
        int[] nArray;
        int n = Integer.MAX_VALUE;
        if (!this.bf.getProperties().equals(summaryUpdate.getProperties())) {
            this.bf = new BloomFilter(summaryUpdate.getProperties());
            this.summary = new BitSet();
        }
        if ((nArray = summaryUpdate.getBitPositions()) == null) {
            return;
        }
        int n2 = nArray.length;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = nArray[n3];
            if (n4 < 0) {
                this.summary.clear(n4 &= n);
            } else {
                this.summary.set(n4);
            }
            ++n3;
        }
    }

    public String getId() {
        return this.id;
    }
}

