/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.id.UUID;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownServiceException;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.impl.id.UUID.CodatID;
import net.jxta.impl.id.UUID.IDBytes;
import net.jxta.impl.id.UUID.IDFormat;
import net.jxta.impl.id.UUID.ModuleClassID;
import net.jxta.impl.id.UUID.ModuleSpecID;
import net.jxta.impl.id.UUID.PeerGroupID;
import net.jxta.impl.id.UUID.PeerID;
import net.jxta.impl.id.UUID.PipeID;

final class Instantiator
implements IDFactory.Instantiator {
    static final String UUIDEncoded = "uuid";

    Instantiator() {
    }

    public String getSupportedIDFormat() {
        return UUIDEncoded;
    }

    public ID fromURL(URL uRL) throws MalformedURLException, UnknownServiceException {
        ID iD = null;
        IDBytes iDBytes = new IDBytes();
        if (!"urn".equalsIgnoreCase(uRL.getProtocol())) {
            throw new UnknownServiceException("URI protocol type was not as expected.");
        }
        String string = uRL.getFile();
        int n = string.indexOf(58);
        if (-1 == n) {
            throw new UnknownServiceException("URN namespace was missing.");
        }
        if (!"jxta".equalsIgnoreCase(string.substring(0, n))) {
            throw new UnknownServiceException("URN namespace was not as expected.");
        }
        int n2 = (string = string.substring(n + 1)).indexOf(45);
        if (-1 == n2) {
            throw new UnknownServiceException("URN Encodingtype was missing.");
        }
        if (!string.substring(0, n2).equals(UUIDEncoded)) {
            throw new UnknownServiceException("JXTA id format was not as expected.");
        }
        if (0 != (string = string.substring(n2 + 1)).length() % 2) {
            throw new MalformedURLException("URN contains an odd number of chars");
        }
        if (string.length() < 2) {
            throw new MalformedURLException("URN does not contain enough chars");
        }
        if (64 < string.length() % 2) {
            throw new MalformedURLException("URN contains too many chars");
        }
        try {
            int n3 = 0;
            while (n3 < string.length() / 2 - 1) {
                int n4 = n3 * 2;
                String string2 = string.substring(n4, n4 + 2);
                iDBytes.bytes[n3] = (byte)Integer.parseInt(string2, 16);
                ++n3;
            }
            iDBytes.bytes[63] = (byte)Integer.parseInt(string.substring(string.length() - 2), 16);
        }
        catch (NumberFormatException numberFormatException) {
            throw new MalformedURLException("Invalid Character in jxta URI");
        }
        switch (iDBytes.bytes[63]) {
            case 1: {
                iD = new CodatID(iDBytes);
                break;
            }
            case 2: {
                iD = new PeerGroupID(iDBytes);
                if (!net.jxta.peergroup.PeerGroupID.worldPeerGroupID.equals(iD)) break;
                iD = net.jxta.peergroup.PeerGroupID.worldPeerGroupID;
                break;
            }
            case 3: {
                iD = new PeerID(iDBytes);
                break;
            }
            case 4: {
                iD = new PipeID(iDBytes);
                break;
            }
            case 5: {
                iD = new ModuleClassID(iDBytes);
                break;
            }
            case 6: {
                iD = new ModuleSpecID(iDBytes);
                break;
            }
            default: {
                throw new MalformedURLException("jxta ID type not recognized");
            }
        }
        return iD;
    }

    public net.jxta.codat.CodatID newCodatID(net.jxta.peergroup.PeerGroupID peerGroupID) {
        PeerGroupID peerGroupID2 = (PeerGroupID)IDFormat.translateFromWellKnown(peerGroupID);
        return new CodatID(peerGroupID2);
    }

    public net.jxta.codat.CodatID newCodatID(net.jxta.peergroup.PeerGroupID peerGroupID, InputStream inputStream) throws IOException {
        PeerGroupID peerGroupID2 = (PeerGroupID)IDFormat.translateFromWellKnown(peerGroupID);
        return new CodatID(peerGroupID2, inputStream);
    }

    public net.jxta.peer.PeerID newPeerID(net.jxta.peergroup.PeerGroupID peerGroupID) {
        PeerGroupID peerGroupID2 = (PeerGroupID)IDFormat.translateFromWellKnown(peerGroupID);
        return new PeerID(peerGroupID2);
    }

    public net.jxta.peergroup.PeerGroupID newPeerGroupID() {
        return new PeerGroupID();
    }

    public net.jxta.pipe.PipeID newPipeID(net.jxta.peergroup.PeerGroupID peerGroupID) {
        PeerGroupID peerGroupID2 = (PeerGroupID)IDFormat.translateFromWellKnown(peerGroupID);
        return new PipeID(peerGroupID2);
    }

    public net.jxta.pipe.PipeID newPipeID(net.jxta.peergroup.PeerGroupID peerGroupID, byte[] byArray) {
        PeerGroupID peerGroupID2 = (PeerGroupID)IDFormat.translateFromWellKnown(peerGroupID);
        return new PipeID(peerGroupID2, byArray);
    }

    public net.jxta.platform.ModuleClassID newModuleClassID() {
        return new ModuleClassID();
    }

    public net.jxta.platform.ModuleClassID newModuleClassID(net.jxta.platform.ModuleClassID moduleClassID) {
        return new ModuleClassID(moduleClassID);
    }

    public net.jxta.platform.ModuleSpecID newModuleSpecID(net.jxta.platform.ModuleClassID moduleClassID) {
        return new ModuleSpecID(moduleClassID);
    }
}

