/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.tls;

import java.io.IOException;
import java.util.Hashtable;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.exception.HandshakeInProgressException;
import net.jxta.impl.endpoint.tls.JTlsUtil;
import net.jxta.impl.endpoint.tls.TlsConn;
import net.jxta.impl.endpoint.tls.TlsTransport;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public class TlsManager {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$endpoint$tls$TlsManager == null ? (class$net$jxta$impl$endpoint$tls$TlsManager = TlsManager.class$("net.jxta.impl.endpoint.tls.TlsManager")) : class$net$jxta$impl$endpoint$tls$TlsManager).getName());
    TlsTransport transport = null;
    Hashtable cons = new Hashtable();
    private static final int CONN_TIMEOUT = 3600000;
    private static final int STARTOFHS = 1;
    private static final int RETRSTARTOFHS = 2;
    private static final int NOTSTARTOFHS = 0;
    private static int count = 1;
    static /* synthetic */ Class class$net$jxta$impl$endpoint$tls$TlsManager;

    private synchronized boolean handshakeInprogress(TlsConnInfo tlsConnInfo) {
        return !tlsConnInfo.handshakeDone;
    }

    private synchronized TlsConnInfo setTlsConnTable(String string, TlsConn tlsConn) {
        TlsConnInfo tlsConnInfo = null;
        if (this.cons.containsKey(string)) {
            tlsConnInfo = (TlsConnInfo)this.cons.get(string);
            if (tlsConnInfo.handshakeDone) {
                return tlsConnInfo;
            }
            if (LOG.isEnabledFor(Priority.INFO)) {
                LOG.info((Object)("Handshake in progress for " + string));
            }
            return null;
        }
        tlsConnInfo = new TlsConnInfo(tlsConn, System.currentTimeMillis());
        this.cons.put(string, tlsConnInfo);
        return tlsConnInfo;
    }

    public TlsManager(TlsTransport tlsTransport) {
        this.transport = tlsTransport;
    }

    public TlsConn getTlsConn(EndpointAddress endpointAddress) throws HandshakeInProgressException, IOException {
        TlsConn tlsConn = null;
        String string = endpointAddress.getProtocolAddress();
        TlsConnInfo tlsConnInfo = (TlsConnInfo)this.cons.get(string);
        if (tlsConnInfo != null) {
            long l;
            if (this.handshakeInprogress(tlsConnInfo)) {
                if (LOG.isEnabledFor(Priority.INFO)) {
                    LOG.info((Object)("Handshake in progress for " + string));
                }
                throw new HandshakeInProgressException("Handshake in progress");
            }
            tlsConn = tlsConnInfo.connection;
            if (tlsConn.getInputDead()) {
                if (LOG.isEnabledFor(Priority.INFO)) {
                    LOG.info((Object)("Input died for " + string));
                }
                throw new IOException("Input died");
            }
            long l2 = System.currentTimeMillis();
            if (l2 > (l = tlsConnInfo.lastAccessed + 3600000L)) {
                if (LOG.isEnabledFor(Priority.INFO)) {
                    long l3 = (l2 - tlsConnInfo.lastAccessed) / 60000L;
                    LOG.info((Object)("getTlsConn, idle time expired:\n  Dest = " + string + "  minutes idle = " + l3 + "\n"));
                }
                tlsConnInfo = null;
                this.cons.remove(string);
            } else {
                tlsConnInfo.lastAccessed = l2;
                this.cons.put(string, tlsConnInfo);
                if (LOG.isEnabledFor(Priority.INFO)) {
                    LOG.info((Object)"getTlsConn: Continuing cached Tls session");
                }
                return tlsConn;
            }
        }
        if (LOG.isEnabledFor(Priority.INFO)) {
            LOG.info((Object)("getTlsConn, new TlsConn:\n  Addr = " + string));
        }
        try {
            tlsConn = new TlsConn(this, this.transport, endpointAddress, true, null);
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.info((Object)("new tls connection = " + string));
            }
        }
        catch (Exception exception) {
            if (LOG.isEnabledFor(Priority.INFO)) {
                LOG.info((Object)"TlsManager:", (Throwable)exception);
            }
            return null;
        }
        tlsConnInfo = this.setTlsConnTable(string, tlsConn);
        if (tlsConnInfo == null) {
            tlsConn = null;
            throw new HandshakeInProgressException("Handshake in progress");
        }
        if (tlsConnInfo.handshakeDone) {
            if (LOG.isEnabledFor(Priority.INFO)) {
                LOG.info((Object)"TlsManager: continuing connection");
            }
            return tlsConnInfo.connection;
        }
        if (LOG.isEnabledFor(Priority.INFO)) {
            LOG.info((Object)"TlsManager: initiating handshake");
        }
        tlsConn.openTLSConnection();
        tlsConnInfo.handshakeDone = true;
        this.cons.put(string, tlsConnInfo);
        return tlsConn;
    }

    public void processIncomingMessage(Message message, EndpointAddress endpointAddress, EndpointAddress endpointAddress2) throws IOException {
        int n;
        TlsConn tlsConn = null;
        String string = null;
        string = endpointAddress.getProtocolAddress();
        ++count;
        TlsConnInfo tlsConnInfo = (TlsConnInfo)this.cons.get(string);
        boolean bl = false;
        if (tlsConnInfo != null) {
            int n2;
            tlsConn = tlsConnInfo.connection;
            if (tlsConn.getInputDead()) {
                if (LOG.isEnabledFor(Priority.INFO)) {
                    LOG.info((Object)("Input died for " + string));
                }
                throw new IOException("TLS Input died");
            }
            n = tlsConn.getHandshakeDone() ? 1 : 0;
            if (n != 0 && (n2 = this.firstHandshakeMessage(message)) == 1) {
                if (LOG.isEnabledFor(Priority.INFO)) {
                    int n3 = tlsConn.jin.getSequenceNumber();
                    LOG.info((Object)("Restart handshake, Seq#s: received 1, expected " + n3 + "\n"));
                }
                this.cons.remove(string);
                tlsConnInfo = null;
                bl = true;
            }
        }
        if (tlsConnInfo == null) {
            if (!bl && (n = this.firstHandshakeMessage(message)) != 1 && n != 2) {
                if (LOG.isEnabledFor(Priority.INFO)) {
                    LOG.info((Object)("NO CONNECTION, STATE = " + n + ", Discard msg."));
                }
                message = null;
                return;
            }
            if (LOG.isEnabledFor(Priority.INFO)) {
                LOG.info((Object)"New first contact server or handshake restart: ");
            }
            try {
                tlsConn = new TlsConn(this, this.transport, endpointAddress, false, message);
                if (LOG.isEnabledFor(Priority.INFO)) {
                    LOG.info((Object)("New Server tls connection = " + endpointAddress.toString()));
                }
                tlsConnInfo = new TlsConnInfo(tlsConn, System.currentTimeMillis());
                this.cons.put(string, tlsConnInfo);
            }
            catch (Exception exception) {
                if (LOG.isEnabledFor(Priority.INFO)) {
                    LOG.info((Object)"TlsManager, cannot establish Server Connection:", (Throwable)exception);
                }
                return;
            }
            try {
                tlsConn.openTLSConnection();
                tlsConnInfo.handshakeDone = true;
                tlsConnInfo.lastAccessed = System.currentTimeMillis();
                this.cons.put(string, tlsConnInfo);
            }
            catch (Exception exception) {
                if (LOG.isEnabledFor(Priority.INFO)) {
                    LOG.info((Object)"TlsManger, Handshake failure for TLS connection:", (Throwable)exception);
                }
                this.cons.remove(string);
                return;
            }
            if (LOG.isEnabledFor(Priority.INFO)) {
                LOG.info((Object)("TlsManger, NEW TLS Server, N = " + this.cons.size() + "]\n  New Server@" + string + "\n"));
            }
            return;
        }
        tlsConn.jin.queueIncomingMessage(message);
    }

    private int firstHandshakeMessage(Message message) {
        MessageElement messageElement = null;
        MessageElement messageElement2 = null;
        int n = 0;
        boolean bl = false;
        boolean bl2 = false;
        while ((messageElement = JTlsUtil.getNextElement(message, messageElement2)) != null) {
            String string = messageElement.getName();
            if (string.compareTo("jxtatls:MARKRetr") == 0) {
                bl2 = true;
            }
            try {
                n = JTlsUtil.getSequenceNumber(messageElement);
            }
            catch (Exception exception) {
                messageElement2 = messageElement;
                continue;
            }
            if (n == 1) {
                bl = true;
            }
            messageElement2 = messageElement;
        }
        if (bl) {
            if (bl2) {
                return 2;
            }
            return 1;
        }
        return 0;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class TlsConnInfo {
        TlsConn connection;
        boolean handshakeDone;
        long lastAccessed;

        public TlsConnInfo(TlsConn tlsConn, long l) {
            this.connection = tlsConn;
            this.handshakeDone = false;
            this.lastAccessed = l;
        }
    }
}

