/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.tls;

import COM.claymoresystems.cert.WrappedObject;
import COM.claymoresystems.crypto.EAYEncryptedPrivateKey;
import COM.claymoresystems.ptls.SSLDebug;
import COM.claymoresystems.util.Util;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateCrtKey;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import jxta.security.exceptions.CryptoException;
import jxta.security.hash.Hash;
import jxta.security.impl.crypto.JxtaCryptoSuite;
import jxta.security.impl.random.JRandom;
import jxta.security.util.URLBase64;
import net.jxta.impl.endpoint.tls.JTlsUtil;
import org.apache.log4j.Category;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.jce.X509V3CertificateGenerator;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class PeerCerts {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$endpoint$tls$PeerCerts == null ? (class$net$jxta$impl$endpoint$tls$PeerCerts = PeerCerts.class$("net.jxta.impl.endpoint.tls.PeerCerts")) : class$net$jxta$impl$endpoint$tls$PeerCerts).getName());
    static final String testPw = "password";
    private static final int NUM_BYTES = 128;
    static final String[] dh = new String[]{"-----BEGIN DH PARAMETERS-----\n", "MIGHAoGBANmAnfkETuKHOCWaE+W+F3kM/e7z5A8hZb7OqwGMQrUOaBEAr4BWeZBn\n", "G/87hhwZgNP69/KUchm714qd/PpOspCaUJ20x6PcmKujpAgca/f19HGMBjRawQMk\n", "R9oaBwazuQT0l0rTTKmvpMEcrQQIcVWii3CZI56I56oqF8biGPD7AgEC\n", "-----END DH PARAMETERS-----\n"};
    static /* synthetic */ Class class$net$jxta$impl$endpoint$tls$PeerCerts;

    public static IssuerInfo genPeerRootCert(String string, String string2) throws IOException {
        String string3 = JTlsUtil.getPCERootPath() + "peer-root.pem";
        SSLDebug.debug((int)128, (String)"Generating root cert ...");
        IssuerInfo issuerInfo = PeerCerts.genCert(string3, string + "-CA", null);
        issuerInfo.passwd = PeerCerts.genPassPhrase(string2);
        PeerCerts.appendPrivateKey(issuerInfo, string3);
        return issuerInfo;
    }

    public static void genPeerServiceCert(String string, IssuerInfo issuerInfo, String string2) throws IOException {
        String string3 = JTlsUtil.getPCEClientPath() + "peer-service.pem";
        SSLDebug.debug((int)128, (String)"\nGenerating client cert ...");
        IssuerInfo issuerInfo2 = PeerCerts.genCert(string3, string, issuerInfo);
        issuerInfo2.passwd = issuerInfo.passwd;
        PeerCerts.appendPrivateKey(issuerInfo2, string3);
    }

    private static void appendPrivateKey(IssuerInfo issuerInfo, String string) throws IOException {
        RSAPrivateCrtKey rSAPrivateCrtKey = (RSAPrivateCrtKey)issuerInfo.subjectPkey;
        FileWriter fileWriter = new FileWriter(string, true);
        BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
        EAYEncryptedPrivateKey.writePrivateKey((RSAPrivateCrtKey)rSAPrivateCrtKey, (byte[])issuerInfo.passwd, (BufferedWriter)bufferedWriter);
        bufferedWriter.flush();
        fileWriter.close();
    }

    public static SecureRandom seedSRN() throws CryptoException {
        byte[] byArray = new byte[128];
        JRandom jRandom = new JRandom();
        jRandom.nextBytes(byArray);
        return new SecureRandom(byArray);
    }

    private static byte[] genPassPhrase(String string) throws IOException {
        String string2 = JTlsUtil.getPCEClientPath();
        String string3 = string2 + "peer.phrase";
        byte[] byArray = new byte[128];
        SecureRandom secureRandom = null;
        try {
            secureRandom = PeerCerts.seedSRN();
        }
        catch (CryptoException cryptoException) {
            return null;
        }
        secureRandom.nextBytes(byArray);
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        byte[] byArray3 = null;
        try {
            byte by = 4;
            JxtaCryptoSuite jxtaCryptoSuite = new JxtaCryptoSuite(by, null, 0, 0);
            Hash hash = jxtaCryptoSuite.getJxtaHash((byte)1);
            byte[] byArray4 = new byte[hash.getDigestLength()];
            int n = 128;
            int n2 = 0;
            while (n2 < 127) {
                hash.doFinal(byArray, 0, n, byArray4, 0);
                System.arraycopy(byArray4, 0, byArray, 0, byArray4.length);
                n = byArray4.length;
                ++n2;
            }
            byArray3 = URLBase64.encode((byte[])byArray4);
            PeerCerts.writePassphrase(string3, new String(byArray3), string);
        }
        catch (CryptoException cryptoException) {
            throw new IOException("Could not generate passphrase");
        }
        return byArray3;
    }

    public static void writePassphrase(String string, String string2, String string3) throws CryptoException, IOException {
        byte[] byArray = string2.getBytes();
        File file = File.createTempFile("yyj", null);
        FileWriter fileWriter = new FileWriter(file);
        BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
        WrappedObject.writeHeader((String)"PASSPHRASE", (BufferedWriter)bufferedWriter);
        WrappedObject.writeObject((byte[])byArray, (String)"PASSPHRASE", (BufferedWriter)bufferedWriter);
        fileWriter.close();
        int n = (int)file.length();
        FileInputStream fileInputStream = new FileInputStream(file);
        byte[] byArray2 = new byte[n];
        int n2 = fileInputStream.read(byArray2, 0, n);
        fileInputStream.close();
        file.delete();
        byte[] byArray3 = JTlsUtil.tlsCipher(byArray2, string3, (byte)1);
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        fileOutputStream.write(byArray3, 0, n);
        fileOutputStream.close();
    }

    public static IssuerInfo genCert(String string, String string2, IssuerInfo issuerInfo) throws IOException {
        try {
            SecureRandom secureRandom = PeerCerts.seedSRN();
            Security.addProvider((Provider)new BouncyCastleProvider());
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA", "BC");
            keyPairGenerator.initialize(1024, secureRandom);
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            PrivateKey privateKey = keyPair.getPrivate();
            PublicKey publicKey = keyPair.getPublic();
            Hashtable hashtable = new Hashtable();
            hashtable.put(X509Name.C, "US");
            hashtable.put(X509Name.O, "www.jxta.org");
            hashtable.put(X509Name.L, "SF");
            byte[] byArray = new byte[10];
            secureRandom.nextBytes(byArray);
            String string3 = jxta.security.util.Util.hexEncode((byte[])byArray);
            hashtable.put(X509Name.OU, string3);
            hashtable.put(X509Name.CN, string2);
            Date date = new Date();
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            calendar.add(1, 10);
            Date date2 = calendar.getTime();
            Hashtable hashtable2 = null;
            PrivateKey privateKey2 = null;
            String string4 = null;
            if (issuerInfo == null) {
                hashtable2 = hashtable;
                privateKey2 = privateKey;
                string4 = "\nRoot Cert:";
            } else {
                hashtable2 = issuerInfo.issuer;
                privateKey2 = issuerInfo.rootKey;
                string4 = "\nClient Cert:";
            }
            X509V3CertificateGenerator x509V3CertificateGenerator = new X509V3CertificateGenerator();
            x509V3CertificateGenerator.setSerialNumber(BigInteger.valueOf(1L));
            x509V3CertificateGenerator.setIssuerDN((X509Name)new X509Principal(hashtable2));
            x509V3CertificateGenerator.setNotBefore(date);
            x509V3CertificateGenerator.setNotAfter(date2);
            x509V3CertificateGenerator.setSubjectDN((X509Name)new X509Principal(hashtable));
            x509V3CertificateGenerator.setPublicKey(publicKey);
            x509V3CertificateGenerator.setSignatureAlgorithm("SHA1withRSA");
            X509Certificate x509Certificate = x509V3CertificateGenerator.generateX509Certificate(privateKey2);
            FileWriter fileWriter = new FileWriter(string);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            bufferedWriter.write(x509Certificate.toString());
            bufferedWriter.flush();
            byte[] byArray2 = x509Certificate.getEncoded();
            WrappedObject.writeHeader((String)"CERTIFICATE", (BufferedWriter)bufferedWriter);
            WrappedObject.writeObject((byte[])byArray2, (String)"CERTIFICATE", (BufferedWriter)bufferedWriter);
            fileWriter.close();
            if (SSLDebug.getDebug((int)128)) {
                Util.xdump((String)string4, (byte[])byArray2);
            }
            IssuerInfo issuerInfo2 = new IssuerInfo();
            issuerInfo2.issuer = hashtable2;
            issuerInfo2.rootKey = privateKey2;
            issuerInfo2.subjectPkey = privateKey;
            return issuerInfo2;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            System.out.println("genCert: " + noSuchAlgorithmException.getMessage());
        }
        catch (SignatureException signatureException) {
            System.out.println("genCert: " + signatureException.getMessage());
        }
        catch (CertificateEncodingException certificateEncodingException) {
            System.out.println("genCert: " + certificateEncodingException.getMessage());
        }
        catch (InvalidKeyException invalidKeyException) {
            System.out.println("genCert: " + invalidKeyException.getMessage());
        }
        catch (NoSuchProviderException noSuchProviderException) {
            System.out.println("genCert: " + noSuchProviderException.getMessage());
        }
        catch (CertificateException certificateException) {
            System.out.println("genCert: " + certificateException.getMessage());
        }
        catch (CryptoException cryptoException) {
            System.out.println("genCert: " + cryptoException.getMessage());
        }
        throw new IOException("Could not generate certificate");
    }

    public static void genDhfile() throws IOException {
        String string = JTlsUtil.getPCEPath();
        String string2 = string + "dh1024.pem";
        FileWriter fileWriter = new FileWriter(string2);
        BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
        int n = 0;
        while (n < dh.length) {
            bufferedWriter.write(dh[n]);
            ++n;
        }
        bufferedWriter.flush();
        fileWriter.close();
    }

    public static void generateCerts(String string, String string2, boolean bl) throws Exception {
        IssuerInfo issuerInfo = PeerCerts.genPeerRootCert(string, string2);
        PeerCerts.genPeerServiceCert(string, issuerInfo, string2);
        if (bl) {
            PeerCerts.genDhfile();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class IssuerInfo {
        PrivateKey rootKey;
        Hashtable issuer;
        PrivateKey subjectPkey;
        byte[] passwd;

        private IssuerInfo() {
        }
    }
}

