/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.tls;

import COM.claymoresystems.cert.CertVerify;
import COM.claymoresystems.cert.WrappedObject;
import COM.claymoresystems.cert.X509Cert;
import COM.claymoresystems.ptls.SSLDebug;
import COM.claymoresystems.sslg.DistinguishedName;
import COM.claymoresystems.sslg.SSLPolicyInt;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.security.SecureRandom;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import jxta.security.cipher.Cipher;
import jxta.security.cipher.Key;
import jxta.security.exceptions.CryptoException;
import jxta.security.impl.cipher.KeyBuilder;
import jxta.security.impl.cipher.SecretKey;
import jxta.security.impl.crypto.JxtaCryptoSuite;
import jxta.security.util.URLBase64;
import net.jxta.document.MimeMediaType;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.endpoint.MessageElementEnumeration;
import net.jxta.impl.endpoint.MessageImpl;
import net.jxta.impl.endpoint.tls.PeerCerts;
import org.apache.log4j.Category;

public class JTlsUtil {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$endpoint$tls$JTlsUtil == null ? (class$net$jxta$impl$endpoint$tls$JTlsUtil = JTlsUtil.class$("net.jxta.impl.endpoint.tls.JTlsUtil")) : class$net$jxta$impl$endpoint$tls$JTlsUtil).getName());
    static final int SALTSIZE = 8;
    static final int PASSES = 11;
    static String[] hex = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};
    static /* synthetic */ Class class$net$jxta$impl$endpoint$tls$JTlsUtil;

    public static void removeElements(Message message) {
        MessageElementEnumeration messageElementEnumeration = message.getElements();
        while (messageElementEnumeration.hasMoreElements()) {
            MessageElement messageElement = (MessageElement)messageElementEnumeration.nextElement();
            message.removeElement(messageElement);
        }
    }

    public static MessageElement getNextElement(Message message, MessageElement messageElement) {
        MessageElementEnumeration messageElementEnumeration = ((MessageImpl)message).getElementsInFifoOrder();
        boolean bl = false;
        while (messageElementEnumeration.hasMoreElements()) {
            MessageElement messageElement2 = (MessageElement)messageElementEnumeration.nextElement();
            if (messageElement == null || bl) {
                return messageElement2;
            }
            if (messageElement != messageElement2) continue;
            bl = true;
        }
        return null;
    }

    public static int getMessageLength(Message message) {
        int n = 4;
        ++n;
        n += 2;
        MessageElementEnumeration messageElementEnumeration = ((MessageImpl)message).getElementsInFifoOrder();
        while (messageElementEnumeration.hasMoreElements()) {
            MessageElement messageElement = (MessageElement)messageElementEnumeration.nextElement();
            n += 4;
            ++n;
            ++n;
            String[] stringArray = MessageElement.parseName(messageElement.getName());
            String string = stringArray[0];
            String string2 = stringArray[1];
            n += JTlsUtil.stringLength(stringArray[1]);
            MimeMediaType mimeMediaType = messageElement.getType();
            if (mimeMediaType != null) {
                n += JTlsUtil.stringLength(mimeMediaType.toString());
            }
            n += 4;
            n += messageElement.getLength();
        }
        return n;
    }

    private static int stringLength(String string) {
        int n = 2;
        try {
            byte[] byArray = string.getBytes("UTF8");
            n += byArray.length;
        }
        catch (IOException iOException) {
            System.out.println("JXTATLSutil.stringLength: " + iOException.getMessage());
            n += string.length();
        }
        return n;
    }

    /*
     * Unable to fully structure code
     */
    public static short[] parseCipherSuites(String var0) throws ArrayIndexOutOfBoundsException {
        block5: {
            var1_1 = new StringTokenizer(var0, ":", false);
            var2_2 = new Vector<Integer>();
            try {
                while (true) {
                    if ((var4_6 = SSLPolicyInt.getCipherSuiteNumber((String)(var3_3 = var1_1.nextToken()))) <= -1) {
                        continue;
                    }
                    var2_2.addElement(new Integer(var4_6));
                }
            }
            catch (NoSuchElementException var3_4) {
                if (var2_2.size() <= 0) break block5;
                var3_5 = new short[var2_2.size()];
                var4_7 = 0;
                ** while (var4_7 < var2_2.size())
            }
lbl-1000:
            // 1 sources

            {
                var5_8 = (Integer)var2_2.elementAt(var4_7);
                var3_5[var4_7] = var5_8.shortValue();
                ++var4_7;
                continue;
            }
lbl18:
            // 1 sources

            return var3_5;
        }
        return null;
    }

    public static String getPCEPath() {
        String string = null;
        try {
            string = System.getProperty("file.separator");
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string2 = "pse" + string;
        return string2;
    }

    public static String getPCERootPath() {
        String string = null;
        try {
            string = System.getProperty("file.separator");
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string2 = "pse" + string + "root" + string;
        return string2;
    }

    public static String getPCEClientPath() {
        String string = null;
        try {
            string = System.getProperty("file.separator");
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string2 = "pse" + string + "client" + string;
        return string2;
    }

    public static String getPCEPasswdPath() {
        String string = null;
        try {
            string = System.getProperty("file.separator");
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string2 = "pse" + string + "etc" + string;
        return string2;
    }

    public static String readPassPhrase(String string, String string2) throws IOException {
        File file = new File(string);
        int n = (int)file.length();
        byte[] byArray = new byte[n];
        FileInputStream fileInputStream = new FileInputStream(file);
        fileInputStream.read(byArray, 0, n);
        fileInputStream.close();
        byte[] byArray2 = null;
        try {
            byArray2 = JTlsUtil.tlsCipher(byArray, string2, (byte)2);
        }
        catch (CryptoException cryptoException) {
            throw new IOException("Could not decrypt " + string);
        }
        File file2 = File.createTempFile("yyj", null);
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        fileOutputStream.write(byArray2, 0, byArray2.length);
        fileOutputStream.close();
        FileReader fileReader = new FileReader(file2);
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        byte[] byArray3 = WrappedObject.loadObject((BufferedReader)bufferedReader, (String)"PASSPHRASE", null);
        bufferedReader.close();
        file2.delete();
        return new String(byArray3);
    }

    public static byte[] tlsCipher(byte[] byArray, String string, byte by) throws CryptoException {
        JxtaCryptoSuite jxtaCryptoSuite = new JxtaCryptoSuite(1, null, 0, 0);
        Cipher cipher = jxtaCryptoSuite.getJxtaCipher();
        SecretKey secretKey = (SecretKey)KeyBuilder.buildKey((byte)8, (short)128, (boolean)false);
        byte[] byArray2 = string.getBytes();
        byte[] byArray3 = new byte[16];
        int n = 0;
        int n2 = 0;
        while (n < byArray3.length) {
            byArray3[n] = byArray2[n2++];
            if (n2 == byArray2.length) {
                n2 = 0;
            }
            ++n;
        }
        secretKey.setKey(byArray3, 0);
        byte[] byArray4 = new byte[byArray.length];
        cipher.init((Key)secretKey, by);
        cipher.doFinal(byArray, 0, byArray.length, byArray4, 0);
        return byArray4;
    }

    public static String loadObject(BufferedReader bufferedReader, String string) throws IOException {
        if (JTlsUtil.findObject(bufferedReader, string)) {
            return JTlsUtil.readBlock(bufferedReader);
        }
        return null;
    }

    public static boolean findObject(BufferedReader bufferedReader, String string) throws IOException {
        String string2;
        String string3;
        String string4 = "-----BEGIN ";
        String string5 = string3 = string == null ? "-----" : string + "-----";
        do {
            if ((string2 = bufferedReader.readLine()) != null) continue;
            return false;
        } while (!string2.startsWith(string4) || !string2.endsWith(string3));
        return true;
    }

    public static String readBlock(BufferedReader bufferedReader) throws IOException {
        String string;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(byteArrayOutputStream);
        while ((string = bufferedReader.readLine()) != null && !string.startsWith("-----END ")) {
            outputStreamWriter.write(string, 0, string.length());
            outputStreamWriter.write(10);
        }
        outputStreamWriter.flush();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        return new String(byArray);
    }

    public static void writeBase64Object(String string, String string2, BufferedWriter bufferedWriter) throws IOException {
        String string3 = "-----BEGIN " + string2 + "-----";
        bufferedWriter.write(string3);
        bufferedWriter.newLine();
        bufferedWriter.write(string);
        String string4 = "-----END " + string2 + "-----";
        bufferedWriter.write(string4);
        bufferedWriter.newLine();
        bufferedWriter.flush();
    }

    public static void writeRootCert(String string, String string2) throws IOException {
        FileWriter fileWriter = new FileWriter(string2);
        BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
        JTlsUtil.writeBase64Object(string, "CERTIFICATE", bufferedWriter);
        fileWriter.close();
    }

    public static boolean verifySignedCert(String string, String string2) {
        try {
            String[] stringArray = new String[]{string, string2};
            CertVerify.main((String[])stringArray);
        }
        catch (Exception exception) {
            if (SSLDebug.getDebug((int)128)) {
                System.out.println("Exception: " + exception.getMessage() + "\n  Cannot verify cert =" + string2 + "\n  Root = " + string);
            }
            return false;
        }
        return true;
    }

    public static boolean passwdExists() {
        String string = JTlsUtil.getPCEPasswdPath();
        File file = new File(string);
        try {
            String string2;
            File file2;
            if (file.exists() && (file2 = new File(string2 = string + "passwd")).exists()) {
                return true;
            }
        }
        catch (SecurityException securityException) {
            LOG.debug((Object)"passwdExists, exception:", (Throwable)securityException);
            return false;
        }
        return false;
    }

    public static boolean validPasswd(String string) {
        if (JTlsUtil.passwdExists()) {
            String string2 = null;
            try {
                string2 = JTlsUtil.getPasswordEntry();
            }
            catch (IOException iOException) {
                LOG.debug((Object)"validPasswd:", (Throwable)iOException);
                return false;
            }
            int n = string2.indexOf(44);
            String string3 = string2.substring(0, n);
            String string4 = string2.substring(n + 1);
            byte[] byArray = string3.getBytes();
            byte[] byArray2 = null;
            try {
                byArray2 = URLBase64.decode((byte[])byArray, (int)0, (int)byArray.length);
            }
            catch (CryptoException cryptoException) {
                LOG.debug((Object)"validPasswd:", (Throwable)cryptoException);
                return false;
            }
            String string5 = null;
            try {
                string5 = JTlsUtil.makePasswdEntry(string, byArray2);
            }
            catch (IOException iOException) {
                LOG.debug((Object)"validPasswd:", (Throwable)iOException);
                return false;
            }
            int n2 = string5.indexOf(44);
            String string6 = string5.substring(n2 + 1);
            return string6.compareTo(string4) == 0;
        }
        return false;
    }

    public static void createPasswdFile(String string, boolean bl) throws SecurityException, IOException {
        if (!bl && JTlsUtil.passwdExists()) {
            throw new SecurityException("Cannot create password file. It already exists.");
        }
        String string2 = JTlsUtil.getPCEPasswdPath();
        File file = new File(string2);
        File file2 = new File(string2 + "passwd");
        if (file.exists()) {
            if (file2.exists()) {
                file2.delete();
            }
        } else {
            file.mkdir();
        }
        String string3 = JTlsUtil.makePasswdEntry(string, null);
        FileWriter fileWriter = new FileWriter(file2);
        BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
        bufferedWriter.write(string3, 0, string3.length());
        bufferedWriter.newLine();
        bufferedWriter.flush();
        bufferedWriter.close();
    }

    public static String getPasswordEntry() throws IOException {
        String string = JTlsUtil.getPCEPasswdPath() + "passwd";
        FileReader fileReader = new FileReader(string);
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        String string2 = bufferedReader.readLine();
        return string2;
    }

    public static String makePasswdEntry(String string, byte[] byArray) throws IOException {
        Object object;
        Object object2;
        Object object3;
        byte[] byArray2 = null;
        if (byArray == null) {
            object3 = null;
            try {
                object3 = PeerCerts.seedSRN();
            }
            catch (CryptoException cryptoException) {
                return null;
            }
            byArray2 = new byte[8];
            ((SecureRandom)object3).nextBytes(byArray2);
        } else {
            byArray2 = byArray;
        }
        object3 = null;
        byte[] byArray3 = null;
        try {
            object2 = new JxtaCryptoSuite(4, null, 0, 0);
            object = object2.getJxtaHash((byte)1);
            int n = object.getDigestLength();
            byte[] byArray4 = new byte[n];
            byte[] byArray5 = string.getBytes();
            int n2 = string.length() + 8;
            int n3 = n2 < n ? n : n2;
            byArray3 = new byte[n3];
            System.arraycopy(byArray2, 0, byArray3, 0, 8);
            System.arraycopy(byArray5, 0, byArray3, 8, byArray5.length);
            int n4 = n2;
            int n5 = 0;
            while (n5 <= 11) {
                object.doFinal(byArray3, 0, n4, byArray4, 0);
                System.arraycopy(byArray4, 0, byArray3, 0, byArray4.length);
                n4 = byArray4.length;
                ++n5;
            }
            object3 = URLBase64.encode((byte[])byArray4);
        }
        catch (CryptoException cryptoException) {
            throw new IOException("makePasswdEntry: Cannot generate password file");
        }
        object2 = URLBase64.encode((byte[])byArray2);
        object = new String((byte[])object2);
        String string2 = new String((byte[])object3);
        return new String((String)object + "," + string2);
    }

    public static boolean principalIsIssuer(String string) {
        String string2 = JTlsUtil.getPCERootPath() + "peer-root.pem";
        try {
            byte[] byArray = CertVerify.loadCert((String)string2);
            X509Cert x509Cert = new X509Cert(byArray);
            DistinguishedName distinguishedName = x509Cert.getIssuerName();
            String string3 = distinguishedName.getNameString();
            int n = string3.indexOf(string);
            if (n != -1 && n >= 3) {
                String string4;
                String string5 = string3.substring(n - 3, n);
                if (string5.compareTo("CN=") != 0) {
                    return false;
                }
                int n2 = n + string.length();
                String string6 = string3.substring(n2, n2 + 3);
                if (string6.compareTo("-CA") == 0 && (string4 = string3.substring(n, n2)).compareTo(string) == 0) {
                    return true;
                }
            }
            return false;
        }
        catch (Exception exception) {
            SSLDebug.debug((int)128, (String)("Exception validating principal:" + exception.getMessage()));
            return false;
        }
    }

    static int getSequenceNumber(MessageElement messageElement) throws NumberFormatException {
        String[] stringArray = MessageElement.parseName(messageElement.getName());
        String string = stringArray[0];
        String string2 = stringArray[1];
        Integer n = new Integer(string2);
        return n;
    }

    public static String toHex(byte[] byArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = n;
        while (n3 < n2) {
            if (n3 > 0 && n3 % 12 == 0) {
                stringBuffer.append("\n");
            }
            stringBuffer.append(hex[byArray[n3] >> 4 & 0xF]);
            stringBuffer.append(hex[byArray[n3] & 0xF]);
            stringBuffer.append(" ");
            ++n3;
        }
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

