/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.tls;

import COM.claymoresystems.ptls.SSLContext;
import COM.claymoresystems.sslg.SSLPolicyInt;
import java.io.IOException;
import net.jxta.impl.endpoint.tls.JTlsUtil;

public class JTlsParams {
    private String keyfile = null;
    private String passphrase = null;
    private String rootfile = null;
    private boolean acceptUnverifiedCerts = false;
    private boolean validateDates = false;
    private short[] cipherSuites = null;
    private SSLContext ctx = new SSLContext();
    private SSLPolicyInt policy = new SSLPolicyInt();

    public JTlsParams() {
        this.ctx.seedJxtaRNG();
        this.cipherSuites = null;
    }

    public SSLContext getContext() {
        return this.ctx;
    }

    public SSLPolicyInt getPolicy() {
        return this.policy;
    }

    private void loadRootCerts(String string) throws IOException {
        this.passphrase = this.passphrase;
        this.rootfile = string;
        this.ctx.loadRootCertificates(string);
    }

    private void loadEAYKeyFile(String string, String string2) throws IOException {
        this.keyfile = string;
        this.passphrase = string2;
        this.ctx.loadEAYKeyFile(string, string2);
    }

    private void setCertPolicies(boolean bl, boolean bl2) {
        this.acceptUnverifiedCerts = bl;
        this.validateDates = bl2;
        this.policy.checkCertificateDates(this.validateDates);
        this.policy.acceptUnverifiableCertificates(this.acceptUnverifiedCerts);
    }

    private void setCipherSuites(String string) {
        if (string == null) {
            return;
        }
        this.cipherSuites = JTlsUtil.parseCipherSuites(string);
        if (this.cipherSuites != null) {
            this.policy.setCipherSuites(this.cipherSuites);
        }
    }

    public void setClientParameters(String string, String string2, String string3, String string4, boolean bl, boolean bl2) throws IOException, ArrayIndexOutOfBoundsException {
        if (string == null || string2 == null) {
            throw new IOException("null file name as argument");
        }
        this.loadRootCerts(string);
        this.loadEAYKeyFile(string2, string3);
        this.setCertPolicies(bl, bl2);
        this.setCipherSuites(string4);
        this.ctx.setPolicy(this.policy);
    }

    public void setServerParameters(String string, String string2, String string3, String string4, boolean bl) throws IOException {
        if (string == null || string2 == null) {
            throw new IOException("null file name as argument");
        }
        if (string3 != null) {
            this.ctx.loadDHParams(string3);
        }
        this.loadRootCerts(string);
        this.loadEAYKeyFile(string2, string4);
        this.policy.requireClientAuth(bl);
        this.ctx.setPolicy(this.policy);
    }
}

