/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.tls;

import COM.claymoresystems.ptls.SSLDebug;
import COM.claymoresystems.ptls.SSLSocket;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.impl.endpoint.MessageImpl;
import net.jxta.impl.endpoint.MessageWireFormat;
import net.jxta.impl.endpoint.MessageWireFormatBinary;
import net.jxta.impl.endpoint.tls.JTlsDefs;
import net.jxta.impl.endpoint.tls.JTlsRecord;
import net.jxta.impl.endpoint.tls.JTlsUtil;
import net.jxta.impl.endpoint.tls.TlsConn;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public class JTlsInputStream
extends InputStream {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$endpoint$tls$JTlsInputStream == null ? (class$net$jxta$impl$endpoint$tls$JTlsInputStream = JTlsInputStream.class$("net.jxta.impl.endpoint.tls.JTlsInputStream")) : class$net$jxta$impl$endpoint$tls$JTlsInputStream).getName());
    TlsConn conn;
    private boolean tlsInputDebug = false;
    private JTlsRecord jtrec = null;
    private MessageWireFormat wireIn = null;
    private int sequenceNumber = 0;
    private int mrrSequenceNumber = 0;
    private Vector inputElements = new Vector(10, 1);
    private InputStream plain_in = null;
    private InputStream netIn = null;
    private static int MAXQUEUESIZE = 25;
    Vector inputQueue = new Vector(MAXQUEUESIZE);
    private static final String ACKKEY = "ack=";
    private static final String SACKKEY = "sack=";
    private int holeStart = 0;
    private int holeEnd = 0;
    private static final byte[] ACKText = new byte[]{84, 76, 83, 65, 67, 75};
    private MessageElement currentElt = null;
    static /* synthetic */ Class class$net$jxta$impl$endpoint$tls$JTlsInputStream;

    public JTlsInputStream(TlsConn tlsConn) {
        this.conn = tlsConn;
        this.jtrec = new JTlsRecord();
        this.wireIn = new MessageWireFormatBinary(JTlsDefs.MTYPE);
        this.sequenceNumber = 0;
        this.mrrSequenceNumber = 0;
        this.plain_in = null;
    }

    int getSequenceNumber() {
        return this.sequenceNumber;
    }

    int getMaxIQSize() {
        return MAXQUEUESIZE;
    }

    public void setPlaintextInputStream(SSLSocket sSLSocket) {
        this.plain_in = sSLSocket.getInputStream();
    }

    public int readMessage(Message message) {
        try {
            this.wireIn.readMessage(this.plain_in, message);
        }
        catch (IOException iOException) {
            if (LOG.isEnabledFor(Priority.INFO)) {
                LOG.info((Object)("IOException in JTlsInputStream.readMessage:\n  " + iOException.getMessage()));
            }
            return -1;
        }
        return 0;
    }

    private int rcvdACK(MessageElement messageElement) {
        String[] stringArray = MessageElement.parseName(messageElement.getName());
        String string = stringArray[0];
        String string2 = stringArray[1];
        int n = string2.indexOf(ACKKEY);
        if (n != -1) {
            Integer n2 = new Integer(string2.substring(n + 4));
            if (LOG.isEnabledFor(Priority.INFO)) {
                LOG.info((Object)("ACK RCVD, SEQN = " + n2));
            }
            return n2;
        }
        return 0;
    }

    private void triggerRetransmission(int n) {
        if (n > this.mrrSequenceNumber + 1) {
            if (this.holeStart == this.mrrSequenceNumber && this.holeEnd + 1 == n) {
                if (LOG.isEnabledFor(Priority.INFO)) {
                    LOG.info((Object)("TRIGGER ACK: Ignore duplicate hole [" + this.mrrSequenceNumber + ", " + n + "]"));
                }
                this.holeEnd = n;
                return;
            }
            if (LOG.isEnabledFor(Priority.INFO)) {
                LOG.info((Object)("TRIGGER ACK: Input hole [" + this.mrrSequenceNumber + ", " + n + "]"));
            }
            String string = SACKKEY + this.mrrSequenceNumber + "," + n;
            this.sendACK(this.mrrSequenceNumber, string);
            this.holeStart = this.mrrSequenceNumber;
            this.holeEnd = n;
        }
    }

    private void sendACK(int n) {
        int n2 = this.mrrSequenceNumber;
        boolean bl = false;
        String string = n != 0 ? SACKKEY + n + "," + n2 : SACKKEY + n2;
        int n3 = 0;
        while (n3 < this.inputQueue.size()) {
            IQElt iQElt = (IQElt)this.inputQueue.elementAt(n3);
            string = string + "," + iQElt.seqnum;
            if (iQElt.seqnum == n2 + 1) {
                n2 = iQElt.seqnum;
            }
            if (!iQElt.ackd) {
                iQElt.ackd = true;
                bl = true;
            }
            ++n3;
        }
        this.sendACK(n2, string);
    }

    private void sendACK(int n, String string) {
        block4: {
            String string2 = "jxtatls:ack=" + n;
            byte[] byArray = string == null ? ACKText : string.getBytes();
            MessageImpl messageImpl = new MessageImpl();
            MessageElement messageElement = messageImpl.newMessageElement(string2, null, byArray, 0, byArray.length);
            messageImpl.addElement(messageElement);
            try {
                this.conn.transport.sendToRemoteTls(this.conn.destAddr, messageImpl);
                if (LOG.isEnabledFor(Priority.INFO)) {
                    LOG.info((Object)("SENT ACK, SEQN = " + n));
                    if (string != null) {
                        LOG.info((Object)("    SACK, SEQN = " + string));
                    }
                }
            }
            catch (IOException iOException) {
                if (!LOG.isEnabledFor(Priority.INFO)) break block4;
                LOG.info((Object)"sendACK caught IOException:", (Throwable)iOException);
            }
        }
    }

    private MessageElement validateElement(IQElt iQElt) {
        if (iQElt.seqnum > this.sequenceNumber) {
            this.inputElements.add(iQElt.elt);
            if (LOG.isEnabledFor(Priority.INFO)) {
                LOG.info((Object)("validateElement: queue elt: seq# = " + iQElt.seqnum + " expected = " + this.sequenceNumber));
            }
            this.triggerRetransmission(iQElt.seqnum);
            return null;
        }
        if (iQElt.seqnum < this.sequenceNumber) {
            if (LOG.isEnabledFor(Priority.INFO)) {
                LOG.info((Object)("validateElement: duplicate, seq# = " + iQElt.seqnum + " expected = " + this.sequenceNumber));
            }
            return null;
        }
        if (LOG.isEnabledFor(Priority.INFO)) {
            LOG.info((Object)("validateElement: elt in sequence = " + iQElt.seqnum));
        }
        return iQElt.elt;
    }

    private MessageElement getVectorElement() {
        int n = this.inputElements.size();
        int n2 = 0;
        while (n2 < n) {
            MessageElement messageElement = (MessageElement)this.inputElements.elementAt(n2);
            int n3 = JTlsUtil.getSequenceNumber(messageElement);
            if (n3 == this.sequenceNumber) {
                this.inputElements.removeElementAt(n2);
                return messageElement;
            }
            ++n2;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void queueIncomingMessage(Message var1_1) {
        var2_2 = 0;
        var3_3 = 0;
        var4_4 = 0;
        var5_5 = ((MessageImpl)var1_1).getElementsInFifoOrder();
        var6_6 = null;
        while (var5_5.hasMoreElements()) {
            var6_6 = (MessageElement)var5_5.nextElement();
            var3_3 = this.rcvdACK(var6_6);
            if (var3_3 != 0) {
                var7_8 = var6_6.getBytesOffset();
                var8_12 = new String(var7_8);
                var9_14 = null;
                if (var8_12.indexOf("sack=") != -1) {
                    var9_14 = new String(var7_8, "sack=".length(), var7_8.length - "sack=".length());
                }
                if (JTlsInputStream.LOG.isEnabledFor(Priority.INFO)) {
                    JTlsInputStream.LOG.info((Object)("SACKLIST = " + var9_14));
                }
                this.conn.jout.ackReceived(var3_3, var9_14);
                var1_1 = null;
                this.notifyAll();
                return;
            }
            try {
                var4_4 = JTlsUtil.getSequenceNumber(var6_6);
                if (var4_4 == 0) continue;
                if (var4_4 >= this.mrrSequenceNumber) break;
                if (JTlsInputStream.LOG.isEnabledFor(Priority.INFO)) {
                    JTlsInputStream.LOG.info((Object)("RCVD DUPLICATE MSG: Discard seq# " + var4_4));
                }
                var4_4 = -1;
                break;
            }
            catch (NumberFormatException var7_7) {
                // empty catch block
            }
        }
        if (var4_4 > 0) ** GOTO lbl46
        if (JTlsInputStream.LOG.isEnabledFor(Priority.INFO) && var4_4 == 0) {
            JTlsInputStream.LOG.info((Object)"TLS!! Received DUPLICATE or NON-TLS msg");
        }
        var1_1 = null;
        this.notifyAll();
        return;
lbl-1000:
        // 1 sources

        {
            try {
                if (JTlsInputStream.LOG.isEnabledFor(Priority.INFO) && var2_2++ % 10 == 0) {
                    JTlsInputStream.LOG.info((Object)("NotifyAll(): enqueue WAIT, size = " + this.inputQueue.size()));
                }
                this.notifyAll();
                this.wait();
                continue;
            }
            catch (InterruptedException var7_10) {
                // empty catch block
            }
lbl46:
            // 3 sources

            ** while (this.inputQueue.size() >= JTlsInputStream.MAXQUEUESIZE)
        }
lbl47:
        // 1 sources

        if (JTlsInputStream.LOG.isEnabledFor(Priority.INFO)) {
            JTlsInputStream.LOG.info((Object)"QUEUE incoming message:");
        }
        var2_2 = this.inputQueue.size();
        var7_11 = -1;
        var8_13 = false;
        var9_15 = 0;
        while (var9_15 < var2_2) {
            var10_16 = (IQElt)this.inputQueue.elementAt(var9_15);
            if (var4_4 < var10_16.seqnum) {
                var7_11 = var9_15;
                break;
            }
            if (var4_4 == var10_16.seqnum) {
                var8_13 = true;
                break;
            }
            ++var9_15;
        }
        if (!var8_13 && var4_4 > this.mrrSequenceNumber) {
            var10_16 = new IQElt();
            var10_16.seqnum = var4_4;
            var10_16.msg = var1_1;
            var10_16.elt = var6_6;
            var10_16.ackd = false;
            if (var7_11 == -1) {
                var7_11 = this.inputQueue.size();
            }
            this.inputQueue.add(var7_11, var10_16);
            if (JTlsInputStream.LOG.isEnabledFor(Priority.INFO)) {
                JTlsInputStream.LOG.info((Object)("Enqueued msg with seq# " + var4_4 + " At index " + var7_11));
            }
        } else {
            var1_1 = null;
            if (JTlsInputStream.LOG.isEnabledFor(Priority.INFO)) {
                JTlsInputStream.LOG.info((Object)("TLS!! Discarded duplicate msg, seq# = " + var4_4));
            }
        }
        this.notifyAll();
        if (JTlsInputStream.LOG.isEnabledFor(Priority.INFO) && SSLDebug.getDebug((int)128)) {
            JTlsInputStream.LOG.info((Object)("NotifyAll(): N TLS Records queued = " + this.inputQueue.size()));
        }
    }

    private IQElt dequeueMessage() {
        IQElt iQElt = null;
        int n = 0;
        while (this.inputQueue.size() == 0) {
            try {
                ++n;
                this.notifyAll();
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.inputQueue.size() > 0) {
            iQElt = (IQElt)this.inputQueue.elementAt(0);
            this.inputQueue.removeElementAt(0);
            if (LOG.isEnabledFor(Priority.INFO)) {
                LOG.info((Object)("DEQUEUED a TLS Record to process, seq# = " + iQElt.seqnum));
                LOG.info((Object)("DEQUEUE waited " + n + " times on empty input queue"));
            }
        }
        this.notifyAll();
        return iQElt;
    }

    private synchronized int local_read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (this.jtrec.size == 0 || this.jtrec.nextByte == this.jtrec.size) {
            Object object;
            this.jtrec.resetRecord();
            ++this.sequenceNumber;
            this.currentElt = this.getVectorElement();
            if (this.currentElt == null) {
                try {
                    while (this.currentElt == null) {
                        object = null;
                        object = this.dequeueMessage();
                        if (object == null) continue;
                        this.currentElt = this.validateElement((IQElt)object);
                        JTlsUtil.removeElements(((IQElt)object).msg);
                    }
                }
                catch (Exception exception) {
                    if (LOG.isEnabledFor(Priority.INFO)) {
                        LOG.info((Object)("TLSInputStream exception: " + exception));
                    }
                    return -1;
                }
            }
            this.mrrSequenceNumber = this.sequenceNumber;
            this.sendACK(0);
            this.jtrec.size = this.currentElt.getLength();
            if (this.tlsInputDebug && LOG.isEnabledFor(Priority.INFO)) {
                LOG.info((Object)("local_read: seq#" + this.sequenceNumber + ", bytes = " + this.jtrec.size + "\n"));
            }
            this.jtrec.tlsRecord = this.currentElt.getBytesOffset();
            if (LOG.isEnabledFor(Priority.INFO)) {
                LOG.info((Object)("Rcvd TLS Record[" + this.jtrec.size + " bytes]" + " Seq# = " + this.sequenceNumber));
                if (this.sequenceNumber < 6) {
                    object = JTlsUtil.toHex(this.jtrec.tlsRecord, 0, this.jtrec.size);
                    LOG.info((Object)("HexDump:\n" + (String)object));
                }
            }
        }
        int n4 = (n3 = this.jtrec.size - this.jtrec.nextByte) < n2 ? n3 : n2;
        System.arraycopy(this.jtrec.tlsRecord, this.jtrec.nextByte, byArray, n, n4);
        this.jtrec.nextByte += n4;
        if (this.tlsInputDebug && LOG.isEnabledFor(Priority.INFO)) {
            LOG.info((Object)("\nRequested " + n2 + ", Read " + n4 + " bytes"));
        }
        return n4;
    }

    public int read() throws IOException {
        byte[] byArray = new byte[1];
        int n = this.local_read(byArray, 0, 1);
        if (n != -1) {
            if (LOG.isEnabledFor(Priority.INFO) && SSLDebug.getDebug((int)128)) {
                LOG.info((Object)("Read() " + n));
            }
            n = byArray[0] & 0xFF;
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.local_read(byArray, n, n2);
        if (LOG.isEnabledFor(Priority.INFO) && SSLDebug.getDebug((int)128)) {
            LOG.info((Object)("Read(byte[], int, " + n2 + "), bytes read = " + n3));
        }
        return n3;
    }

    public int read(byte[] byArray) throws IOException {
        int n = this.local_read(byArray, 0, byArray.length);
        return n;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class IQElt {
        int seqnum;
        Message msg;
        MessageElement elt;
        boolean ackd;

        private IQElt() {
        }
    }
}

