/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.tcp;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public class TcpSocket
implements Runnable {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$endpoint$tcp$TcpSocket == null ? (class$net$jxta$impl$endpoint$tcp$TcpSocket = TcpSocket.class$("net.jxta.impl.endpoint.tcp.TcpSocket")) : class$net$jxta$impl$endpoint$tcp$TcpSocket).getName());
    private static final int TcpConnectionSendBufferSize = 65536;
    private static final int TcpConnectionSoTimeout = 30000;
    private static final int FailureDelay = 600000;
    private InetAddress inetAddress = null;
    private int port = 0;
    private long lastOpened = 0L;
    private long lastFailed = 0L;
    private Socket socket = null;
    private boolean pendingConnection = false;
    private boolean activity = false;
    static /* synthetic */ Class class$net$jxta$impl$endpoint$tcp$TcpSocket;

    public TcpSocket(InetAddress inetAddress, int n) {
        this.inetAddress = inetAddress;
        this.port = n;
        this.connect();
    }

    public TcpSocket() {
    }

    public synchronized Socket getSocket(long l) {
        if (this.socket != null) {
            return this.socket;
        }
        this.connect();
        if (this.pendingConnection) {
            try {
                this.wait(l);
            }
            catch (InterruptedException interruptedException) {
                return this.socket;
            }
        }
        return this.socket;
    }

    public synchronized void setSocket(Socket socket) {
        this.socket = socket;
    }

    public synchronized long getLastOpened() {
        return this.lastOpened;
    }

    public synchronized void setLastOpened(long l) {
        this.lastOpened = l;
    }

    public synchronized long getLastFailed() {
        return this.lastFailed;
    }

    public synchronized void setLastFailed(long l) {
        this.lastFailed = l;
    }

    private void connect() {
        boolean bl = false;
        TcpSocket tcpSocket = this;
        synchronized (tcpSocket) {
            if (this.pendingConnection) {
                return;
            }
            if (this.lastOpened == 0L || this.lastFailed == 0L || this.activity) {
                if (this.activity) {
                    this.activity = false;
                }
                bl = true;
            } else if (this.lastOpened > this.lastFailed) {
                bl = true;
            } else if (this.lastFailed + 600000L <= System.currentTimeMillis()) {
                bl = true;
            }
            if (!bl) {
                return;
            }
            this.pendingConnection = true;
            new Thread((Runnable)this, "TcpSocket open Socket for " + this.inetAddress.toString()).start();
        }
        Thread.yield();
    }

    public void run() {
        Socket socket = null;
        try {
            socket = new Socket(this.inetAddress, this.port);
        }
        catch (IOException iOException) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("Cannot open socket for " + this.inetAddress.toString() + ":" + this.port), (Throwable)iOException);
            }
            TcpSocket tcpSocket = this;
            synchronized (tcpSocket) {
                this.pendingConnection = false;
                this.setLastFailed(System.currentTimeMillis());
                this.socket = null;
                this.notifyAll();
            }
            return;
        }
        try {
            socket.setSendBufferSize(65536);
            socket.setTcpNoDelay(true);
            socket.setSoTimeout(30000);
            socket.setKeepAlive(true);
        }
        catch (Exception exception) {
            block17: {
                if (LOG.isEnabledFor(Priority.ERROR)) {
                    LOG.error((Object)"Cannot set socket options", (Throwable)exception);
                }
                try {
                    socket.close();
                }
                catch (Exception exception2) {
                    if (!LOG.isEnabledFor(Priority.ERROR)) break block17;
                    LOG.error((Object)"Cannot close socket.", (Throwable)exception2);
                }
            }
            TcpSocket tcpSocket = this;
            synchronized (tcpSocket) {
                this.setLastFailed(System.currentTimeMillis());
                this.socket = null;
                this.pendingConnection = false;
                this.notifyAll();
            }
            return;
        }
        TcpSocket tcpSocket = this;
        synchronized (tcpSocket) {
            this.socket = socket;
            this.setLastOpened(System.currentTimeMillis());
            this.pendingConnection = false;
            this.notifyAll();
        }
    }

    public synchronized void close() {
        block7: {
            block6: {
                if (this.pendingConnection) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        if (!LOG.isEnabledFor(Priority.ERROR)) break block6;
                        LOG.error((Object)"Interrupted. Cannot close socket.", (Throwable)interruptedException);
                    }
                }
            }
            if (this.socket != null) {
                try {
                    this.socket.close();
                }
                catch (Exception exception) {
                    if (!LOG.isEnabledFor(Priority.ERROR)) break block7;
                    LOG.error((Object)"Cannot close socket.", (Throwable)exception);
                }
            }
        }
        this.socket = null;
    }

    public synchronized void notifyActivity() {
        this.activity = true;
    }

    public void finalize() {
        this.close();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

