/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.tcp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Vector;
import net.jxta.document.MimeMediaType;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.Message;
import net.jxta.impl.endpoint.EndpointReceiveQueue;
import net.jxta.impl.endpoint.MessageWireFormatFactory;
import net.jxta.impl.endpoint.tcp.Header;
import net.jxta.impl.endpoint.tcp.TcpSocket;
import net.jxta.impl.endpoint.tcp.TcpTransport;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public class TcpConnection
implements Runnable {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$endpoint$tcp$TcpConnection == null ? (class$net$jxta$impl$endpoint$tcp$TcpConnection = TcpConnection.class$("net.jxta.impl.endpoint.tcp.TcpConnection")) : class$net$jxta$impl$endpoint$tcp$TcpConnection).getName());
    public static final int MaxNbOfMessages = 40;
    private InetAddress inetAddress = null;
    private int port = 0;
    private TcpTransport proto = null;
    private Header header = null;
    private TcpSocket tcpSocket = null;
    private boolean waiting = false;
    private EndpointAddress dstAddress = null;
    private long lastUsed = 0L;
    private String dstAddrString = null;
    private Thread thread = null;
    private EndpointReceiveQueue queue = null;
    private long nbOfMessagesSent = 0L;
    static /* synthetic */ Class class$net$jxta$impl$endpoint$tcp$TcpConnection;

    public TcpConnection(EndpointAddress endpointAddress, TcpTransport tcpTransport) throws IOException {
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"Constructor");
        }
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("   addr = " + endpointAddress.toString()));
        }
        this.header = new Header();
        this.proto = tcpTransport;
        this.dstAddress = (EndpointAddress)endpointAddress.clone();
        try {
            String string = endpointAddress.getProtocolAddress();
            int n = string.indexOf(":");
            if (n == -1) {
                throw new IOException();
            }
            this.port = Integer.valueOf(string.substring(n + 1));
            this.inetAddress = InetAddress.getByName(string.substring(0, n));
            this.dstAddrString = this.inetAddress.getHostAddress();
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("Constructor using: " + this.inetAddress.getHostAddress()));
            }
        }
        catch (Exception exception) {
            if (LOG.isEnabledFor(Priority.INFO)) {
                LOG.info((Object)("Bad address " + endpointAddress.toString()), (Throwable)exception);
            }
            throw new IOException("Bad address " + endpointAddress.toString());
        }
        this.tcpSocket = new TcpSocket(this.inetAddress, this.port);
    }

    private void connect() {
        TcpConnection tcpConnection = this;
        synchronized (tcpConnection) {
            if (this.queue == null) {
                this.queue = new EndpointReceiveQueue();
                this.queue.setMaxNbOfMessages(40);
            }
            if (this.thread != null) {
                return;
            }
            this.thread = new Thread((Runnable)this, "TCP Connection to " + this.dstAddrString + " [Unused]");
            this.thread.start();
        }
        Thread.yield();
    }

    private synchronized void setThreadName() {
        block3: {
            if (this.thread != null) {
                try {
                    this.thread.setName("TCP Connection to " + this.dstAddrString + " [" + this.queue.getNbOfQueuedMessages() + ", " + this.nbOfMessagesSent + ", " + (this.isConnected() ? "Connected" : "Disconnected") + " ]");
                }
                catch (Exception exception) {
                    if (!LOG.isEnabledFor(Priority.ERROR)) break block3;
                    LOG.error((Object)"Cannot change thread name", (Throwable)exception);
                }
            }
        }
    }

    public void sendMessage(Message message) throws IOException {
        if (this.tcpSocket.getSocket(5000L) == null) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("sendMessage() cannot get a socket for " + this.dstAddrString));
            }
            throw new IOException();
        }
        this.connect();
        TcpConnection tcpConnection = this;
        synchronized (tcpConnection) {
            this.queue.push(message);
            this.setThreadName();
        }
        Thread.yield();
    }

    public void run() {
        Message message = null;
        try {
            while (true) {
                if ((message = this.queue.waitForMessage()) == null) {
                    this.thread = null;
                    return;
                }
                this.setThreadName();
                this.doSendMessage(message);
            }
        }
        catch (InterruptedException interruptedException) {
            this.thread = null;
            return;
        }
        catch (IOException iOException) {
            this.notifyFailure();
            this.thread = null;
            return;
        }
    }

    private void doSendMessage(Message message) throws IOException {
        Object object;
        byte[] byArray;
        int n;
        if (this.dstAddress == null) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"sendMessage: no destination address");
            }
            throw new IOException();
        }
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"sendMessage");
        }
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("     to = " + this.dstAddress.toString()));
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        MessageWireFormatFactory.newMessageWireFormat(new MimeMediaType("application/x-jxta-msg")).writeMessage(byteArrayOutputStream, message);
        byteArrayOutputStream.close();
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2);
        Vector<byte[]> vector = new Vector<byte[]>();
        vector.addElement(new byte[Header.length]);
        int n2 = 0;
        int n3 = 4096;
        boolean bl = false;
        while (-1 != (n = byteArrayInputStream.read(byArray = new byte[n3]))) {
            if (0 == n) continue;
            if (n < n3) {
                object = new byte[n];
                System.arraycopy(byArray, 0, object, 0, n);
                byArray = object;
            }
            n2 += byArray.length;
            vector.addElement(byArray);
        }
        this.header.cmd = (byte)2;
        this.header.srcAddr = this.proto.usingInterface.getAddress();
        this.header.srcPort = this.proto.serverSocketPort;
        this.header.option = 2;
        this.header.size = n2;
        this.header.buildForNetwork((byte[])vector.elementAt(0), 0);
        int n4 = 0;
        while (n4 < 2) {
            Socket socket = this.tcpSocket.getSocket(5000L);
            if (socket == null) {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)("sendMessage() cannot get a socket for " + this.dstAddress.toString()));
                }
                throw new IOException();
            }
            try {
                int n5;
                object = socket.getOutputStream();
                InputStream inputStream = socket.getInputStream();
                if (n4 == 0) {
                    n5 = 1;
                    int n6 = inputStream.available();
                    while (n6-- > 0) {
                        n5 = inputStream.read();
                    }
                    if (n5 == 0) {
                        if (LOG.isEnabledFor(Priority.DEBUG)) {
                            LOG.debug((Object)"Other party wanted the connection closed.");
                        }
                        try {
                            ((OutputStream)object).close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        ((OutputStream)object).close();
                        inputStream.close();
                        this.tcpSocket.close();
                        socket = this.tcpSocket.getSocket(5000L);
                        if (socket == null) {
                            if (LOG.isEnabledFor(Priority.DEBUG)) {
                                LOG.debug((Object)("sendMessage cannot get socket for " + this.dstAddress.toString()));
                            }
                            throw new IOException();
                        }
                        object = socket.getOutputStream();
                        inputStream = socket.getInputStream();
                    }
                }
                n5 = 0;
                while (n5 < vector.size()) {
                    ((OutputStream)object).write((byte[])vector.elementAt(n5));
                    ++n5;
                }
                ((OutputStream)object).flush();
                this.setLastUsed(System.currentTimeMillis());
                bl = true;
                break;
            }
            catch (Exception exception) {
                ++n4;
                this.tcpSocket.close();
                if (!LOG.isEnabledFor(Priority.DEBUG)) continue;
                LOG.debug((Object)"sendMessage current socket is closed.");
            }
        }
        if (bl) {
            ++this.nbOfMessagesSent;
        } else {
            this.tcpSocket.setLastFailed(System.currentTimeMillis());
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"sendMessage failed - exit");
            }
            throw new IOException();
        }
        Thread.yield();
    }

    public void notifyActivity() {
        this.tcpSocket.notifyActivity();
    }

    private synchronized void notifyFailure() {
        this.close();
    }

    public synchronized void close() {
        block4: {
            this.tcpSocket.close();
            if (this.queue != null) {
                this.queue.close();
                this.queue = null;
            }
            if (this.thread != null) {
                try {
                    this.thread.interrupt();
                    this.thread = null;
                }
                catch (Exception exception) {
                    if (!LOG.isEnabledFor(Priority.WARN)) break block4;
                    LOG.warn((Object)("Cannot interrupt thread for " + this.dstAddrString), (Throwable)exception);
                }
            }
        }
    }

    public synchronized boolean isConnected() {
        Socket socket = this.tcpSocket.getSocket(1000L);
        return socket != null;
    }

    public synchronized long getLastUsed() {
        return this.lastUsed;
    }

    public synchronized void setLastUsed(long l) {
        this.lastUsed = l;
    }

    public void finalize() {
        this.close();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

