/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.servlethttp;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.HashMap;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.jxta.document.MimeMediaType;
import net.jxta.impl.endpoint.MessageImpl;
import net.jxta.impl.endpoint.MessageWireFormatFactory;
import net.jxta.impl.endpoint.servlethttp.HttpUtil;
import net.jxta.impl.endpoint.servlethttp.QueryString;
import net.jxta.impl.relay.RelayLease;
import net.jxta.impl.relay.RelayLeaseException;
import net.jxta.impl.relay.RelayServer;
import net.jxta.impl.util.BoundedQueue;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public class HttpRelayServlet
extends HttpServlet {
    private static final int BLOCK_WAIT_TIMEOUT = 60000;
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$endpoint$servlethttp$HttpRelayServlet == null ? (class$net$jxta$impl$endpoint$servlethttp$HttpRelayServlet = HttpRelayServlet.class$("net.jxta.impl.endpoint.servlethttp.HttpRelayServlet")) : class$net$jxta$impl$endpoint$servlethttp$HttpRelayServlet).getName());
    RelayServer relay = null;
    static /* synthetic */ Class class$net$jxta$impl$endpoint$servlethttp$HttpRelayServlet;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        try {
            this.relay = (RelayServer)this.getServletContext().getAttribute("relayServer");
            if (this.relay == null) {
                throw new ServletException("Servlet Context did not contain 'relayServer'");
            }
        }
        catch (ClassCastException classCastException) {
            throw new ServletException("'relayServer' attribute was not of the proper type in the Servlet Context");
        }
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        block7: {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"POST received");
                LOG.debug((Object)("  request length = " + httpServletRequest.getContentLength()));
            }
            String string = null;
            try {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"  try to read querystring");
                }
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)httpServletRequest.getInputStream()));
                string = bufferedReader.readLine();
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"  done reading querystring");
                }
                if (string != null) {
                    this.processCommand(string, httpServletResponse);
                } else {
                    httpServletResponse.sendError(400, "Problem reading request");
                }
            }
            catch (IOException iOException) {
                if (!LOG.isEnabledFor(Priority.DEBUG)) break block7;
                LOG.debug((Object)("Exception reading client request: " + iOException));
            }
        }
    }

    private void processCommand(String string, HttpServletResponse httpServletResponse) throws IOException {
        HashMap hashMap = QueryString.parse(string);
        Object[] objectArray = hashMap.keySet().toArray();
        String string2 = (String)hashMap.get("command");
        if (string2 == null) {
            throw new IOException("query string did not contain any commands ");
        }
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("   command: " + string2));
        }
        if (string2.equals("block")) {
            this.processBlock(hashMap, httpServletResponse);
        }
        if (string2.equals("poll")) {
            this.processPoll(hashMap, httpServletResponse);
        }
        if (string2.equals("obtainLease")) {
            this.processObtainLease(hashMap, httpServletResponse);
        }
        if (string2.equals("renewLease")) {
            this.processRenewLease(hashMap, httpServletResponse);
        }
    }

    private void processObtainLease(HashMap hashMap, HttpServletResponse httpServletResponse) throws IOException {
        String string = (String)hashMap.get("peerId");
        if (string == null) {
            throw new IOException("query string did not contain a clientPeerId ");
        }
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("Client trying to obtain lease: " + string));
        }
        if (string != null) {
            RelayLease relayLease = this.relay.issueNewLease(string);
            QueryString queryString = this.toQueryString(relayLease);
            queryString.add("peerId", this.relay.getPeerID().toString());
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("Granting lease to client: " + string));
            }
            this.sendOK(httpServletResponse, queryString.toString());
        } else {
            this.sendBadRequest(httpServletResponse, "peerId not specified");
        }
    }

    private void processRenewLease(HashMap hashMap, HttpServletResponse httpServletResponse) throws IOException {
        String string = (String)hashMap.get("leaseId");
        if (string == null) {
            throw new IOException("query string did not contain a leaseId ");
        }
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("Renewing lease; old lease id: " + string));
        }
        if (string != null) {
            try {
                RelayLease relayLease = this.relay.renewLease(string);
                QueryString queryString = this.toQueryString(relayLease);
                queryString.add("peerId", this.relay.getPeerID().toString());
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)("Renewed lease; response=" + queryString.toString()));
                }
                this.sendOK(httpServletResponse, queryString.toString());
            }
            catch (RelayLeaseException relayLeaseException) {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)("Lease not renewed; lease exception: " + relayLeaseException));
                }
                this.sendBadRequest(httpServletResponse, relayLeaseException.getMessage());
            }
        } else {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"Lease not renewed; leaseId not specified");
            }
            this.sendBadRequest(httpServletResponse, "leaseId not specified");
        }
    }

    private void processBlock(HashMap hashMap, HttpServletResponse httpServletResponse) throws IOException {
        String string = (String)hashMap.get("leaseId");
        if (string == null) {
            throw new IOException("query string did not contain a leaseId ");
        }
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("processBlock() for lease " + string));
        }
        if (string != null) {
            BoundedQueue boundedQueue = this.relay.getOutboundMessageQueueByLeaseId(string);
            if (boundedQueue != null) {
                MessageImpl messageImpl = null;
                try {
                    if (LOG.isEnabledFor(Priority.DEBUG)) {
                        LOG.debug((Object)("trying to dequeue message for lease " + string));
                    }
                    messageImpl = (MessageImpl)boundedQueue.dequeue(60000L);
                }
                catch (InterruptedException interruptedException) {
                    if (LOG.isEnabledFor(Priority.DEBUG)) {
                        LOG.debug((Object)"No message dequeued; sending blank 200");
                    }
                    this.sendOK(httpServletResponse);
                }
                if (messageImpl != null) {
                    if (LOG.isEnabledFor(Priority.DEBUG)) {
                        LOG.debug((Object)("Relay sending message back for lease " + string));
                    }
                    this.sendMessage(httpServletResponse, messageImpl);
                } else {
                    if (LOG.isEnabledFor(Priority.DEBUG)) {
                        LOG.debug((Object)("Relay dequeued no msg, sending OK for lease " + string));
                    }
                    this.sendOK(httpServletResponse);
                }
            } else {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)("No queue associate with lease (probably an invalid lease): " + string));
                }
                this.sendBadRequest(httpServletResponse, "Invalid lease specified");
            }
        } else {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"No lease specified");
            }
            this.sendBadRequest(httpServletResponse, "No lease specified");
        }
    }

    private void processPoll(HashMap hashMap, HttpServletResponse httpServletResponse) throws IOException {
        this.sendBadRequest(httpServletResponse, "Not implemented");
    }

    private void sendBadRequest(HttpServletResponse httpServletResponse, String string) throws IOException {
        httpServletResponse.sendError(400, string);
    }

    private void sendMessage(HttpServletResponse httpServletResponse, MessageImpl messageImpl) throws IOException {
        httpServletResponse.setStatus(200);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        MessageWireFormatFactory.newMessageWireFormat(new MimeMediaType("application/x-jxta-msg")).writeMessage(byteArrayOutputStream, messageImpl);
        httpServletResponse.setContentLength(byteArrayOutputStream.size());
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("sendMessage() preparing; content-length = " + byteArrayOutputStream.size()));
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        HttpUtil.transfer(byteArrayInputStream, (OutputStream)servletOutputStream);
        servletOutputStream.flush();
        servletOutputStream.close();
    }

    private void sendOK(HttpServletResponse httpServletResponse, String string) throws IOException {
        httpServletResponse.setStatus(200);
        byte[] byArray = (string + "\r\n").getBytes();
        httpServletResponse.setContentLength(byArray.length);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream((OutputStream)httpServletResponse.getOutputStream());
        ((OutputStream)bufferedOutputStream).write(byArray);
        ((OutputStream)bufferedOutputStream).flush();
        ((OutputStream)bufferedOutputStream).close();
    }

    private void sendOK(HttpServletResponse httpServletResponse) throws IOException {
        httpServletResponse.setStatus(200);
        httpServletResponse.setContentLength(0);
    }

    private QueryString toQueryString(RelayLease relayLease) {
        QueryString queryString = new QueryString();
        queryString.add("leaseLength", Integer.toString(relayLease.getLeaseLength()));
        queryString.add("leaseId", relayLease.getLeaseId());
        return queryString;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

