/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.servlethttp;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import net.jxta.document.MimeMediaType;
import net.jxta.endpoint.EndpointService;
import net.jxta.endpoint.Message;
import net.jxta.impl.endpoint.MessageWireFormatFactory;
import net.jxta.impl.endpoint.servlethttp.MessageReceiver;
import net.jxta.impl.endpoint.servlethttp.QueryString;
import net.jxta.impl.relay.AbstractRelayClient;
import net.jxta.impl.relay.RelayLeaseException;
import net.jxta.peergroup.PeerGroup;
import net.jxta.protocol.TransportAdvertisement;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public class HttpRelayClientMessageReceiver
extends AbstractRelayClient
implements MessageReceiver {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$endpoint$servlethttp$HttpRelayClientMessageReceiver == null ? (class$net$jxta$impl$endpoint$servlethttp$HttpRelayClientMessageReceiver = HttpRelayClientMessageReceiver.class$("net.jxta.impl.endpoint.servlethttp.HttpRelayClientMessageReceiver")) : class$net$jxta$impl$endpoint$servlethttp$HttpRelayClientMessageReceiver).getName());
    private static Timer pollTimer = null;
    private static final int MODE_POLL = 0;
    private static final int MODE_BLOCK = 1;
    private static final int POLL_INTERVAL = 15000;
    private static final int BLOCK_TIMEOUT = 60000;
    private static final int BLOCK_RETRY_INTERVAL = 15000;
    private static final int COMMAND_TIMEOUT = 20000;
    URL url = null;
    EndpointService endpoint = null;
    PeerGroup group = null;
    private int requestMode = 1;
    private BlockingMessageReceiver blockingReceiver = null;
    private Thread receiverThread = null;
    private PollingMessageReceiverTask pollingTask = null;
    static /* synthetic */ Class class$net$jxta$impl$endpoint$servlethttp$HttpRelayClientMessageReceiver;

    public HttpRelayClientMessageReceiver(URL uRL) {
        if (uRL == null) {
            throw new IllegalArgumentException("HttpRelayClientMessageReceiver cannot be configured with a null url");
        }
        this.url = uRL;
    }

    public void init(PeerGroup peerGroup, EndpointService endpointService, TransportAdvertisement transportAdvertisement) throws IOException {
        this.endpoint = endpointService;
        this.group = peerGroup;
    }

    public boolean obtainLease() {
        boolean bl;
        block3: {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("Trying to obtain lease to relay: " + this.url));
            }
            String string = this.group.getPeerID().getUniqueValue().toString();
            QueryString queryString = new QueryString();
            queryString.add("command", "obtainLease");
            queryString.add("peerId", string);
            bl = false;
            try {
                HttpURLConnection httpURLConnection = this.postCommand(queryString.toString(), 20000);
                bl = this.processLeaseResponse(httpURLConnection);
                httpURLConnection.disconnect();
            }
            catch (Exception exception) {
                if (!LOG.isEnabledFor(Priority.INFO)) break block3;
                LOG.info((Object)("Exception during lease request: " + exception));
            }
        }
        return bl;
    }

    public boolean renewLease() {
        boolean bl;
        block3: {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("Trying to renew lease to relay: " + this.url));
            }
            QueryString queryString = new QueryString();
            queryString.add("command", "renewLease");
            queryString.add("leaseId", this.getLeaseId());
            bl = false;
            try {
                HttpURLConnection httpURLConnection = this.postCommand(queryString.toString(), 20000);
                bl = this.processLeaseResponse(httpURLConnection);
                httpURLConnection.disconnect();
            }
            catch (Exception exception) {
                if (!LOG.isEnabledFor(Priority.INFO)) break block3;
                LOG.info((Object)("Exception during lease renewal request: " + exception));
            }
        }
        return bl;
    }

    private boolean processLeaseResponse(HttpURLConnection httpURLConnection) throws IOException {
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"processing lease response");
        }
        boolean bl = false;
        if (httpURLConnection.getResponseCode() == 200) {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));
            String string = bufferedReader.readLine();
            HashMap hashMap = QueryString.parse(string);
            String string2 = (String)hashMap.get("peerId");
            String string3 = (String)hashMap.get("leaseId");
            String string4 = (String)hashMap.get("mode");
            Integer n = this.extractInteger(hashMap, "leaseLength");
            if (string2 != null && string3 != null && n != null) {
                this.requestMode = string4 != null && string4.equals("poll") ? 0 : 1;
                this.recordLease(string2, string3, n);
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"Successfully renewed lease");
                }
                bl = true;
            } else if (LOG.isEnabledFor(Priority.INFO)) {
                LOG.info((Object)"Could not renew lease; relay server did not return proper information");
            }
        } else if (LOG.isEnabledFor(Priority.INFO)) {
            LOG.info((Object)("Could not renew lease; Invalid HTTP response code from relay server: " + this.url));
        }
        return bl;
    }

    public void onLeaseObtained() {
        if (this.requestMode == 1) {
            if (this.blockingReceiver == null) {
                if (this.pollingTask != null) {
                    if (LOG.isEnabledFor(Priority.DEBUG)) {
                        LOG.debug((Object)"stopping polling task");
                    }
                    this.pollingTask.cancel();
                    this.pollingTask = null;
                }
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"starting blocking receiver");
                }
                this.blockingReceiver = new BlockingMessageReceiver();
                this.receiverThread = new Thread((Runnable)this.blockingReceiver, "BlockingMessageReceiver");
                this.receiverThread.setDaemon(true);
                this.receiverThread.start();
            }
        } else if (this.requestMode == 0 && this.pollingTask == null) {
            if (this.receiverThread != null) {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"stopping blocking receiver");
                }
                this.blockingReceiver.stop();
                this.receiverThread.interrupt();
                this.blockingReceiver = null;
                this.receiverThread = null;
            }
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"starting polling task");
            }
            if (pollTimer == null) {
                pollTimer = new Timer(true);
            }
            this.pollingTask = new PollingMessageReceiverTask();
            pollTimer.schedule((TimerTask)this.pollingTask, 0L, 15000L);
        }
    }

    public void stop() throws InterruptedException {
        super.stop();
        AbstractRelayClient.timer.cancel();
        if (this.blockingReceiver != null) {
            this.blockingReceiver.stop();
        }
    }

    public String toString() {
        return "HttpRelayClientMessageReceiver connected to " + this.url;
    }

    private HttpURLConnection postCommand(String string, int n) throws IOException, InterruptedException {
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("posting command to relay " + this.url + ": " + string));
        }
        HttpURLConnection httpURLConnection = (HttpURLConnection)this.url.openConnection();
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setRequestMethod("POST");
        httpURLConnection.setAllowUserInteraction(false);
        httpURLConnection.setRequestProperty("Content-Length", Integer.toString(string.length()));
        httpURLConnection.connect();
        PrintWriter printWriter = new PrintWriter(httpURLConnection.getOutputStream());
        printWriter.println(string);
        printWriter.flush();
        printWriter.close();
        return httpURLConnection;
    }

    Integer extractInteger(HashMap hashMap, String string) {
        String string2 = (String)hashMap.get(string);
        if (string2 == null) {
            return null;
        }
        try {
            Integer n = new Integer(string2);
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("Relay misbheaving; reported non-integer for: " + string));
            }
            return null;
        }
    }

    private void processRelayedMessage(HttpURLConnection httpURLConnection) throws IOException {
        int n;
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"processing relayed message");
        }
        if ((n = httpURLConnection.getContentLength()) < 0) {
            throw new IOException("Content-length must be specified");
        }
        InputStream inputStream = httpURLConnection.getInputStream();
        try {
            Message message = this.endpoint.newMessage();
            MessageWireFormatFactory.newMessageWireFormat(new MimeMediaType("application/x-jxta-msg")).readMessage(inputStream, message);
            this.endpoint.demux(message);
            Thread.yield();
        }
        catch (IOException iOException) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"Error reading message ");
            }
            throw iOException;
        }
    }

    private int read(InputStream inputStream, byte[] byArray, int n) throws IOException {
        int n2;
        int n3 = 0;
        while ((n2 = inputStream.read(byArray, n3, n - n3)) > -1) {
            n3 += n2;
        }
        return n3;
    }

    private QueryString getLeaseIdQueryString() throws RelayLeaseException {
        QueryString queryString = new QueryString();
        String string = this.getLeaseId();
        if (string != null) {
            queryString.add("leaseId", this.getLeaseId());
            return queryString;
        }
        throw new RelayLeaseException("Lease expired");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class PollingMessageReceiverTask
    extends TimerTask {
        private PollingMessageReceiverTask() {
        }

        public void run() {
            block7: {
                try {
                    QueryString queryString = HttpRelayClientMessageReceiver.this.getLeaseIdQueryString();
                    queryString.add("command", "poll");
                    String string = queryString.toString();
                    HttpURLConnection httpURLConnection = HttpRelayClientMessageReceiver.this.postCommand(string, 15000);
                    if (httpURLConnection.getResponseCode() == 200) {
                        HttpRelayClientMessageReceiver.this.processRelayedMessage(httpURLConnection);
                    }
                    httpURLConnection.disconnect();
                }
                catch (RelayLeaseException relayLeaseException) {
                    HttpRelayClientMessageReceiver.this.lostLease();
                }
                catch (FileNotFoundException fileNotFoundException) {
                    HttpRelayClientMessageReceiver.this.lostLease();
                }
                catch (IOException iOException) {
                    if (LOG.isEnabledFor(Priority.DEBUG)) {
                        LOG.debug((Object)("IOException during poll request to relay: " + iOException));
                    }
                }
                catch (InterruptedException interruptedException) {
                    if (!LOG.isEnabledFor(Priority.DEBUG)) break block7;
                    LOG.debug((Object)"InterruptedException while polling");
                }
            }
        }
    }

    private class BlockingMessageReceiver
    implements Runnable {
        boolean isRunning = true;

        private BlockingMessageReceiver() {
        }

        void stop() {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("Trying to stop: " + HttpRelayClientMessageReceiver.this.url));
            }
            this.isRunning = false;
        }

        public void run() {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"BlockingMessageReceiver starting");
            }
            while (this.isRunning) {
                try {
                    QueryString queryString = HttpRelayClientMessageReceiver.this.getLeaseIdQueryString();
                    queryString.add("command", "block");
                    String string = queryString.toString();
                    if (LOG.isEnabledFor(Priority.DEBUG)) {
                        LOG.debug((Object)("POSTing block command to relay: " + HttpRelayClientMessageReceiver.this.url));
                    }
                    HttpURLConnection httpURLConnection = HttpRelayClientMessageReceiver.this.postCommand(string, 60000);
                    if (this.isRunning) {
                        int n = httpURLConnection.getResponseCode();
                        if (LOG.isEnabledFor(Priority.DEBUG)) {
                            LOG.debug((Object)("response code == " + n));
                        }
                        if (n == 200) {
                            if (httpURLConnection.getContentLength() == 0) {
                                if (LOG.isEnabledFor(Priority.DEBUG)) {
                                    LOG.debug((Object)"Relayed sent back no message");
                                }
                            } else {
                                HttpRelayClientMessageReceiver.this.processRelayedMessage(httpURLConnection);
                            }
                        } else {
                            if (LOG.isEnabledFor(Priority.DEBUG)) {
                                LOG.debug((Object)"Non-OK response code from relay; waiting for interval: 15000");
                            }
                            Thread.sleep(15000L);
                        }
                    }
                    httpURLConnection.disconnect();
                }
                catch (FileNotFoundException fileNotFoundException) {
                    if (LOG.isEnabledFor(Priority.DEBUG)) {
                        LOG.debug((Object)("Exception during relay request: " + fileNotFoundException));
                    }
                    HttpRelayClientMessageReceiver.this.lostLease();
                    try {
                        Thread.sleep(15000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                catch (IOException iOException) {
                    if (LOG.isEnabledFor(Priority.DEBUG)) {
                        LOG.debug((Object)("IOException during relay request: " + iOException));
                    }
                    try {
                        Thread.sleep(15000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                catch (RelayLeaseException relayLeaseException) {
                    if (LOG.isEnabledFor(Priority.DEBUG)) {
                        LOG.debug((Object)"Exception: Lease is invalid");
                    }
                    HttpRelayClientMessageReceiver.this.lostLease();
                    try {
                        Thread.sleep(15000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                catch (Throwable throwable) {
                    if (LOG.isEnabledFor(Priority.DEBUG)) {
                        LOG.debug((Object)("Throwable caught during blocking request to relay; waiting for an interval: " + throwable));
                    }
                    try {
                        Thread.sleep(15000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

