/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.servlethttp;

import java.io.IOException;
import java.net.URL;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointMessenger;
import net.jxta.endpoint.Message;
import net.jxta.impl.endpoint.servlethttp.HttpClientConnection;
import net.jxta.impl.endpoint.servlethttp.HttpClientMessageSender;

public class HttpClientMessenger
implements EndpointMessenger {
    private URL url = null;
    private HttpClientMessageSender sender = null;
    private EndpointAddress destAddress = null;
    private EndpointAddress localAddress = null;

    public HttpClientMessenger(HttpClientMessageSender httpClientMessageSender, URL uRL, EndpointAddress endpointAddress, EndpointAddress endpointAddress2) throws IOException {
        this.sender = httpClientMessageSender;
        this.url = uRL;
        this.destAddress = (EndpointAddress)endpointAddress2.clone();
        this.localAddress = (EndpointAddress)endpointAddress.clone();
        HttpClientConnection httpClientConnection = httpClientMessageSender.getHttpClientConnection(uRL);
        if (httpClientConnection == null) {
            throw new IOException();
        }
    }

    public void sendMessage(Message message) throws IOException {
        message.setDestinationAddress(this.destAddress);
        message.setSourceAddress(this.localAddress);
        HttpClientConnection httpClientConnection = this.sender.getHttpClientConnection(this.url);
        if (httpClientConnection == null) {
            throw new IOException();
        }
        httpClientConnection.sendMessage(message);
    }

    public void close() {
    }
}

