/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.servlethttp;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Timer;
import java.util.TimerTask;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointMessenger;
import net.jxta.endpoint.Message;
import net.jxta.impl.endpoint.servlethttp.HttpClientConnection;
import net.jxta.impl.endpoint.servlethttp.HttpClientMessenger;
import net.jxta.impl.endpoint.servlethttp.MessageSender;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public class HttpClientMessageSender
implements MessageSender {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$endpoint$servlethttp$HttpClientMessageSender == null ? (class$net$jxta$impl$endpoint$servlethttp$HttpClientMessageSender = HttpClientMessageSender.class$("net.jxta.impl.endpoint.servlethttp.HttpClientMessageSender")) : class$net$jxta$impl$endpoint$servlethttp$HttpClientMessageSender).getName());
    private EndpointAddress localAddress = null;
    private static final long HttpClientConnectionGCDelay = 3600000L;
    private Timer HttpClientConnectionGCTimer = new Timer();
    private Hashtable openConnections = new Hashtable();
    static /* synthetic */ Class class$net$jxta$impl$endpoint$servlethttp$HttpClientMessageSender;

    public HttpClientMessageSender(EndpointAddress endpointAddress) {
        this.localAddress = endpointAddress;
        this.HttpClientConnectionGCTimer.scheduleAtFixedRate((TimerTask)new HttpClientConnectionGCTask(this), 3600000L, 3600000L);
    }

    public EndpointMessenger getMessenger(EndpointAddress endpointAddress) throws IOException {
        String string = endpointAddress.getProtocolName() + "://" + endpointAddress.getProtocolAddress() + "/";
        return new HttpClientMessenger(this, new URL(string), this.localAddress, endpointAddress);
    }

    public void propagate(Message message, String string, String string2, String string3) throws IOException {
    }

    public boolean ping(EndpointAddress endpointAddress) {
        if (endpointAddress.getProtocolAddress().indexOf("JxtaHttpClient") != -1) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"Ping of relay client: always false");
            }
            return false;
        }
        boolean bl = false;
        String string = null;
        try {
            string = "http://" + endpointAddress.getProtocolAddress() + "/ping";
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("Trying to ping " + string));
            }
            URL uRL = new URL(string);
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setRequestMethod("GET");
            httpURLConnection.connect();
            int n = httpURLConnection.getResponseCode();
            if (n == 200) {
                bl = true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("Ping result to " + string + ": " + bl));
        }
        return bl;
    }

    private synchronized void registerHttpClientConnection(URL uRL, HttpClientConnection httpClientConnection) {
        HttpClientConnection httpClientConnection2;
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("Register connection to " + uRL.toString()));
        }
        if ((httpClientConnection2 = this.openConnections.put(uRL.toString(), httpClientConnection)) != null) {
            httpClientConnection2.close();
        }
    }

    private synchronized void unregisterHttpClientConnection(URL uRL) {
        HttpClientConnection httpClientConnection = (HttpClientConnection)this.openConnections.remove(uRL.toString());
        if (httpClientConnection != null) {
            httpClientConnection.close();
        }
    }

    public synchronized HttpClientConnection getHttpClientConnection(URL uRL) {
        HttpClientConnection httpClientConnection = null;
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("Looking connection to " + uRL.toString()));
        }
        if ((httpClientConnection = (HttpClientConnection)this.openConnections.get(uRL.toString())) == null) {
            try {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)("Creating new connection to " + uRL.toString()));
                }
                httpClientConnection = new HttpClientConnection(uRL);
                this.registerHttpClientConnection(uRL, httpClientConnection);
            }
            catch (Exception exception) {
                return null;
            }
        } else if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("Reusing existing connection to " + uRL.toString()));
        }
        httpClientConnection.setLastUsed(System.currentTimeMillis());
        return httpClientConnection;
    }

    protected void httpConnectionGC() {
        Enumeration enumeration;
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"HttpClientConnectionGC starts");
        }
        if ((enumeration = this.openConnections.keys()) == null || !enumeration.hasMoreElements()) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"HttpClientConnectionGC: no connection. Nothing to do.");
            }
            return;
        }
        HttpClientConnection httpClientConnection = null;
        long l = 0L;
        long l2 = 0L;
        String string = null;
        while (enumeration.hasMoreElements()) {
            try {
                string = (String)enumeration.nextElement();
                httpClientConnection = (HttpClientConnection)this.openConnections.get(string);
                HttpClientMessageSender httpClientMessageSender = this;
                synchronized (httpClientMessageSender) {
                    if (httpClientConnection == null) {
                        continue;
                    }
                    l = httpClientConnection.getLastUsed();
                    l2 = System.currentTimeMillis();
                    if (l2 - l >= 3600000L) {
                        httpClientConnection.close();
                        this.openConnections.remove(string);
                        if (LOG.isEnabledFor(Priority.DEBUG)) {
                            LOG.debug((Object)("HttpClientConnectionGC removes unused connection to " + string));
                        }
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"HttpClientConnectionGC completed.");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class HttpClientConnectionGCTask
    extends TimerTask {
        HttpClientMessageSender sender = null;

        public HttpClientConnectionGCTask(HttpClientMessageSender httpClientMessageSender2) {
            this.sender = httpClientMessageSender2;
        }

        public void run() {
            this.sender.httpConnectionGC();
        }
    }
}

