/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import net.jxta.document.Attribute;
import net.jxta.document.MimeMediaType;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.endpoint.MessageElementEnumeration;
import net.jxta.impl.document.LiteXMLDocument;
import net.jxta.impl.document.LiteXMLElement;
import net.jxta.impl.endpoint.MessageImpl;
import net.jxta.impl.endpoint.MessageWireFormat;
import net.jxta.impl.endpoint.MessageWireFormatFactory;
import net.jxta.impl.util.Base64;

public class MessageWireFormatXML
extends MessageWireFormat {
    protected static final String MESSAGE_VERSION = "0";
    protected static final MimeMediaType outputMimeType = new MimeMediaType("text/xml");
    MimeMediaType type;

    public static MimeMediaType getOutputMimeType() {
        return (MimeMediaType)outputMimeType.clone();
    }

    public MessageWireFormatXML(MimeMediaType mimeMediaType) {
        this.type = mimeMediaType;
    }

    public void writeMessage(OutputStream outputStream, Message message) throws IOException {
        LiteXMLDocument liteXMLDocument = new LiteXMLDocument(new MimeMediaType("text/xml"), "Message");
        liteXMLDocument.addAttribute("version", MESSAGE_VERSION);
        MessageElementEnumeration messageElementEnumeration = ((MessageImpl)message).getElementsInFifoOrder();
        while (messageElementEnumeration.hasMoreElements()) {
            MessageElement messageElement = (MessageElement)messageElementEnumeration.nextElement();
            this.writeMessageElement(liteXMLDocument, messageElement);
        }
        liteXMLDocument.sendToStream(outputStream);
    }

    public void readMessage(InputStream inputStream, Message message) throws IOException {
        LiteXMLDocument liteXMLDocument = new LiteXMLDocument(new MimeMediaType("text/xml"), inputStream);
        if (!"Message".equals(liteXMLDocument.getName())) {
            throw new IOException("Document element is not named Message.");
        }
        Attribute attribute = liteXMLDocument.getAttribute("version");
        if (attribute == null) {
            throw new IOException("Missing Message version");
        }
        String string = attribute.getValue();
        if (!string.equals(MESSAGE_VERSION)) {
            throw new IOException("Can not handle message version " + string + ", expected " + MESSAGE_VERSION);
        }
        Enumeration enumeration = liteXMLDocument.getChildren();
        while (enumeration.hasMoreElements()) {
            LiteXMLElement liteXMLElement = (LiteXMLElement)enumeration.nextElement();
            this.readMessageElement(message, liteXMLElement);
        }
    }

    private void readMessageElement(Message message, LiteXMLElement liteXMLElement) throws IOException {
        Attribute attribute = liteXMLElement.getAttribute("name");
        if (attribute == null) {
            throw new IOException("Missing name attribute in message element");
        }
        String string = attribute.getValue();
        attribute = liteXMLElement.getAttribute("mime_type");
        if (attribute == null) {
            throw new IOException("Missing mime_type for " + string);
        }
        String string2 = attribute.getValue();
        attribute = liteXMLElement.getAttribute("encoding");
        String string3 = attribute == null ? null : attribute.getValue();
        String string4 = liteXMLElement.getTextValue();
        byte[] byArray = string3 != null && string3.equals("base64") ? Base64.decodeBase64(string4) : string4.getBytes();
        MessageElement messageElement = message.newMessageElement(string, new MimeMediaType(string2), byArray, 0, byArray.length);
        message.addElement(messageElement);
    }

    private void writeMessageElement(LiteXMLDocument liteXMLDocument, MessageElement messageElement) {
        String string;
        String string2 = null;
        byte[] byArray = messageElement.getBytesOffset();
        int n = messageElement.getOffset();
        int n2 = messageElement.getLength();
        MimeMediaType mimeMediaType = messageElement.getType();
        if (mimeMediaType == null) {
            mimeMediaType = new MimeMediaType("application/octet-stream");
        }
        if (mimeMediaType.getType().equals("text")) {
            string = new String(byArray, n, n2);
        } else {
            string = Base64.encodeBase64(byArray);
            string2 = "base64";
        }
        LiteXMLElement liteXMLElement = (LiteXMLElement)liteXMLDocument.createElement("Element", string);
        liteXMLDocument.appendChild(liteXMLElement);
        liteXMLElement.addAttribute("name", messageElement.getName());
        if (string2 != null) {
            liteXMLElement.addAttribute("encoding", string2);
        }
        liteXMLElement.addAttribute("mime_type", mimeMediaType.getMimeMediaType());
    }

    public static class Instantiator
    implements MessageWireFormatFactory.Instantiator {
        public MimeMediaType getOutputMimeType() {
            return MessageWireFormatXML.getOutputMimeType();
        }

        public MessageWireFormat newInstance(MimeMediaType mimeMediaType) {
            return new MessageWireFormatXML(mimeMediaType);
        }
    }
}

