/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import net.jxta.document.MimeMediaType;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.endpoint.MessageElementEnumeration;
import net.jxta.impl.endpoint.Address;
import net.jxta.impl.endpoint.MessageElementEnumerationImpl;
import net.jxta.impl.endpoint.MessageElementImpl;
import net.jxta.util.StringEnumeration;

public class MessageImpl
implements Message {
    private Hashtable namespace2elements = new Hashtable();
    Vector order = new Vector();
    public boolean filtered = false;

    public MessageElement newMessageElement(String string, MimeMediaType mimeMediaType, InputStream inputStream) throws IOException {
        return new MessageElementImpl(string, mimeMediaType, inputStream, -1);
    }

    public MessageElement newMessageElement(String string, MimeMediaType mimeMediaType, InputStream inputStream, int n) throws IOException {
        return new MessageElementImpl(string, mimeMediaType, inputStream, n);
    }

    public MessageElement newMessageElement(String string, MimeMediaType mimeMediaType, byte[] byArray, int n, int n2) {
        return new MessageElementImpl(string, mimeMediaType, byArray, n, n2);
    }

    public MessageElement newMessageElement(String string, MimeMediaType mimeMediaType, byte[] byArray) {
        return new MessageElementImpl(string, mimeMediaType, byArray, 0, byArray.length);
    }

    public boolean removeElement(MessageElement messageElement) {
        String string = messageElement.getName();
        if (string == null) {
            throw new RuntimeException("Element has null name");
        }
        return this.removeElement(string) != null;
    }

    public MessageElement removeElement(String string) {
        String[] stringArray = MessageElement.parseName(string);
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        Hashtable hashtable = (Hashtable)this.namespace2elements.get(string2);
        if (hashtable == null) {
            return null;
        }
        MessageElement messageElement = (MessageElement)hashtable.get(string3);
        if (messageElement == null) {
            return null;
        }
        hashtable.remove(string3);
        this.order.remove(messageElement);
        if (hashtable.size() == 0) {
            this.namespace2elements.remove(string2);
        }
        return messageElement;
    }

    public byte[] getBytes(String string) {
        byte[] byArray = null;
        MessageElement messageElement = this.getElement(string);
        if (messageElement != null) {
            byArray = messageElement.getBytesOffset();
            int n = messageElement.getOffset();
            if (n != 0) {
                byte[] byArray2 = byArray;
                byArray = new byte[messageElement.getLength()];
                System.arraycopy(byArray2, messageElement.getOffset(), byArray, 0, messageElement.getLength());
            }
        }
        return byArray;
    }

    public void setBytes(String string, byte[] byArray) {
        this.setBytes(string, byArray, 0, byArray.length);
    }

    public void setBytes(String string, byte[] byArray, int n, int n2) {
        MessageElement messageElement = this.getElement(string);
        if (messageElement != null) {
            this.removeElement(string);
        }
        messageElement = this.newMessageElement(string, null, byArray, n, n2);
        this.addElement(messageElement);
    }

    public Enumeration getNamespaces() {
        return this.namespace2elements.keys();
    }

    public boolean hasElement(String string) {
        return this.getElement(string) != null;
    }

    public MessageElement getElement(String string) {
        String[] stringArray = MessageElement.parseName(string);
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        Hashtable hashtable = (Hashtable)this.namespace2elements.get(string2);
        if (hashtable == null) {
            return null;
        }
        return (MessageElement)hashtable.get(string3);
    }

    public void addElement(MessageElement messageElement) {
        String[] stringArray = MessageElement.parseName(messageElement.getName());
        String string = stringArray[0];
        String string2 = stringArray[1];
        MessageElement messageElement2 = this.getElement(messageElement.getName());
        if (messageElement2 != null) {
            int n = this.order.indexOf(messageElement2);
            this.order.setElementAt(messageElement, n);
        } else {
            this.order.addElement(messageElement);
        }
        Hashtable<String, MessageElement> hashtable = (Hashtable<String, MessageElement>)this.namespace2elements.get(string);
        if (hashtable == null) {
            hashtable = new Hashtable<String, MessageElement>();
            this.namespace2elements.put(string, hashtable);
        }
        hashtable.put(string2, messageElement);
    }

    public MessageElementEnumeration getElements() {
        return this.getElementsInLifoOrder();
    }

    public MessageElementEnumeration getElementsInFifoOrder() {
        return new MessageElementEnumerationImpl(this.order.elements());
    }

    public MessageElementEnumeration getElementsInLifoOrder() {
        Vector vector = new Vector();
        Enumeration enumeration = this.order.elements();
        while (enumeration.hasMoreElements()) {
            vector.add(0, enumeration.nextElement());
        }
        return new MessageElementEnumerationImpl(vector.elements());
    }

    public StringEnumeration getNames() {
        return new StringEnumeration(new Enumeration(){
            private Enumeration elements;
            {
                this.elements = MessageImpl.this.getElementsInLifoOrder();
            }

            public boolean hasMoreElements() {
                return this.elements.hasMoreElements();
            }

            public Object nextElement() {
                MessageElement messageElement = (MessageElement)this.elements.nextElement();
                return messageElement.getName();
            }
        });
    }

    public MessageElementEnumeration getElements(final String string) {
        return new MessageElementEnumerationImpl(new Enumeration(){
            private Hashtable elementsTable;
            private Enumeration elements;
            {
                this.elementsTable = (Hashtable)MessageImpl.this.namespace2elements.get(string);
                this.elements = this.elementsTable == null ? null : this.elementsTable.elements();
            }

            public boolean hasMoreElements() {
                return this.elements != null && this.elements.hasMoreElements();
            }

            public Object nextElement() {
                if (this.elements == null || !this.elements.hasMoreElements()) {
                    return null;
                }
                return this.elements.nextElement();
            }
        });
    }

    public Object clone() {
        MessageImpl messageImpl = new MessageImpl();
        MessageElementEnumeration messageElementEnumeration = this.getElements();
        while (messageElementEnumeration.hasMoreElements()) {
            MessageElement messageElement = (MessageElement)messageElementEnumeration.nextElement();
            messageImpl.addElement(messageElement);
        }
        return messageImpl;
    }

    public boolean equals(Object object) {
        Message message = (Message)object;
        MessageElementEnumeration messageElementEnumeration = this.getElements();
        MessageElementEnumeration messageElementEnumeration2 = message.getElements();
        while (messageElementEnumeration.hasMoreElements()) {
            MessageElement messageElement;
            if (!messageElementEnumeration2.hasMoreElements()) {
                return false;
            }
            MessageElement messageElement2 = messageElementEnumeration.nextMessageElement();
            if (messageElement2.equals(messageElement = messageElementEnumeration2.nextMessageElement())) continue;
            return false;
        }
        return !messageElementEnumeration2.hasMoreElements();
    }

    public EndpointAddress getSourceAddress() {
        Address address = null;
        byte[] byArray = this.getBytes("jxta:EndpointSourceAddress");
        if (byArray != null) {
            address = new Address(byArray);
        }
        return address;
    }

    public EndpointAddress getDestinationAddress() {
        Address address = null;
        byte[] byArray = this.getBytes("jxta:EndpointDestinationAddress");
        if (byArray != null) {
            address = new Address(byArray);
        }
        return address;
    }

    public void setSourceAddress(EndpointAddress endpointAddress) {
        this.setBytes("jxta:EndpointSourceAddress", endpointAddress.toString().getBytes());
    }

    public void setDestinationAddress(EndpointAddress endpointAddress) {
        this.setBytes("jxta:EndpointDestinationAddress", endpointAddress.toString().getBytes());
    }

    public void setString(String string, String string2) {
        this.setBytes(string, string2.getBytes());
    }

    public String getString(String string) {
        byte[] byArray = this.getBytes(string);
        if (byArray == null) {
            return null;
        }
        return new String(byArray);
    }
}

