/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import net.jxta.document.Advertisement;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.TextElement;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointFilterListener;
import net.jxta.endpoint.EndpointListener;
import net.jxta.endpoint.EndpointMessenger;
import net.jxta.endpoint.EndpointProtocol;
import net.jxta.endpoint.EndpointService;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.exception.PeerGroupException;
import net.jxta.id.ID;
import net.jxta.impl.endpoint.Address;
import net.jxta.impl.endpoint.EndpointDemuxListener;
import net.jxta.impl.endpoint.EndpointServiceInterface;
import net.jxta.impl.endpoint.MessageImpl;
import net.jxta.impl.peergroup.RefPeerGroup;
import net.jxta.peergroup.PeerGroup;
import net.jxta.protocol.ModuleImplAdvertisement;
import net.jxta.protocol.PeerAdvertisement;
import net.jxta.service.Service;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public class EndpointServiceImpl
implements EndpointService {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$endpoint$EndpointServiceImpl == null ? (class$net$jxta$impl$endpoint$EndpointServiceImpl = EndpointServiceImpl.class$("net.jxta.impl.endpoint.EndpointServiceImpl")) : class$net$jxta$impl$endpoint$EndpointServiceImpl).getName());
    private Hashtable protocols = new Hashtable();
    private Hashtable listeners = new Hashtable();
    private Hashtable incomingFilterListeners = new Hashtable();
    private Hashtable outgoingFilterListeners = new Hashtable();
    private EndpointService parentEndpoint = null;
    private boolean runRouter = true;
    private boolean routerInitialized = false;
    private Advertisement implAdv = null;
    private ID assignedID = null;
    private PeerGroup group = null;
    private String localPeerId = null;
    private Hashtable inboundTraffic = new Hashtable();
    private Hashtable outboundTraffic = new Hashtable();
    private int lastMessageSentAt = 0;
    private int lastMessageRecdAt = 0;
    private boolean isTrafficRecordingEnabled = false;
    private static final String EndpointHeaderSrcPeer = "jxta:EndpointHeaderSrcPeer";
    static /* synthetic */ Class class$net$jxta$impl$endpoint$EndpointServiceImpl;

    public Service getInterface() {
        return new EndpointServiceInterface(this);
    }

    public Advertisement getImplAdvertisement() {
        return this.implAdv;
    }

    public void init(PeerGroup peerGroup, ID iD, Advertisement advertisement) throws PeerGroupException {
        this.implAdv = (ModuleImplAdvertisement)advertisement;
        this.assignedID = iD;
        this.group = peerGroup;
        this.localPeerId = peerGroup.getPeerID().toString();
        RefPeerGroup refPeerGroup = ((RefPeerGroup)peerGroup).getParentGroup();
        if (refPeerGroup == null) {
            return;
        }
        this.parentEndpoint = refPeerGroup.getEndpointService();
        if (this.parentEndpoint == null) {
            return;
        }
        Enumeration enumeration = this.parentEndpoint.getEndpointProtocols();
        while (enumeration.hasMoreElements()) {
            this.addEndpointProtocol((EndpointProtocol)enumeration.nextElement());
        }
    }

    public int startApp(String[] stringArray) {
        return 0;
    }

    public void stopApp() {
    }

    public PeerGroup getGroup() {
        return this.group;
    }

    private synchronized void addProtoToAdv(EndpointProtocol endpointProtocol) {
        PeerAdvertisement peerAdvertisement = this.group.getPeerAdvertisement();
        StructuredDocument structuredDocument = peerAdvertisement.getServiceParam(this.assignedID);
        if (structuredDocument == null) {
            structuredDocument = StructuredDocumentFactory.newStructuredDocument(new MimeMediaType("text", "xml"), "Parm");
        }
        Element element = structuredDocument.createElement("Addr", endpointProtocol.getPublicAddress().toString());
        structuredDocument.appendChild(element);
        peerAdvertisement.putServiceParam(this.assignedID, structuredDocument);
    }

    private void clearProtoFromAdv(EndpointProtocol endpointProtocol) {
        PeerAdvertisement peerAdvertisement = this.group.getPeerAdvertisement();
        StructuredDocument structuredDocument = peerAdvertisement.getServiceParam(this.assignedID);
        if (structuredDocument == null) {
            return;
        }
        StructuredDocument structuredDocument2 = StructuredDocumentFactory.newStructuredDocument(new MimeMediaType("text", "xml"), "Parm");
        String string = endpointProtocol.getPublicAddress().toString();
        Enumeration enumeration = structuredDocument.getChildren();
        while (enumeration.hasMoreElements()) {
            TextElement textElement = (TextElement)enumeration.nextElement();
            if (textElement.getName().equals("Addr") && textElement.getTextValue().equals(string)) continue;
            Element element = structuredDocument2.createElement(textElement.getName(), textElement.getTextValue());
            structuredDocument2.appendChild(element);
        }
        peerAdvertisement.putServiceParam(this.assignedID, structuredDocument2);
    }

    public synchronized void addEndpointProtocol(EndpointProtocol endpointProtocol) throws IllegalArgumentException {
        if (this.protocols.contains(endpointProtocol.getProtocolName())) {
            EndpointProtocol endpointProtocol2 = this.parentEndpoint.getEndpointProtocolByName(endpointProtocol.getProtocolName());
            if (endpointProtocol2 == null) {
                if (LOG.isEnabledFor(Priority.WARN)) {
                    LOG.warn((Object)("Duplicate endpoint protocol " + endpointProtocol.getProtocolName() + " rejected."));
                }
                throw new IllegalArgumentException("Duplicate endpoint protocol " + endpointProtocol.getProtocolName() + " rejected.");
            }
            if (endpointProtocol2 != endpointProtocol) {
                if (!endpointProtocol2.allowOverLoad()) {
                    if (LOG.isEnabledFor(Priority.WARN)) {
                        LOG.warn((Object)("Overload endpoint protocol " + endpointProtocol.getProtocolName() + " rejected."));
                    }
                    throw new IllegalArgumentException("Overload endpoint protocol " + endpointProtocol.getProtocolName() + " rejected.");
                }
                if (LOG.isEnabledFor(Priority.INFO)) {
                    LOG.info((Object)("Protocol " + endpointProtocol.getProtocolName() + " hides a protocol of parent endpoint service."));
                }
                this.clearProtoFromAdv(endpointProtocol2);
                this.protocols.remove(endpointProtocol2.getProtocolName());
            }
        }
        this.clearProtoFromAdv(endpointProtocol);
        this.protocols.put(endpointProtocol.getProtocolName(), endpointProtocol);
        this.addProtoToAdv(endpointProtocol);
    }

    public synchronized void removeEndpointProtocol(EndpointProtocol endpointProtocol) {
        Object v = this.protocols.remove(endpointProtocol.getProtocolName());
        if (v != null) {
            this.clearProtoFromAdv(endpointProtocol);
        }
    }

    public Enumeration getEndpointProtocols() {
        return this.protocols.elements();
    }

    public Message newMessage() {
        return new MessageImpl();
    }

    public EndpointAddress newEndpointAddress(String string) {
        return new Address(string);
    }

    public EndpointMessenger getMessenger(EndpointAddress endpointAddress) throws IOException {
        EndpointProtocol endpointProtocol = this.getEndpointProtocolByName(endpointAddress.getProtocolName());
        if (endpointProtocol == null) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("Could not get Protocol for name " + endpointAddress.getProtocolName()));
            }
            throw new IOException("Could not get Protocol for name " + endpointAddress.getProtocolName());
        }
        return endpointProtocol.getMessenger(endpointAddress);
    }

    public void propagate(Message message, String string, String string2) throws IOException {
        EndpointProtocol endpointProtocol = null;
        MessageImpl messageImpl = null;
        Enumeration enumeration = this.protocols.elements();
        while (enumeration.hasMoreElements()) {
            try {
                endpointProtocol = (EndpointProtocol)enumeration.nextElement();
                messageImpl = (MessageImpl)message.clone();
                messageImpl.setString(EndpointHeaderSrcPeer, this.localPeerId);
                message = this.processFilters(message, endpointProtocol.getPublicAddress(), null, false);
                if (message == null) {
                    if (LOG.isEnabledFor(Priority.DEBUG)) {
                        LOG.debug((Object)"   message discarded upon filter decision");
                    }
                    return;
                }
                endpointProtocol.propagate(messageImpl, string, string2, null);
            }
            catch (Exception exception) {
                if (!LOG.isEnabledFor(Priority.WARN)) continue;
                LOG.warn((Object)"Failed to send on endpoint protocol. ", (Throwable)exception);
            }
        }
    }

    private synchronized void addListenerSync(String string, EndpointListener endpointListener) throws IllegalArgumentException {
        if (this.listeners.contains(string)) {
            throw new IllegalArgumentException("listener already present for address " + string);
        }
        this.listeners.put(string, endpointListener);
    }

    public void addListener(String string, EndpointListener endpointListener) throws IllegalArgumentException {
        if (this.parentEndpoint != null) {
            this.parentEndpoint.addListener(string, endpointListener);
        }
        this.addListenerSync(string, new EndpointDemuxListener(string, endpointListener));
    }

    private synchronized boolean removeListenerSync(String string, EndpointListener endpointListener) {
        EndpointDemuxListener endpointDemuxListener = (EndpointDemuxListener)this.listeners.remove(string);
        if (endpointDemuxListener == null) {
            return false;
        }
        if (endpointListener == null) {
            return false;
        }
        if (endpointDemuxListener.getListener() == endpointListener) {
            endpointDemuxListener.unregistered();
            return true;
        }
        this.listeners.put(string, endpointDemuxListener);
        return false;
    }

    public boolean removeListener(String string, EndpointListener endpointListener) {
        if (!this.removeListenerSync(string, endpointListener)) {
            return false;
        }
        if (this.parentEndpoint == null) {
            return true;
        }
        return this.parentEndpoint.removeListener(string, endpointListener);
    }

    private synchronized EndpointListener lookupListener(String string) {
        return (EndpointListener)this.listeners.get(string);
    }

    private synchronized void addFilterListenerSync(String string, EndpointFilterListener endpointFilterListener, boolean bl) throws IllegalArgumentException {
        Hashtable hashtable;
        Hashtable hashtable2 = hashtable = bl ? this.incomingFilterListeners : this.outgoingFilterListeners;
        if (hashtable.contains(string)) {
            throw new IllegalArgumentException("filter istener for " + string + " is already present");
        }
        hashtable.put(string, endpointFilterListener);
    }

    public void addFilterListener(String string, EndpointFilterListener endpointFilterListener, boolean bl) throws IllegalArgumentException {
        int n = string.indexOf(58);
        if (n == -1) {
            this.addFilterListenerNameSpace(string, endpointFilterListener, n, bl);
        } else {
            this.addFilterListenerFullName(string, endpointFilterListener, n, bl);
        }
    }

    private void addFilterListenerNameSpace(String string, EndpointFilterListener endpointFilterListener, int n, boolean bl) throws IllegalArgumentException {
        if (n == 0) {
            throw new IllegalArgumentException("Illegal fullName = \"\"");
        }
        if (this.parentEndpoint != null) {
            this.parentEndpoint.addFilterListener(string, endpointFilterListener, bl);
        }
        this.addFilterListenerSync(string, endpointFilterListener, bl);
    }

    private void addFilterListenerFullName(String string, EndpointFilterListener endpointFilterListener, int n, boolean bl) throws IllegalArgumentException {
        if (n == 0 || string.length() == n + 1) {
            throw new IllegalArgumentException("Illegal fullName: " + string);
        }
        if (this.parentEndpoint != null) {
            this.parentEndpoint.addFilterListener(string, endpointFilterListener, bl);
        }
        this.addFilterListenerSync(string, endpointFilterListener, bl);
    }

    private synchronized void removeFilterListenerSync(String string, EndpointFilterListener endpointFilterListener, boolean bl) {
        Hashtable hashtable;
        Hashtable hashtable2 = hashtable = bl ? this.incomingFilterListeners : this.outgoingFilterListeners;
        if (hashtable.get(string) == endpointFilterListener) {
            hashtable.remove(string);
        }
    }

    public void removeFilterListener(String string, EndpointFilterListener endpointFilterListener, boolean bl) {
        this.removeFilterListenerSync(string, endpointFilterListener, bl);
        if (this.parentEndpoint != null) {
            this.parentEndpoint.removeFilterListener(string, endpointFilterListener, bl);
        }
    }

    private synchronized EndpointFilterListener lookupFilterListener(String string, boolean bl) {
        if (bl) {
            return (EndpointFilterListener)this.incomingFilterListeners.get(string);
        }
        return (EndpointFilterListener)this.outgoingFilterListeners.get(string);
    }

    /*
     * Unable to fully structure code
     */
    private Message processFilters(Message var1_1, EndpointAddress var2_2, EndpointAddress var3_3, boolean var4_4) {
        var5_5 = var1_1.getNames();
        if (var5_5 != null && var5_5.hasMoreElements()) ** GOTO lbl21
        return var1_1;
lbl-1000:
        // 1 sources

        {
            try {
                var7_8 = var6_6 = var5_5.nextString();
                var8_9 = this.lookupFilterListener(var6_6, var4_4);
                if (var8_9 == null) {
                    var9_10 = MessageElement.parseName(var6_6);
                    var8_9 = this.lookupFilterListener(var9_10[0], var4_4);
                    var7_8 = var9_10[0];
                }
                if (var8_9 != null) {
                    if (EndpointServiceImpl.LOG.isEnabledFor(Priority.DEBUG)) {
                        EndpointServiceImpl.LOG.debug((Object)("   invoking filter listener: " + var7_8));
                    }
                    if ((var1_1 = var8_9.processIncomingMessage(var1_1, var2_2, var3_3)) == null) {
                        return null;
                    }
                }
                continue;
            }
            catch (Exception var6_7) {
                if (EndpointServiceImpl.LOG.isEnabledFor(Priority.WARN)) {
                    EndpointServiceImpl.LOG.warn((Object)("process filter failed with " + var6_7));
                }
                return null;
            }
lbl21:
            // 2 sources

            ** while (var5_5.hasMoreElements())
        }
lbl22:
        // 1 sources

        return var1_1;
    }

    public void demux(Message message) throws IOException {
        EndpointListener endpointListener;
        EndpointAddress endpointAddress = message.getDestinationAddress();
        if (endpointAddress == null) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"demux: no destination address. Discard");
            }
            return;
        }
        EndpointAddress endpointAddress2 = message.getSourceAddress();
        String string = null;
        Object var5_5 = null;
        string = message.getString(EndpointHeaderSrcPeer);
        if (string != null && string.equals(this.localPeerId)) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"   discard loopback");
            }
            return;
        }
        if (!((MessageImpl)message).filtered) {
            ((MessageImpl)message).filtered = true;
            if ((message = this.processFilters(message, endpointAddress2, endpointAddress, true)) == null) {
                return;
            }
        }
        String string2 = endpointAddress.getServiceName();
        String string3 = endpointAddress.getServiceParameter();
        if (string2 == null) {
            string2 = "";
        }
        if (string3 == null) {
            string3 = "";
        }
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("serviceName = " + string2));
        }
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("serviceParam = " + string3));
        }
        if ((endpointListener = this.lookupListener(string2 + string3)) == null) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"demux: no listener for this kind of message: ");
            }
            return;
        }
        endpointListener.processIncomingMessage(message, endpointAddress2, endpointAddress);
    }

    public EndpointProtocol getEndpointProtocolByName(String string) {
        return (EndpointProtocol)this.protocols.get(string);
    }

    public boolean ping(EndpointAddress endpointAddress) {
        if (endpointAddress == null) {
            return false;
        }
        try {
            String string = endpointAddress.getProtocolName();
            EndpointProtocol endpointProtocol = this.getEndpointProtocolByName(string);
            return endpointProtocol.ping(endpointAddress);
        }
        catch (Exception exception) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("Exeption while trying to ping " + endpointAddress + ": " + exception));
            }
            return false;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

