/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import net.jxta.discovery.DiscoveryService;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.TextElement;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointListener;
import net.jxta.endpoint.EndpointMessenger;
import net.jxta.endpoint.EndpointProtocol;
import net.jxta.endpoint.EndpointService;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.exception.DiscardQueryException;
import net.jxta.exception.NoResponseException;
import net.jxta.exception.PeerGroupException;
import net.jxta.exception.ResendQueryException;
import net.jxta.id.ID;
import net.jxta.impl.endpoint.Address;
import net.jxta.impl.endpoint.EndpointRouterMessage;
import net.jxta.impl.endpoint.LoopbackMessenger;
import net.jxta.impl.protocol.ResolverQuery;
import net.jxta.impl.protocol.ResolverResponse;
import net.jxta.peergroup.PeerGroup;
import net.jxta.platform.Module;
import net.jxta.protocol.EndpointAdvertisement;
import net.jxta.protocol.PeerAdvertisement;
import net.jxta.protocol.ResolverQueryMsg;
import net.jxta.protocol.ResolverResponseMsg;
import net.jxta.resolver.QueryHandler;
import net.jxta.resolver.ResolverService;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public class EndpointRouter
implements EndpointProtocol,
QueryHandler,
EndpointListener,
Module {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$endpoint$EndpointRouter == null ? (class$net$jxta$impl$endpoint$EndpointRouter = EndpointRouter.class$("net.jxta.impl.endpoint.EndpointRouter")) : class$net$jxta$impl$endpoint$EndpointRouter).getName());
    private Hashtable routedRoutes = null;
    private Hashtable directRoutes = null;
    protected String localPeerAddr = null;
    protected ID localPeerId = null;
    private EndpointService endpoint = null;
    private DiscoveryService discovery = null;
    private PeerGroup group = null;
    private static final String TypeTag = "Type";
    private static final String RoutingPeerIdTag = "RoutingPeer";
    private static final String RoutingPeerAdvTag = "RoutingPeerAdv";
    private static final String DestPeerIdTag = "DestPeer";
    private static final String NbOfHopsTag = "NbOfHops";
    public static final String GatewayForwardTag = "GatewayForward";
    public static final String GatewayReverseTag = "GatewayReverse";
    private static final String VersionTag = "Version";
    private static final String RouteQuery = "RouteQuery";
    private static final String RouteResponse = "RouteResponse";
    private static final String PingQuery = "PingQuery";
    private static final String PingResponse = "PingResponse";
    private static final String NACK = "NACK";
    private static final int acceptableVersion = 3;
    private static final int currentVersion = 3;
    private ResolverService resolver = null;
    private boolean servicesInitialized = false;
    private int qid = 0;
    private static final String routerSName = "EndpointRouter";
    private static String routerSParam = null;
    private EndpointAdvertisement myAdv = null;
    private String localPeerAdv = null;
    protected Vector localGateway = new Vector(1);
    private static String routerPName = "jxta";
    private Vector pendingQueries = new Vector();
    private Hashtable triedAndFailed = new Hashtable();
    static /* synthetic */ Class class$net$jxta$impl$endpoint$EndpointRouter;

    public boolean allowOverLoad() {
        return true;
    }

    public int startApp(String[] stringArray) {
        this.discovery = this.group.getDiscoveryService();
        this.resolver = this.group.getResolverService();
        if (null == this.discovery && LOG.isEnabledFor(Priority.WARN)) {
            LOG.warn((Object)"discovery service is not available!");
        }
        if (null == this.resolver && LOG.isEnabledFor(Priority.WARN)) {
            LOG.warn((Object)"resolver service is not available!");
        }
        this.resolver.registerHandler(routerSName, this);
        return 0;
    }

    public void stopApp() {
        if (this.resolver != null) {
            this.resolver.unregisterHandler(routerSName);
        }
        if (this.endpoint != null) {
            this.endpoint.removeListener(routerSName + routerSParam, this);
            this.endpoint.removeEndpointProtocol(this);
        }
    }

    public void init(PeerGroup peerGroup, ID iD, Advertisement advertisement) throws PeerGroupException {
        block3: {
            this.group = peerGroup;
            this.endpoint = peerGroup.getEndpointService();
            this.localPeerAdv = this.advToString(peerGroup.getPeerAdvertisement());
            this.localPeerId = peerGroup.getPeerID();
            this.localPeerAddr = routerPName + "://" + this.group.getPeerID().getUniqueValue().toString();
            routerSParam = peerGroup.getPeerGroupID().getUniqueValue().toString();
            try {
                this.localGateway.add(0, this.localPeerAddr);
            }
            catch (Exception exception) {
                if (!LOG.isEnabledFor(Priority.WARN)) break block3;
                LOG.warn((Object)"Cannot set myself as a gateway");
            }
        }
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("localPeerId = " + this.localPeerId));
        }
        this.directRoutes = new Hashtable();
        this.routedRoutes = new Hashtable();
        this.endpoint.addListener(routerSName + routerSParam, this);
        this.endpoint.addEndpointProtocol(this);
    }

    public boolean isConnectionOriented() {
        return false;
    }

    public boolean allowRouting() {
        return false;
    }

    public EndpointAddress getPublicAddress() {
        return this.endpoint.newEndpointAddress(this.localPeerAddr);
    }

    public String getProtocolName() {
        return routerPName;
    }

    public void propagate(Message message, String string, String string2, String string3) throws IOException {
    }

    public void close() {
        this.endpoint.removeListener(routerSName + routerSParam, this);
    }

    private String advToString(Advertisement advertisement) {
        StringWriter stringWriter = new StringWriter();
        MimeMediaType mimeMediaType = new MimeMediaType("text/xml");
        try {
            StructuredTextDocument structuredTextDocument = (StructuredTextDocument)advertisement.getDocument(mimeMediaType);
            structuredTextDocument.sendToWriter(stringWriter);
            return stringWriter.toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Enumeration getPeerAdv(String string) {
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("getPeerAdv for : " + string));
        }
        if (this.discovery == null) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"  no discovery");
            }
            return null;
        }
        try {
            EndpointAddress endpointAddress = this.endpoint.newEndpointAddress(string);
            URL uRL = new URL("urn", "", "jxta:" + endpointAddress.getProtocolAddress());
            String string2 = uRL.toString();
            return this.discovery.getLocalAdvertisements(0, "PID", string2);
        }
        catch (Exception exception) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("  failed with " + exception));
            }
            return null;
        }
    }

    private synchronized void waitABit() {
        block2: {
            try {
                this.wait(500L);
            }
            catch (Exception exception) {
                if (!LOG.isEnabledFor(Priority.DEBUG)) break block2;
                LOG.debug((Object)("getAddress got an exception " + exception + " while waiting"));
            }
        }
    }

    public EndpointAddress getAddress(String string) {
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"getAddress for ");
        }
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("      peer= " + string));
        }
        Route route = null;
        int n = 0;
        while (true) {
            this.learnLocalRoute(string);
            if (this.isLocalRoute(string)) {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)("Found local address: " + string + " -> " + this.getLocalRoute(string).toString()));
                }
                return this.getLocalRoute(string);
            }
            route = this.getRoute(string);
            EndpointAddress endpointAddress = null;
            if (route != null) {
                try {
                    endpointAddress = this.getLocalRoute(route.router);
                    if (endpointAddress != null) {
                        if (LOG.isEnabledFor(Priority.DEBUG)) {
                            LOG.debug((Object)("Found remote address: " + string + " -> " + endpointAddress.toString()));
                        }
                    } else if (LOG.isEnabledFor(Priority.DEBUG)) {
                        LOG.debug((Object)"Found an not reachable route");
                    }
                    return endpointAddress;
                }
                catch (Exception exception) {
                    if (LOG.isEnabledFor(Priority.DEBUG)) {
                        LOG.debug((Object)("getAddress for " + string));
                    }
                    if (LOG.isEnabledFor(Priority.DEBUG)) {
                        LOG.debug((Object)("     failed with " + exception));
                    }
                    return null;
                }
            }
            if (n == 0) {
                this.findRoute(string);
            }
            if (++n > 120) {
                if (!LOG.isEnabledFor(Priority.DEBUG)) break;
                LOG.debug((Object)("getAddress is giving up for " + string));
                break;
            }
            this.waitABit();
        }
        return null;
    }

    public EndpointAddress getBestLocalRoute(Enumeration enumeration) {
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"getBestLocalRoute:");
        }
        EndpointProtocol endpointProtocol = null;
        EndpointAddress endpointAddress = null;
        EndpointAddress endpointAddress2 = null;
        String string = null;
        boolean bl = false;
        boolean bl2 = false;
        while (enumeration.hasMoreElements()) {
            try {
                endpointAddress = (EndpointAddress)enumeration.nextElement();
                string = endpointAddress.getProtocolName();
                if (string.equals(this.getProtocolName())) continue;
                endpointProtocol = this.endpoint.getEndpointProtocolByName(string);
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)("getBestLocalRoute trying: " + endpointAddress.toString() + " on protocol " + endpointProtocol.getProtocolName()));
                }
                if (endpointProtocol == null || !endpointProtocol.allowRouting() || !endpointProtocol.ping(endpointAddress)) continue;
                if (endpointAddress2 == null) {
                    if (LOG.isEnabledFor(Priority.DEBUG)) {
                        LOG.debug((Object)("Found: " + endpointAddress.toString()));
                    }
                    endpointAddress2 = endpointAddress;
                }
                if (endpointProtocol.isConnectionOriented()) {
                    if (bl) {
                        if (!this.isFast(endpointProtocol)) continue;
                        return endpointAddress;
                    }
                    bl = true;
                    if (this.isFast(endpointProtocol)) {
                        return endpointAddress;
                    }
                    endpointAddress2 = endpointAddress;
                    continue;
                }
                if (bl) continue;
                endpointAddress2 = endpointAddress;
            }
            catch (Exception exception) {
                this.triedAndFailed.put(endpointAddress, new Long(System.currentTimeMillis()));
            }
        }
        return endpointAddress2;
    }

    boolean isFast(EndpointProtocol endpointProtocol) {
        String string = endpointProtocol.getProtocolName();
        return string.equals("tcp") || string.equals("beep");
    }

    public boolean ping(EndpointAddress endpointAddress) {
        try {
            return this.getAddress(endpointAddress.getProtocolName() + "://" + endpointAddress.getProtocolAddress()) != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public synchronized boolean isLocalRoute(String string) {
        return this.directRoutes.containsKey(string);
    }

    public synchronized EndpointAddress getLocalRoute(String string) {
        return (EndpointAddress)this.directRoutes.get(string);
    }

    private synchronized void learnLocalRouteSync(String string, EndpointAddress endpointAddress) {
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"learnLocalRoute:");
        }
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("   peerId = " + string));
        }
        try {
            this.directRoutes.put(string, endpointAddress.clone());
        }
        catch (Exception exception) {
            return;
        }
        try {
            this.routedRoutes.remove(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.notifyAll();
    }

    public void learnLocalRoute(String string) {
        if (this.directRoutes.containsKey(string)) {
            return;
        }
        EndpointAddress endpointAddress = this.checkPeer(string);
        if (endpointAddress == null) {
            return;
        }
        this.learnLocalRouteSync(string, endpointAddress);
    }

    public synchronized void removeLocalRoute(String string) {
        try {
            this.directRoutes.remove(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void brokenRoute(String string) {
        if (this.isLocalRoute(string)) {
            this.removeLocalRoute(string);
            return;
        }
        Route route = this.getRoute(string);
        if (route != null) {
            this.removeLocalRoute(route.router);
            this.removeRoute(string);
        }
    }

    public synchronized boolean isRoute(String string) {
        return this.routedRoutes.get(string) != null;
    }

    public synchronized Route getRoute(String string) {
        return (Route)this.routedRoutes.get(string);
    }

    private boolean checkRoute(Route route) {
        if (route == null) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"route is null");
            }
            return false;
        }
        if (route.gateways == null || route.gateways.size() == 0) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"route is empty");
            }
            return false;
        }
        if (route.gateways.contains(this.localPeerAddr)) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"route contains this peer - loopback");
            }
            return false;
        }
        Vector vector = new Vector();
        int n = 0;
        while (n < route.gateways.size()) {
            try {
                if (vector.contains((String)route.gateways.elementAt(n))) {
                    return false;
                }
                vector.add(route.gateways.elementAt(n));
            }
            catch (Exception exception) {
                if (LOG.isEnabledFor(Priority.WARN)) {
                    LOG.warn((Object)("Exception while processing route checking: " + exception));
                }
                return false;
            }
            ++n;
        }
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"route is ok");
        }
        return true;
    }

    private synchronized boolean setRoute(Route route) {
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"setRoute:");
        }
        if (route == null) {
            return false;
        }
        route.display();
        if (this.directRoutes.containsKey(route.dest)) {
            return false;
        }
        if (!this.checkRoute(route)) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"Route is invalid");
            }
            return false;
        }
        if (!this.directRoutes.containsKey(route.router)) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"Unreachable route - ignore");
            }
            return false;
        }
        try {
            String string = (String)route.gateways.elementAt(0);
            if (string != null && !string.equals(route.router)) {
                route.gateways.add(0, route.router);
            }
        }
        catch (Exception exception) {
            if (LOG.isEnabledFor(Priority.WARN)) {
                LOG.warn((Object)"Got an empty route - discard");
            }
            return false;
        }
        try {
            this.routedRoutes.put(route.dest, route);
            this.notifyAll();
            return true;
        }
        catch (Exception exception) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("   failed with " + exception));
            }
            return false;
        }
    }

    public synchronized void removeRoute(String string) {
        try {
            this.routedRoutes.remove(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void processIncomingMessage(Message message, EndpointAddress endpointAddress, EndpointAddress endpointAddress2) {
        block46: {
            EndpointRouterMessage endpointRouterMessage;
            int n;
            EndpointAddress endpointAddress3;
            EndpointAddress endpointAddress4;
            String string;
            String string2;
            String string3;
            block45: {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"processIncomingMessage starts");
                }
                InputStream inputStream = null;
                string3 = null;
                string2 = null;
                string = null;
                endpointAddress4 = null;
                endpointAddress3 = null;
                n = 0;
                endpointRouterMessage = null;
                MessageElement messageElement = message.getElement("JxtaEndpointRouter");
                try {
                    int n2;
                    Vector vector;
                    if (messageElement == null) {
                        if (LOG.isEnabledFor(Priority.DEBUG)) {
                            LOG.debug((Object)"processIncomingMessage: no routing info");
                        }
                        this.endpoint.demux(message);
                        return;
                    }
                    inputStream = messageElement.getStream();
                    if (inputStream == null) {
                        if (LOG.isEnabledFor(Priority.DEBUG)) {
                            LOG.debug((Object)"processIncomingMessage: invalid routing info");
                        }
                        this.endpoint.demux(message);
                        return;
                    }
                    endpointRouterMessage = new EndpointRouterMessage(inputStream);
                    try {
                        n = Integer.parseInt(endpointRouterMessage.getNbOfHops());
                    }
                    catch (Exception exception) {
                        n = 0;
                    }
                    endpointAddress4 = this.endpoint.newEndpointAddress(endpointRouterMessage.getSrcAddress());
                    endpointAddress3 = this.endpoint.newEndpointAddress(endpointRouterMessage.getDestAddress());
                    string3 = endpointAddress4.getProtocolName() + "://" + endpointAddress4.getProtocolAddress();
                    string2 = endpointAddress3.getProtocolName() + "://" + endpointAddress3.getProtocolAddress();
                    string = endpointRouterMessage.getLastHop();
                    if (LOG.isEnabledFor(Priority.DEBUG)) {
                        LOG.debug((Object)("     srcPeer= " + string3));
                    }
                    if (LOG.isEnabledFor(Priority.DEBUG)) {
                        LOG.debug((Object)("    destPeer= " + string2));
                    }
                    if (string != null && LOG.isEnabledFor(Priority.DEBUG)) {
                        LOG.debug((Object)("     lastHop= " + string));
                    }
                    if ((vector = endpointRouterMessage.getForwardGateways()) != null) {
                        if (LOG.isEnabledFor(Priority.DEBUG)) {
                            LOG.debug((Object)"    Forward Gateways:");
                        }
                        n2 = 0;
                        while (n2 < vector.size()) {
                            block43: {
                                try {
                                    if (!LOG.isEnabledFor(Priority.DEBUG)) break block43;
                                    LOG.debug((Object)("   [" + n2 + "] " + (String)vector.elementAt(n2)));
                                }
                                catch (Exception exception) {
                                    break;
                                }
                            }
                            ++n2;
                        }
                    }
                    if ((vector = endpointRouterMessage.getReverseGateways()) != null) {
                        if (LOG.isEnabledFor(Priority.DEBUG)) {
                            LOG.debug((Object)"    Reverse Gateways:");
                        }
                        n2 = 0;
                        while (n2 < vector.size()) {
                            block44: {
                                try {
                                    if (!LOG.isEnabledFor(Priority.DEBUG)) break block44;
                                    LOG.debug((Object)("   [" + n2 + "] " + (String)vector.elementAt(n2)));
                                }
                                catch (Exception exception) {
                                    break block45;
                                }
                            }
                            ++n2;
                        }
                        break block45;
                    }
                    if (n >= 1 && string != null) {
                        Vector<String> vector2 = new Vector<String>(1);
                        vector2.add(string);
                        endpointRouterMessage.setReverseGateways(vector2);
                    }
                }
                catch (Exception exception) {
                    if (LOG.isEnabledFor(Priority.WARN)) {
                        LOG.warn((Object)"Bad routing header or bad message. Message dropped.");
                    }
                    if (LOG.isEnabledFor(Priority.DEBUG)) {
                        LOG.debug((Object)("exception: " + exception));
                    }
                    return;
                }
            }
            if (string3 != null && string3.equals(this.localPeerAddr)) {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"processIncomingMessage: dropped loopback");
                }
                return;
            }
            try {
                if (string != null) {
                    this.triedAndFailed.remove(string);
                    this.learnLocalRoute(string);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            try {
                Object object;
                if (string2.equals(this.localPeerAddr)) {
                    if (n != 0) {
                        this.setRoute(new Route(string3, string, n, endpointRouterMessage.getReverseGateways()));
                    }
                    endpointRouterMessage.setForwardGateways(null);
                    message.removeElement("JxtaEndpointRouter");
                    message.addElement(message.newMessageElement("JxtaEndpointRouter", null, endpointRouterMessage.getInputStream()));
                    message.setSourceAddress(endpointAddress4);
                    message.setDestinationAddress(endpointAddress3);
                    this.endpoint.demux(message);
                    return;
                }
                boolean bl = false;
                String string4 = null;
                if (endpointRouterMessage.getForwardGateways() != null) {
                    string4 = this.getNextHop(endpointRouterMessage.getForwardGateways());
                }
                if (string4 == null) {
                    if (LOG.isEnabledFor(Priority.DEBUG)) {
                        LOG.debug((Object)"No next hop in forward gateways - Try to use destination as next hop");
                    }
                    string4 = string2;
                    endpointRouterMessage.setForwardGateways(null);
                    object = this.getRoute(string2);
                    if (object != null) {
                        endpointRouterMessage.setReverseGateways(((Route)object).gateways);
                    }
                    bl = true;
                }
                if (this.isLocalRoute(string2) && !string4.equals(string2)) {
                    object = this.getRoute(string2);
                    if (object != null) {
                        endpointRouterMessage.setReverseGateways(((Route)object).gateways);
                    }
                    bl = true;
                    string4 = string2;
                }
                if (bl) {
                    message.removeElement("JxtaEndpointRouter");
                    message.addElement(message.newMessageElement("JxtaEndpointRouter", null, endpointRouterMessage.getInputStream()));
                }
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)("forwarding to " + string4));
                }
                object = this.getTransportMessenger(string4, true);
                RouterMessenger routerMessenger = new RouterMessenger((EndpointMessenger)object, endpointAddress3, this.endpoint, this);
                routerMessenger.sendMessage(message);
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"Message has been forwarded to the next hop");
                }
            }
            catch (Exception exception) {
                if (!LOG.isEnabledFor(Priority.DEBUG)) break block46;
                LOG.debug((Object)("failed to deliver or forward: " + exception));
            }
        }
    }

    private String getNextHop(Vector vector) {
        if (vector == null || vector.size() == 0) {
            return null;
        }
        String string = null;
        int n = vector.indexOf(this.localPeerAddr);
        if (n == -1) {
            try {
                string = (String)vector.elementAt(0);
            }
            catch (Exception exception) {
                return null;
            }
            return string;
        }
        try {
            string = (String)vector.elementAt(n + 1);
        }
        catch (Exception exception) {
            return null;
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public EndpointAddress checkPeer(String string) {
        Long l;
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("checkPeer peer= " + string));
        }
        if ((l = (Long)this.triedAndFailed.get(string)) != null) {
            long l2 = System.currentTimeMillis() - l;
            if (l2 > 0L && l2 < 300000L) {
                return null;
            }
            this.triedAndFailed.remove(string);
        }
        Enumeration enumeration = null;
        PeerAdvertisement peerAdvertisement = null;
        try {
            enumeration = this.getPeerAdv(string);
            if (enumeration == null || !enumeration.hasMoreElements()) {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"   no advertisement");
                }
                return null;
            }
            block4: while (enumeration.hasMoreElements()) {
                peerAdvertisement = (PeerAdvertisement)enumeration.nextElement();
                TextElement textElement = (TextElement)((Object)peerAdvertisement.getServiceParam(PeerGroup.endpointClassID));
                if (textElement == null) {
                    if (!LOG.isEnabledFor(Priority.DEBUG)) continue;
                    LOG.debug((Object)"checkPeer: no Endpoint Params");
                    continue;
                }
                Enumeration enumeration2 = textElement.getChildren("Addr");
                if (!enumeration2.hasMoreElements()) {
                    if (!LOG.isEnabledFor(Priority.DEBUG)) continue;
                    LOG.debug((Object)"checkPeer: no Addresses in adv");
                    continue;
                }
                Vector<EndpointAddress> vector = new Vector<EndpointAddress>();
                while (true) {
                    Object object;
                    if (!enumeration2.hasMoreElements()) {
                        if (vector.size() <= 0) continue block4;
                        object = null;
                        object = this.getBestLocalRoute(vector.elements());
                        if (object == null) continue block4;
                        if (LOG.isEnabledFor(Priority.DEBUG)) {
                            LOG.debug((Object)"found direct route");
                        }
                        return object;
                    }
                    object = "";
                    try {
                        object = ((TextElement)enumeration2.nextElement()).getTextValue();
                        vector.addElement(this.endpoint.newEndpointAddress((String)object));
                    }
                    catch (Exception exception) {
                        if (!LOG.isEnabledFor(Priority.DEBUG)) continue;
                        LOG.debug((Object)"bad address");
                    }
                }
            }
        }
        catch (Exception exception) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("    failed with " + exception));
            }
            this.triedAndFailed.put(string, new Long(System.currentTimeMillis()));
            return null;
        }
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"   did not find a good route");
        }
        this.triedAndFailed.put(string, new Long(System.currentTimeMillis()));
        return null;
    }

    private void findRoute(String string) {
        block8: {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"findRoute starts");
            }
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("      peer= " + string));
            }
            if (this.pendingQueries.contains(string)) {
                return;
            }
            this.pendingQueries.addElement(string);
            try {
                StructuredTextDocument structuredTextDocument = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(new MimeMediaType("text/xml"), "jxta:EndpointRouter");
                TextElement textElement = null;
                textElement = structuredTextDocument.createElement(TypeTag, RouteQuery);
                structuredTextDocument.appendChild((Element)textElement);
                textElement = structuredTextDocument.createElement(DestPeerIdTag, string);
                structuredTextDocument.appendChild((Element)textElement);
                textElement = structuredTextDocument.createElement(RoutingPeerAdvTag, this.localPeerAdv);
                structuredTextDocument.appendChild((Element)textElement);
                StringWriter stringWriter = new StringWriter();
                structuredTextDocument.sendToWriter(stringWriter);
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"findRoute sends query EndpointRouter");
                }
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)("findRoute sends query for peer : " + string));
                }
                ResolverQuery resolverQuery = new ResolverQuery(routerSName, null, this.localPeerId.toString(), stringWriter.toString(), this.qid++);
                this.resolver.sendQuery(null, resolverQuery);
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"getAddress() query sent");
                }
            }
            catch (Exception exception) {
                if (!LOG.isEnabledFor(Priority.DEBUG)) break block8;
                LOG.debug((Object)"Exception in findRoute", (Throwable)exception);
            }
        }
        this.pendingQueries.remove(string);
    }

    public void processResponse(ResolverResponseMsg resolverResponseMsg) {
        int n;
        Vector<String> vector;
        String string;
        String string2;
        block33: {
            Object object;
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"processResponse got a response");
            }
            Enumeration enumeration = null;
            string2 = null;
            String string3 = null;
            string = null;
            MimeMediaType mimeMediaType = null;
            Object var7_7 = null;
            try {
                mimeMediaType = new MimeMediaType("text/xml");
            }
            catch (RuntimeException runtimeException) {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)("processResponse: cannot get MimeMediaType " + runtimeException));
                }
                return;
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(resolverResponseMsg.getResponse().getBytes());
            StructuredDocument structuredDocument = null;
            try {
                structuredDocument = StructuredDocumentFactory.newStructuredDocument(mimeMediaType, byteArrayInputStream);
            }
            catch (Exception exception) {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"processResponse: malformed response - discard");
                }
                return;
            }
            vector = new Vector<String>();
            n = 0;
            int n2 = 0;
            String string4 = null;
            enumeration = structuredDocument.getChildren();
            while (enumeration.hasMoreElements()) {
                object = (TextElement)enumeration.nextElement();
                if (object.getName().equals(DestPeerIdTag)) {
                    string = (String)object.getValue();
                    continue;
                }
                if (object.getName().equals(RoutingPeerIdTag)) {
                    string2 = (String)object.getValue();
                    continue;
                }
                if (object.getName().equals(RoutingPeerAdvTag)) {
                    string3 = (String)object.getValue();
                    continue;
                }
                if (object.getName().equals(NbOfHopsTag)) {
                    try {
                        n = Integer.parseInt((String)object.getValue());
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (!LOG.isEnabledFor(Priority.WARN)) continue;
                        LOG.warn((Object)"Cannot parse nbOfHops");
                    }
                    continue;
                }
                if (object.getName().equals(VersionTag)) {
                    try {
                        n2 = Integer.parseInt((String)object.getValue());
                    }
                    catch (Exception exception) {
                        if (!LOG.isEnabledFor(Priority.DEBUG)) continue;
                        LOG.debug((Object)"cannot decode version");
                    }
                    continue;
                }
                if (object.getName().equals(TypeTag)) {
                    string4 = (String)object.getValue();
                    continue;
                }
                if (!object.getName().equals(GatewayForwardTag)) continue;
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)("Gateway forward adding " + (String)object.getValue()));
                }
                vector.addElement((String)object.getValue());
            }
            if (n2 < 3) {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)("reject answer. Wrong version " + n2));
                }
                return;
            }
            if (string4 == null) {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"No type: invalid.");
                }
                return;
            }
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("processResponse got message of type " + string4));
            }
            if (!string4.equals(RouteResponse)) {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)("unimplemented: " + string4));
                }
                return;
            }
            if (string2 == null || string == null) {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"processResponse: malformed response - discard.");
                }
                return;
            }
            if (string3 != null) {
                object = null;
                try {
                    object = AdvertisementFactory.newAdvertisement(new MimeMediaType("text/xml"), new ByteArrayInputStream(string3.getBytes()));
                    this.discovery.publish((Advertisement)object, 0, 0x6DDD00L, 0x6DDD00L);
                }
                catch (Exception exception) {
                    if (!LOG.isEnabledFor(Priority.DEBUG)) break block33;
                    LOG.debug((Object)("   no advertisement " + exception));
                }
            }
        }
        this.triedAndFailed.remove(string2);
        if (string.equals(string2)) {
            this.learnLocalRoute(string2);
        } else {
            this.learnLocalRoute(string2);
            this.setRoute(new Route(string, string2, n, vector));
        }
    }

    public ResolverResponseMsg processQuery(ResolverQueryMsg resolverQueryMsg) throws NoResponseException, IOException, ResendQueryException, DiscardQueryException {
        Object object;
        String string;
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"processQuery starts");
        }
        MimeMediaType mimeMediaType = null;
        try {
            mimeMediaType = new MimeMediaType("text/xml");
        }
        catch (RuntimeException runtimeException) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("Malformed query [1] " + runtimeException));
            }
            throw new IOException();
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(resolverQueryMsg.getQuery().getBytes());
        StructuredTextDocument structuredTextDocument = null;
        try {
            structuredTextDocument = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(mimeMediaType, byteArrayInputStream);
        }
        catch (Exception exception) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("processQuery: malformed request [2] " + exception));
            }
            throw new IOException();
        }
        String string2 = null;
        String string3 = null;
        Enumeration enumeration = structuredTextDocument.getChildren();
        while (enumeration.hasMoreElements()) {
            TextElement textElement = (TextElement)enumeration.nextElement();
            if (textElement.getName().equals(DestPeerIdTag)) {
                string2 = (String)textElement.getValue();
                continue;
            }
            if (textElement.getName().equals(TypeTag)) {
                string3 = (String)textElement.getValue();
                continue;
            }
            if (!textElement.getName().equals(RoutingPeerAdvTag)) continue;
            string = (String)textElement.getValue();
            object = null;
            try {
                object = (PeerAdvertisement)AdvertisementFactory.newAdvertisement(new MimeMediaType("text/xml"), new ByteArrayInputStream(string.getBytes()));
                if (((PeerAdvertisement)object).getPeerID().equals(this.localPeerId)) continue;
                this.discovery.publish((Advertisement)object, 0, 0x6DDD00L, 0x6DDD00L);
            }
            catch (Exception exception) {
                if (!LOG.isEnabledFor(Priority.DEBUG)) continue;
                LOG.debug((Object)exception);
            }
        }
        if (string3 == null) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"No type: invalid.");
            }
            throw new DiscardQueryException();
        }
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("  type=  " + string3));
        }
        if (!string3.equals(RouteQuery)) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("unimplemented: " + string3));
            }
            throw new DiscardQueryException();
        }
        if (string2 == null) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"processQuery: malformed request, no PeerId.");
            }
            throw new IOException();
        }
        int n = resolverQueryMsg.getQueryId();
        string = string2;
        object = null;
        boolean bl = false;
        if (string.equals(this.localPeerAddr)) {
            bl = true;
        } else if (this.group.isRendezvous()) {
            if (this.isLocalRoute(string)) {
                bl = true;
            } else {
                object = this.getRoute(string);
                if (object != null) {
                    bl = true;
                }
            }
        }
        if (!bl) {
            if (!this.group.isRendezvous()) {
                throw new DiscardQueryException();
            }
            throw new NoResponseException();
        }
        try {
            Object object2;
            Object object3;
            structuredTextDocument = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(new MimeMediaType("text/xml"), "jxta:EndpointRouter");
            TextElement textElement = null;
            textElement = structuredTextDocument.createElement(VersionTag, Integer.toString(3));
            structuredTextDocument.appendChild((Element)textElement);
            textElement = structuredTextDocument.createElement(TypeTag, RouteResponse);
            structuredTextDocument.appendChild((Element)textElement);
            textElement = structuredTextDocument.createElement(DestPeerIdTag, string);
            structuredTextDocument.appendChild((Element)textElement);
            textElement = structuredTextDocument.createElement(RoutingPeerIdTag, this.localPeerAddr);
            structuredTextDocument.appendChild((Element)textElement);
            textElement = object != null ? structuredTextDocument.createElement(NbOfHopsTag, String.valueOf(((Route)object).nbOfHops + 1)) : structuredTextDocument.createElement(NbOfHopsTag, String.valueOf(1));
            structuredTextDocument.appendChild((Element)textElement);
            if (this.localPeerAdv != null) {
                textElement = structuredTextDocument.createElement(RoutingPeerAdvTag, this.localPeerAdv);
                structuredTextDocument.appendChild((Element)textElement);
            }
            textElement = structuredTextDocument.createElement(GatewayForwardTag, this.localPeerAddr);
            structuredTextDocument.appendChild((Element)textElement);
            if (object != null) {
                object3 = ((Route)object).gateways;
                object2 = null;
                if (object3 != null && ((Vector)object3).size() > 0) {
                    int n2 = 0;
                    while (n2 < ((Vector)object3).size()) {
                        try {
                            object2 = (String)((Vector)object3).elementAt(n2);
                            textElement = structuredTextDocument.createElement(GatewayForwardTag, (String)object2);
                            structuredTextDocument.appendChild((Element)textElement);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        ++n2;
                    }
                }
            }
            object3 = new StringWriter();
            structuredTextDocument.sendToWriter((Writer)object3);
            object2 = new ResolverResponse(routerSName, null, n, ((StringWriter)object3).toString());
            return object2;
        }
        catch (Exception exception) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"processQuery: error while processing query: ", (Throwable)exception);
            }
            throw new IOException();
        }
    }

    public EndpointMessenger getMessenger(EndpointAddress endpointAddress) throws IOException {
        String string = endpointAddress.getProtocolName() + "://" + endpointAddress.getProtocolAddress();
        if (string.equals(this.localPeerAddr)) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"getMessenger: return LoopbackMessenger");
            }
            return new LoopbackMessenger(this.endpoint, this.endpoint.newEndpointAddress(this.localPeerAddr), endpointAddress);
        }
        EndpointMessenger endpointMessenger = this.getTransportMessenger(string, false);
        return new RouterMessenger(endpointMessenger, endpointAddress, this.endpoint, this);
    }

    private EndpointMessenger getTransportMessenger(String string, boolean bl) throws IOException {
        EndpointMessenger endpointMessenger = null;
        boolean bl2 = true;
        while (bl2) {
            bl2 = false;
            Address address = null;
            address = bl ? (Address)this.getLocalRoute(string) : (Address)this.getAddress(string);
            if (address == null) {
                if (LOG.isEnabledFor(Priority.WARN)) {
                    LOG.warn((Object)"getTransportMessenger: no address");
                }
                throw new IOException("getTransportMessenger: no address");
            }
            address = (Address)address.clone();
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("getMessenger(). dest peer= " + string + "using = " + address.toString()));
            }
            address.setServiceName(routerSName);
            address.setServiceParameter(routerSParam);
            try {
                endpointMessenger = this.endpoint.getMessenger(address);
                break;
            }
            catch (IOException iOException) {
                this.brokenRoute(string);
            }
        }
        if (endpointMessenger == null) {
            if (LOG.isEnabledFor(Priority.INFO)) {
                LOG.info((Object)("getMessenger: no messenger to " + string));
            }
            throw new IOException("getTransportMessenger: no messenger");
        }
        return endpointMessenger;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class RouterMessenger
    implements EndpointMessenger {
        protected EndpointMessenger messenger = null;
        protected EndpointAddress destAddress = null;
        protected EndpointRouter router = null;

        public RouterMessenger(EndpointMessenger endpointMessenger, EndpointAddress endpointAddress, EndpointService endpointService, EndpointRouter endpointRouter2) {
            if (endpointMessenger == null) {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"null messenger!");
                }
                throw new IllegalArgumentException("null messenger!");
            }
            this.messenger = endpointMessenger;
            this.destAddress = endpointAddress;
            this.router = endpointRouter2;
        }

        public void sendMessage(Message message) throws IOException {
            block33: {
                EndpointRouterMessage endpointRouterMessage;
                block30: {
                    block31: {
                        String string;
                        if (LOG.isEnabledFor(Priority.DEBUG)) {
                            LOG.debug((Object)"EndpointRouterMessenger.sendMessage starts");
                        }
                        InputStream inputStream = null;
                        endpointRouterMessage = null;
                        MessageElement messageElement = message.getElement("JxtaEndpointRouter");
                        if (messageElement != null && (inputStream = messageElement.getStream()) != null) {
                            try {
                                endpointRouterMessage = new EndpointRouterMessage(inputStream);
                            }
                            catch (Exception exception) {
                                endpointRouterMessage = null;
                            }
                        }
                        if (endpointRouterMessage == null) {
                            if (LOG.isEnabledFor(Priority.DEBUG)) {
                                LOG.debug((Object)"Create a new EndpointRouterMessage");
                            }
                            endpointRouterMessage = new EndpointRouterMessage();
                            endpointRouterMessage.setSrcAddress(this.router.localPeerAddr);
                            endpointRouterMessage.setNbOfHops("1");
                            try {
                                Route route = this.router.getRoute(this.destAddress.getProtocolName() + "://" + this.destAddress.getProtocolAddress());
                                if (route != null && route.gateways != null) {
                                    endpointRouterMessage.setForwardGateways(route.gateways);
                                }
                                break block30;
                            }
                            catch (Exception exception) {
                                if (LOG.isEnabledFor(Priority.WARN)) {
                                    LOG.warn((Object)"Cannot set forward gateways");
                                }
                                break block30;
                            }
                        }
                        if (LOG.isEnabledFor(Priority.DEBUG)) {
                            LOG.debug((Object)"Using EndpointRouterMessage");
                        }
                        if ((string = endpointRouterMessage.getDestAddress()) != null && !string.equals(this.destAddress.toString())) {
                            endpointRouterMessage.setForwardGateways(null);
                            try {
                                Route route = this.router.getRoute(this.destAddress.toString());
                                if (route != null && route.gateways != null) {
                                    endpointRouterMessage.setForwardGateways(route.gateways);
                                    int n = route.gateways.size() + 1;
                                    endpointRouterMessage.setNbOfHops(String.valueOf(n));
                                }
                            }
                            catch (Exception exception) {
                                if (!LOG.isEnabledFor(Priority.WARN)) break block31;
                                LOG.warn((Object)"Cannot set forward gateways");
                            }
                        }
                    }
                    boolean bl = false;
                    if (endpointRouterMessage.getReverseGateways() != null && !(bl = EndpointRouter.this.isLocalRoute(endpointRouterMessage.getLastHop()))) {
                        endpointRouterMessage.setReverseGateways(null);
                    }
                    if (!bl) {
                        bl = EndpointRouter.this.getRoute(endpointRouterMessage.getSrcAddress()) != null ? true : EndpointRouter.this.isLocalRoute(endpointRouterMessage.getSrcAddress());
                    }
                    if (bl) {
                        Vector<String> vector;
                        block32: {
                            if (LOG.isEnabledFor(Priority.DEBUG)) {
                                LOG.debug((Object)"    setting reverse remote route");
                            }
                            if ((vector = endpointRouterMessage.getReverseGateways()) == null) {
                                vector = new Vector<String>(1);
                            }
                            try {
                                vector.add(0, EndpointRouter.this.localPeerAddr);
                            }
                            catch (Exception exception) {
                                if (!LOG.isEnabledFor(Priority.WARN)) break block32;
                                LOG.warn((Object)"Cannot insert local peer id in the reverse route");
                            }
                        }
                        try {
                            endpointRouterMessage.setNbOfHops(String.valueOf(Integer.parseInt(endpointRouterMessage.getNbOfHops()) + 1));
                        }
                        catch (Exception exception) {
                            if (LOG.isEnabledFor(Priority.WARN)) {
                                LOG.warn((Object)("Got exception while trying to set the nbofHops " + exception));
                            }
                            endpointRouterMessage.setNbOfHops("0");
                        }
                        endpointRouterMessage.setReverseGateways(vector);
                    } else {
                        if (LOG.isEnabledFor(Priority.DEBUG)) {
                            LOG.debug((Object)"     no reverse route");
                        }
                        endpointRouterMessage.setNbOfHops("0");
                        endpointRouterMessage.setReverseGateways(null);
                    }
                }
                endpointRouterMessage.setDestAddress(this.destAddress.toString());
                endpointRouterMessage.setLastHop(this.router.localPeerAddr);
                try {
                    message.addElement(message.newMessageElement("JxtaEndpointRouter", null, endpointRouterMessage.getInputStream()));
                }
                catch (Exception exception) {
                    if (!LOG.isEnabledFor(Priority.DEBUG)) break block33;
                    LOG.debug((Object)"Can't push header");
                }
            }
            if (this.messenger == null) {
                throw new IOException();
            }
            this.messenger.sendMessage(message);
        }

        public void close() {
        }
    }

    protected class Route {
        public String dest = null;
        public String router = null;
        public int nbOfHops = 0;
        public Vector gateways = null;

        public Route(String string, String string2, int n, Vector vector) {
            this.dest = string;
            this.router = string2;
            this.nbOfHops = n;
            this.gateways = vector;
        }

        public void display() {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("Route to    = " + this.dest));
            }
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("    nextHop = " + this.router));
            }
            if (this.gateways == null) {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"    no gateways");
                }
            } else {
                int n = 0;
                while (n < this.gateways.size()) {
                    try {
                        if (LOG.isEnabledFor(Priority.DEBUG)) {
                            LOG.debug((Object)("   [" + n + "] " + (String)this.gateways.elementAt(n)));
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ++n;
                }
            }
        }
    }
}

